/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.android.AndroidResourceExternalAnnotatorBase;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaResourceExternalAnnotator
extends AndroidResourceExternalAnnotatorBase {
    @Override
    @Nullable
    protected AndroidResourceExternalAnnotatorBase.FileAnnotationInfo collectInformation(@NotNull PsiFile file, @NotNull Editor editor2) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        final AndroidResourceExternalAnnotatorBase.FileAnnotationInfo annotationInfo = new AndroidResourceExternalAnnotatorBase.FileAnnotationInfo(facet, file, editor2);
        file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement element) {
                ResourceType type = AndroidPsiUtils.getResourceType((PsiElement)element);
                if (type == ResourceType.COLOR || type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP) {
                    AndroidPsiUtils.ResourceReferenceType referenceType = AndroidPsiUtils.getResourceReferenceType((PsiElement)element);
                    ResourceNamespace namespace = referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK ? ResourceNamespace.ANDROID : ResourceNamespace.RES_AUTO;
                    String name = AndroidPsiUtils.getResourceName((PsiElement)element);
                    ResourceReference reference2 = new ResourceReference(namespace, type, name);
                    annotationInfo.getElements().add(new AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement(reference2, (PsiElement)element));
                }
            }
        });
        if (annotationInfo.getElements().isEmpty()) {
            return null;
        }
        return annotationInfo;
    }
}

