/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.startup.Actions;
import com.android.tools.idea.util.VirtualFileSystemOpener;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class AndroidPlugin
implements BaseComponent {
    private static final String GROUP_ANDROID_TOOLS = "AndroidToolsGroup";
    private static final String GROUP_TOOLS = "ToolsMenu";

    public void initComponent() {
        VirtualFileSystemOpener.INSTANCE.mount();
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            AndroidPlugin.initializeForNonStudio();
        }
        AndroidPlugin.setUpActionsUnderFlag();
    }

    private static void initializeForNonStudio() {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction group = actionManager.getAction(GROUP_ANDROID_TOOLS);
        if (group instanceof ActionGroup) {
            ((ActionGroup)group).setPopup(true);
        }
        Actions.moveAction(GROUP_ANDROID_TOOLS, GROUP_TOOLS, GROUP_TOOLS, new Constraints(Anchor.LAST, null));
        Actions.moveAction("Android.SyncProject", "FileMenu", GROUP_ANDROID_TOOLS, new Constraints(Anchor.FIRST, null));
        Actions.moveAction("Android.MainToolBarGradleGroup", "MainToolBar", "Android.MainToolBarActionGroup", new Constraints(Anchor.LAST, null));
        AnalyticsSettings.disable();
        UsageTracker.disable();
        UsageTracker.setIdeBrand((AndroidStudioEvent.IdeBrand)AndroidStudioEvent.IdeBrand.INTELLIJ);
    }

    private static void setUpActionsUnderFlag() {
        ActionManager actionManager;
        AnAction parentGroup;
        if (((Boolean)StudioFlags.RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED.get()).booleanValue() && (parentGroup = (actionManager = ActionManager.getInstance()).getAction("BuildMenu")) instanceof DefaultActionGroup) {
            String groupId = "Android.BuildApkOrBundle";
            DefaultActionGroup group = new DefaultActionGroup("Build Bundle(s) / APK(s)", true){

                public void update(@NotNull AnActionEvent e) {
                    Project project = e.getProject();
                    e.getPresentation().setEnabledAndVisible(project != null && AndroidProjectInfo.getInstance(project).requiresAndroidModel());
                }
            };
            actionManager.registerAction("Android.BuildApkOrBundle", (AnAction)group);
            ((DefaultActionGroup)parentGroup).add((AnAction)group, new Constraints(Anchor.BEFORE, "Android.GenerateSignedApk"));
            Actions.moveAction("Android.BuildApk", "BuildMenu", "Android.BuildApkOrBundle", new Constraints(Anchor.FIRST, null));
            Actions.moveAction("Android.BuildBundle", "BuildMenu", "Android.BuildApkOrBundle", new Constraints(Anchor.AFTER, null));
        }
    }
}

