/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidReferenceSearchExecutor
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public AndroidReferenceSearchExecutor() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters params, @NotNull Processor<? super PsiReference> consumer) {
        String resName;
        PsiElement refElement = params.getElementToSearch();
        if (!(refElement instanceof PsiFile)) {
            return;
        }
        VirtualFile vFile = ((PsiFile)refElement).getVirtualFile();
        if (vFile == null) {
            return;
        }
        LocalResourceManager manager = LocalResourceManager.getInstance(refElement);
        if (manager == null) {
            return;
        }
        String resType = manager.getFileResourceType((PsiFile)refElement);
        if (resType != null && !(resName = AndroidCommonUtils.getResourceName((String)resType, (String)vFile.getName())).equals(vFile.getNameWithoutExtension()) && StringUtil.isNotEmpty((String)resName)) {
            params.getOptimizer().searchWord(resName, params.getEffectiveSearchScope(), true, refElement);
        }
    }
}

