/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.AndroidUsagesTargetProvider;
import org.jetbrains.android.ResourceFieldElementWrapper;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRenameHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor2 == null) {
            return false;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return false;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element instanceof SchemaPrefix) {
            return false;
        }
        if (AndroidUsagesTargetProvider.findValueResourceTagInContext(editor2, file, true) != null) {
            return true;
        }
        if (AndroidRenameHandler.getResourceReferenceTarget(editor2) != null) {
            return true;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        return AndroidRenameHandler.isPackageAttributeInManifest(project, element);
    }

    @Nullable
    private static PsiElement getResourceReferenceTarget(@NotNull Editor editor2) {
        PsiReference reference2 = TargetElementUtil.findReference((Editor)editor2, (int)editor2.getCaretModel().getOffset());
        if (!(reference2 instanceof AndroidResourceReference)) {
            return null;
        }
        Collection elements = TargetElementUtil.getInstance().getTargetCandidates(reference2);
        if (elements.isEmpty()) {
            return null;
        }
        ArrayList elementList = new ArrayList(elements);
        Collections.sort(elementList, AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        return (PsiElement)elementList.get(0);
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file, @NotNull DataContext dataContext) {
        if (file == null || editor2 == null) {
            return;
        }
        XmlTag tag = AndroidUsagesTargetProvider.findValueResourceTagInContext(editor2, file, true);
        if (tag != null) {
            ResourceUrl url = AndroidRenameHandler.findResourceReferenceUnderCaret(editor2, file);
            if (url != null && !url.isFramework()) {
                AndroidRenameHandler.performResourceReferenceRenaming(project, editor2, dataContext, file, url);
            } else {
                AndroidRenameHandler.performValueResourceRenaming(project, editor2, dataContext, tag);
            }
        } else {
            PsiElement element = AndroidRenameHandler.getResourceReferenceTarget(editor2);
            if (element != null) {
                AndroidRenameHandler.performResourceReferenceRenaming(project, editor2, dataContext, element);
            } else {
                AndroidRenameHandler.performApplicationPackageRenaming(project, editor2, dataContext);
            }
        }
    }

    private static void performValueResourceRenaming(@NotNull Project project, @NotNull Editor editor2, @NotNull DataContext dataContext, @NotNull XmlTag tag) {
        XmlAttribute nameAttribute = tag.getAttribute("name");
        if (nameAttribute == null) {
            return;
        }
        XmlAttributeValue attributeValue = nameAttribute.getValueElement();
        if (attributeValue == null) {
            return;
        }
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)new ResourceRenameDialog(project, new ValueResourceElementWrapper(attributeValue), null, editor2));
    }

    private static void performResourceReferenceRenaming(@NotNull Project project, @NotNull Editor editor2, @NotNull DataContext dataContext, @NotNull PsiFile file, @NotNull ResourceUrl url) {
        PsiField[] resourceFields;
        assert (!url.isFramework());
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet != null && (resourceFields = AndroidResourceUtil.findResourceFields(facet, url.type.getName(), url.name, false)).length == 1) {
            Object element = resourceFields[0];
            if (element instanceof AndroidLightField) {
                element = new ResourceFieldElementWrapper((AndroidLightField)((Object)element));
            }
            RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)new ResourceRenameDialog(project, (PsiElement)element, null, editor2));
        }
    }

    private static void performResourceReferenceRenaming(@NotNull Project project, @NotNull Editor editor2, @NotNull DataContext dataContext, @NotNull PsiElement element) {
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)new ResourceRenameDialog(project, element, null, editor2));
    }

    @Nullable
    private static ResourceUrl findResourceReferenceUnderCaret(@NotNull Editor editor2, @NotNull PsiFile file) {
        XmlText text;
        if (!(file instanceof XmlFile)) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        if (!AndroidResourceUtil.isInResourceSubdirectory(file, ResourceFolderType.VALUES.getName())) {
            return null;
        }
        PsiElement element = file.findElementAt(editor2.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && (text = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)element, XmlText.class)) != null) {
            return ResourceUrl.parse((String)text.getText().trim());
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor2 == null) {
            return;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return;
        }
        this.invoke(project, editor2, file, dataContext);
    }

    public String getActionTitle() {
        return "Rename Android value resource";
    }

    static boolean isPackageAttributeInManifest(@NotNull Project project, @Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)psiFile);
        if (facet == null) {
            return false;
        }
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null || !vFile.equals(AndroidRootUtil.getPrimaryManifestFile(facet))) {
            return false;
        }
        if (!(element instanceof XmlAttributeValue)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return false;
        }
        GenericAttributeValue attrValue = DomManager.getDomManager((Project)project).getDomElement((XmlAttribute)parent);
        if (attrValue == null) {
            return false;
        }
        DomElement parentDomElement = attrValue.getParent();
        return parentDomElement instanceof Manifest && attrValue.equals(((Manifest)parentDomElement).getPackage());
    }

    private static void performApplicationPackageRenaming(@NotNull Project project, @NotNull Editor editor2, @NotNull DataContext context) {
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (!(element instanceof XmlAttributeValue)) {
            return;
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        RenameDialog.showRenameDialog((DataContext)context, (RenameDialog)new RenameDialog(project, element, null, editor2){

            @NotNull
            protected String getLabelText() {
                return "Rename Android application package of module '" + module.getName() + "' to:";
            }

            protected void canRun() throws ConfigurationException {
                String name = this.getNewName();
                if (name.isEmpty()) {
                    throw new ConfigurationException(AndroidBundle.message("specify.package.name.error", new Object[0]));
                }
                if (!AndroidUtils.isValidAndroidPackageName(name)) {
                    throw new ConfigurationException(AndroidBundle.message("not.valid.package.name.error", name));
                }
                if (!AndroidCommonUtils.contains2Identifiers((String)name)) {
                    throw new ConfigurationException(AndroidBundle.message("package.name.must.contain.2.ids.error", new Object[0]));
                }
                super.canRun();
            }
        });
    }

    private static class ResourceRenameDialog
    extends RenameDialog {
        ResourceRenameDialog(@NotNull Project project, @NotNull PsiElement psiElement, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor2) {
            super(project, psiElement, nameSuggestionContext, editor2);
        }

        protected void canRun() throws ConfigurationException {
            String name = this.getNewName();
            String errorText = ValueResourceNameValidator.getErrorText((String)name, null);
            if (errorText != null) {
                throw new ConfigurationException(errorText);
            }
        }
    }
}

