/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidResourceExternalAnnotatorBase
extends ExternalAnnotator<FileAnnotationInfo, Map<PsiElement, GutterIconRenderer>> {
    private static final Logger LOG = Logger.getInstance(AndroidResourceExternalAnnotatorBase.class);

    @Nullable
    public final FileAnnotationInfo collectInformation(@NotNull PsiFile file, @NotNull Editor editor2, boolean hasErrors) {
        if (!((Boolean)StudioFlags.GUTTER_ICON_ANNOTATOR_IN_BACKGROUND_ENABLED.get()).booleanValue()) {
            return null;
        }
        return this.collectInformation(file, editor2);
    }

    @Nullable
    protected abstract FileAnnotationInfo collectInformation(@NotNull PsiFile var1, @NotNull Editor var2);

    @Nullable
    public final FileAnnotationInfo collectInformation(@NotNull PsiFile file) {
        return null;
    }

    @Nullable
    public Map<PsiElement, GutterIconRenderer> doAnnotate(@NotNull FileAnnotationInfo fileAnnotationsInfo) {
        AndroidFacet facet = fileAnnotationsInfo.getFacet();
        Editor editor2 = fileAnnotationsInfo.getEditor();
        long timestamp = fileAnnotationsInfo.getTimestamp();
        Document document = editor2.getDocument();
        HashMap<PsiElement, GutterIconRenderer> rendererMap = new HashMap<PsiElement, GutterIconRenderer>();
        Configuration configuration = AndroidAnnotatorUtil.pickConfiguration(fileAnnotationsInfo.getFile(), facet);
        if (configuration == null) {
            return null;
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        for (FileAnnotationInfo.AnnotatableElement element : fileAnnotationsInfo.getElements()) {
            GutterIconRenderer gutterIconRenderer;
            ProgressManager.checkCanceled();
            if (editor2.isDisposed() || document.getModificationStamp() > timestamp) {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Rendering icon for %s in %s.", element.getResource(), fileAnnotationsInfo.getFile()));
            }
            if (element.getResource() != null) {
                gutterIconRenderer = AndroidResourceExternalAnnotatorBase.getResourceGutterIconRender(element.getResource(), element.getPsiElement(), resolver, facet, configuration);
            } else {
                assert (element.getColor() != null);
                Color color = element.getColor();
                gutterIconRenderer = new AndroidAnnotatorUtil.ColorRenderer(element.getPsiElement(), color, true);
            }
            if (gutterIconRenderer == null) continue;
            rendererMap.put(element.getPsiElement(), gutterIconRenderer);
        }
        return rendererMap;
    }

    @Nullable
    private static GutterIconRenderer getResourceGutterIconRender(@NotNull ResourceReference reference2, @NotNull PsiElement element, @NotNull ResourceResolver resolver, @NotNull AndroidFacet facet, @NotNull Configuration configuration) {
        ResourceType type = reference2.getResourceType();
        if (type == ResourceType.COLOR) {
            return AndroidResourceExternalAnnotatorBase.getColorGutterIconRenderer(resolver, reference2, facet, element);
        }
        assert (type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP);
        return AndroidResourceExternalAnnotatorBase.getDrawableGutterIconRenderer(resolver, reference2, facet, configuration);
    }

    @Nullable
    private static GutterIconRenderer getDrawableGutterIconRenderer(@NotNull ResourceResolver resourceResolver, @NotNull ResourceReference reference2, @NotNull AndroidFacet facet, @NotNull Configuration configuration) {
        ResourceValue drawable = resourceResolver.getResolvedResource(reference2);
        if (drawable == null) {
            return null;
        }
        VirtualFile bitmap = AndroidAnnotatorUtil.resolveDrawableFile(drawable, resourceResolver, facet);
        if ((bitmap = AndroidAnnotatorUtil.pickBestBitmap(bitmap)) == null) {
            return null;
        }
        GutterIconCache.getInstance().getIcon(bitmap, (RenderResources)resourceResolver, facet);
        return new com.android.tools.idea.rendering.GutterIconRenderer(resourceResolver, facet, bitmap, configuration);
    }

    @Nullable
    private static GutterIconRenderer getColorGutterIconRenderer(@NotNull ResourceResolver resourceResolver, @NotNull ResourceReference reference2, @NotNull AndroidFacet facet, @NotNull PsiElement element) {
        ResourceValue colorValue = resourceResolver.getResolvedResource(reference2);
        Color color = ResourceHelper.resolveColor((RenderResources)resourceResolver, colorValue, facet.getModule().getProject());
        if (color == null) {
            return null;
        }
        return new AndroidAnnotatorUtil.ColorRenderer(element, color, false);
    }

    public void apply(@NotNull PsiFile file, @NotNull Map<PsiElement, GutterIconRenderer> iconRendererMap, @NotNull AnnotationHolder holder) {
        iconRendererMap.forEach((k, v) -> {
            if (k.isValid()) {
                holder.createInfoAnnotation(k, null).setGutterIconRenderer(v);
            }
        });
    }

    protected static class FileAnnotationInfo {
        @NotNull
        private final AndroidFacet myFacet;
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final Editor myEditor;
        private final long myTimestamp;
        @NotNull
        private final List<AnnotatableElement> myElements;

        public FileAnnotationInfo(@NotNull AndroidFacet facet, @NotNull PsiFile file, @NotNull Editor editor2) {
            this.myFacet = facet;
            this.myFile = file;
            this.myEditor = editor2;
            this.myTimestamp = this.myEditor.getDocument().getModificationStamp();
            this.myElements = new ArrayList<AnnotatableElement>();
        }

        @NotNull
        public AndroidFacet getFacet() {
            return this.myFacet;
        }

        @NotNull
        public PsiFile getFile() {
            return this.myFile;
        }

        @NotNull
        public List<AnnotatableElement> getElements() {
            return this.myElements;
        }

        @NotNull
        public Editor getEditor() {
            return this.myEditor;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        public static class AnnotatableElement {
            @Nullable
            private final ResourceReference myReference;
            @NotNull
            private final PsiElement myPsiElement;
            @Nullable
            private final Color myColor;

            public AnnotatableElement(@NotNull ResourceReference reference2, @NotNull PsiElement element) {
                this.myReference = reference2;
                this.myPsiElement = element;
                this.myColor = null;
            }

            AnnotatableElement(@NotNull Color color, @NotNull PsiElement element) {
                this.myReference = null;
                this.myPsiElement = element;
                this.myColor = color;
            }

            @Nullable
            public ResourceReference getResource() {
                return this.myReference;
            }

            @NotNull
            public PsiElement getPsiElement() {
                return this.myPsiElement;
            }

            @Nullable
            public Color getColor() {
                return this.myColor;
            }
        }
    }
}

