/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.builder.model.level2.Library;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.util.PathString;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameJavaVariableProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameXmlAttributeProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.android.AndroidFindUsagesHandlerFactory;
import org.jetbrains.android.ResourceFieldElementWrapper;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceRenameResourceProcessor
extends RenamePsiElementProcessor {
    private static final Ordering<String> ORDER_BY_LENGTH = new Ordering<String>(){

        public int compare(String left2, String right2) {
            int lengthCompare = Ints.compare((int)left2.length(), (int)right2.length());
            return lengthCompare != 0 ? lengthCompare : StringUtil.compare((String)left2, (String)right2, (boolean)true);
        }
    };
    public static volatile boolean ASK = true;

    public boolean canProcessElement(@NotNull PsiElement element) {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            PsiElement computedElement = LazyValueResourceElementWrapper.computeLazyElement(element);
            if (computedElement == null) {
                return false;
            }
            if (computedElement instanceof PsiFile) {
                return AndroidFacet.getInstance(computedElement) != null && AndroidResourceUtil.isInResourceSubdirectory((PsiFile)computedElement, null);
            }
            if (computedElement instanceof PsiField) {
                PsiField field2 = (PsiField)computedElement;
                if (AndroidResourceUtil.isResourceField(field2)) {
                    return !AndroidResourceUtil.findResourcesByField(field2).isEmpty();
                }
            } else {
                PsiClass cls;
                if (computedElement instanceof ResourceFieldElementWrapper) {
                    return true;
                }
                if (computedElement instanceof XmlAttributeValue) {
                    LocalResourceManager manager = LocalResourceManager.getInstance(computedElement);
                    if (manager != null) {
                        if (AndroidResourceUtil.isIdDeclaration((XmlAttributeValue)computedElement)) {
                            return true;
                        }
                        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)computedElement, XmlTag.class);
                        return tag != null && DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag) instanceof ResourceElement && manager.getValueResourceType(tag) != null;
                    }
                } else if (computedElement instanceof PsiClass && InheritanceUtil.isInheritor((PsiClass)(cls = (PsiClass)computedElement), (String)"android.view.View")) {
                    return true;
                }
            }
            return false;
        });
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor2) {
        if (element instanceof AndroidLightField) {
            return new ResourceFieldElementWrapper((AndroidLightField)element);
        }
        return super.substituteElementToRename(element, editor2);
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName2, @NotNull Map<PsiElement, String> allRenames) {
        PsiElement computedElement = LazyValueResourceElementWrapper.computeLazyElement(element);
        if (computedElement == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(computedElement);
        assert (facet != null);
        if (computedElement instanceof PsiFile) {
            AndroidResourceRenameResourceProcessor.prepareResourceFileRenaming((PsiFile)computedElement, newName2, allRenames, facet);
        } else if (computedElement instanceof PsiClass) {
            PsiClass cls = (PsiClass)computedElement;
            if (InheritanceUtil.isInheritor((PsiClass)cls, (String)"android.view.View")) {
                AndroidResourceRenameResourceProcessor.prepareCustomViewRenaming(cls, newName2, allRenames, facet);
            }
        } else if (computedElement instanceof XmlAttributeValue) {
            XmlAttributeValue value2 = (XmlAttributeValue)computedElement;
            if (AndroidResourceUtil.isIdDeclaration(value2)) {
                if (AndroidResourceUtil.isIdDeclaration(newName2)) {
                    AndroidResourceRenameResourceProcessor.prepareIdRenaming(value2, newName2, allRenames, facet);
                }
            } else {
                AndroidResourceRenameResourceProcessor.prepareValueResourceRenaming(computedElement, newName2, allRenames, facet);
            }
        } else if (computedElement instanceof PsiField) {
            AndroidResourceRenameResourceProcessor.prepareResourceFieldRenaming((PsiField)computedElement, newName2, allRenames);
        } else if (computedElement instanceof ResourceFieldElementWrapper) {
            AndroidResourceRenameResourceProcessor.prepareResourceFieldRenaming(((ResourceFieldElementWrapper)computedElement).getWrappedElement(), newName2, allRenames);
        }
    }

    private static void prepareCustomViewRenaming(PsiClass cls, String newName2, Map<PsiElement, String> allRenames, AndroidFacet facet) {
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(facet);
        String oldName = cls.getName();
        if (appResources.hasResources(ResourceNamespace.TODO(), ResourceType.STYLEABLE, oldName)) {
            LocalResourceManager manager = ModuleResourceManagers.getInstance(facet).getLocalResourceManager();
            for (PsiElement element : manager.findResourcesByFieldName(ResourceNamespace.TODO(), ResourceType.STYLEABLE.getName(), oldName)) {
                XmlTag tag;
                String tagName;
                if (!(element instanceof XmlAttributeValue) || !(element.getParent() instanceof XmlAttribute) || !(tagName = (tag = ((XmlAttribute)element.getParent()).getParent()).getName()).equals("declare-styleable")) continue;
                for (PsiField field2 : AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), oldName, false)) {
                    String escaped = AndroidResourceUtil.getFieldNameByResourceName(newName2);
                    allRenames.put((PsiElement)field2, escaped);
                }
                PsiField[] styleableFields = AndroidResourceUtil.findStyleableAttributeFields(tag, false);
                if (styleableFields.length <= 0) continue;
                for (PsiField resField : styleableFields) {
                    String fieldName = resField.getName();
                    String newAttributeName = fieldName.startsWith(oldName) ? newName2 + fieldName.substring(oldName.length()) : oldName;
                    String escaped = AndroidResourceUtil.getFieldNameByResourceName(newAttributeName);
                    allRenames.put((PsiElement)resField, escaped);
                }
            }
        }
    }

    private static void prepareIdRenaming(XmlAttributeValue value2, String newName2, Map<PsiElement, String> allRenames, AndroidFacet facet) {
        allRenames.remove(value2);
        LocalResourceManager manager = ModuleResourceManagers.getInstance(facet).getLocalResourceManager();
        String id = AndroidResourceUtil.getResourceNameByReferenceText(value2.getValue());
        assert (id != null);
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(facet);
        ResourceNamespace namespace = repositoryManager.getNamespace();
        List<XmlAttributeValue> idDeclarations = manager.findIdDeclarations(namespace, id);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)facet.getModule().getProject()).getFileIndex();
        for (XmlAttributeValue xmlAttributeValue : idDeclarations) {
            if (!"id".equals(((XmlAttribute)xmlAttributeValue.getParent()).getLocalName()) || !fileIndex.isInContent(xmlAttributeValue.getContainingFile().getVirtualFile())) continue;
            allRenames.put(new ValueResourceElementWrapper(xmlAttributeValue), newName2);
        }
        String name = AndroidResourceUtil.getResourceNameByReferenceText(newName2);
        if (name != null) {
            for (PsiField resField : AndroidResourceUtil.findIdFields(value2)) {
                allRenames.put((PsiElement)resField, AndroidResourceUtil.getFieldNameByResourceName(name));
            }
        }
        List<XmlAttributeValue> list = manager.findConstraintReferencedIds(namespace, id);
        for (XmlAttributeValue usage : list) {
            if (!fileIndex.isInContent(usage.getContainingFile().getVirtualFile())) continue;
            String newId = AndroidResourceUtil.getResourceNameByReferenceText(newName2);
            String oldValue = usage.getValue();
            if (oldValue == null) continue;
            String newValue = Arrays.stream(oldValue.split(",")).map(s -> id.equals(s) ? newId : s).collect(Collectors.joining(","));
            allRenames.put(new ValueResourceElementWrapper(usage), newValue);
        }
    }

    @Nullable
    private static String getResourceName(Project project, String newFieldName, String oldResourceName) {
        if (newFieldName.indexOf(95) < 0) {
            return newFieldName;
        }
        if (oldResourceName.indexOf(95) < 0 && oldResourceName.indexOf(46) >= 0) {
            String suggestion = newFieldName.replace('_', '.');
            newFieldName = Messages.showInputDialog((Project)project, (String)AndroidBundle.message("rename.resource.dialog.text", oldResourceName), (String)RefactoringBundle.message((String)"rename.title"), (Icon)Messages.getQuestionIcon(), (String)suggestion, null);
        }
        return newFieldName;
    }

    private static void prepareResourceFieldRenaming(PsiField field2, String newName2, Map<PsiElement, String> allRenames) {
        String newResName;
        new RenameJavaVariableProcessor().prepareRenaming((PsiElement)field2, newName2, allRenames);
        List<PsiElement> resources = AndroidResourceUtil.findResourcesByField(field2);
        PsiElement res = resources.get(0);
        if (res instanceof PsiFile) {
            newResName = newName2;
        } else if (res instanceof XmlAttributeValue) {
            newResName = AndroidResourceRenameResourceProcessor.getResourceName(field2.getProject(), newName2, ((XmlAttributeValue)res).getValue());
        } else {
            Logger.getInstance(AndroidResourceRenameResourceProcessor.class).error(String.format("%s: res is neither PsiFile nor XmlAttributeValue", AndroidResourceRenameResourceProcessor.class.getSimpleName()));
            newResName = newName2;
        }
        for (PsiElement resource : resources) {
            XmlAttribute parent;
            XmlTag tag;
            if (resource instanceof PsiFile) {
                PsiFile file = (PsiFile)resource;
                String extension = FileUtilRt.getExtension((String)file.getName());
                allRenames.put(resource, newResName + '.' + extension);
                continue;
            }
            if (!(resource instanceof XmlAttributeValue)) continue;
            XmlAttributeValue value2 = (XmlAttributeValue)resource;
            String s = AndroidResourceUtil.isIdDeclaration(value2) ? "@+id/" + newResName : newResName;
            allRenames.put(new ValueResourceElementWrapper(value2), s);
            if (!(value2.getParent() instanceof XmlAttribute) || !(tag = (parent = (XmlAttribute)value2.getParent()).getParent()).getName().equals("declare-styleable")) continue;
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
            String oldName = tag.getAttributeValue("name");
            if (facet == null || oldName == null) continue;
            for (XmlTag attr : tag.getSubTags()) {
                String name;
                if (!attr.getName().equals("attr") || (name = attr.getAttributeValue("name")) == null) continue;
                String oldAttributeName = oldName + '_' + name;
                PsiField[] fields = AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), oldAttributeName, true);
                if (fields.length <= 0) continue;
                String newAttributeName = newName2 + '_' + name;
                for (PsiField f : fields) {
                    allRenames.put((PsiElement)f, newAttributeName);
                }
            }
        }
    }

    private static void prepareValueResourceRenaming(PsiElement element, String newName2, Map<PsiElement, String> allRenames, AndroidFacet facet) {
        PsiField[] resFields;
        LocalResourceManager localResourceManager = ModuleResourceManagers.getInstance(facet).getLocalResourceManager();
        ResourceRepositoryManager repoManager = ResourceRepositoryManager.getInstance(facet);
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        assert (tag != null);
        ResourceType type = localResourceManager.getValueResourceType(tag);
        assert (type != null);
        Project project = tag.getProject();
        DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(tag);
        assert (domElement instanceof ResourceElement);
        String name = (String)((ResourceElement)domElement).getName().getValue();
        assert (name != null);
        List<ResourceElement> resources = localResourceManager.findValueResources(ResourceNamespace.TODO(), type.getName(), name);
        for (ResourceElement resourceElement : resources) {
            XmlAttributeValue xmlElement = resourceElement.getName().getXmlAttributeValue();
            if (element.getManager().areElementsEquivalent(element, (PsiElement)xmlElement)) continue;
            allRenames.put((PsiElement)xmlElement, newName2);
        }
        if (AndroidResourceRenameResourceProcessor.getResourceType(element) == ResourceType.STYLE) {
            HashSet<String> renamedStyles = new HashSet<String>();
            renamedStyles.add(name);
            String string = name + ".";
            Set allStyles = repoManager.getAppResources().getResources(ResourceNamespace.TODO(), type).keySet();
            Collection renameCandidates = Collections2.filter((Collection)allStyles, styleName -> styleName.startsWith(string));
            for (String resourceName : ORDER_BY_LENGTH.sortedCopy((Iterable)renameCandidates)) {
                String parentName = resourceName.substring(0, resourceName.lastIndexOf(46));
                if (!renamedStyles.contains(parentName)) continue;
                for (ResourceElement resource : localResourceManager.findValueResources(ResourceNamespace.TODO(), type.getName(), resourceName)) {
                    XmlAttributeValue xmlElement;
                    if (!(resource instanceof Style) || ((Style)resource).getParentStyle().getXmlAttributeValue() != null || (xmlElement = resource.getName().getXmlAttributeValue()) == null) continue;
                    String newStyleName = newName2 + StringUtil.trimStart((String)resourceName, (String)name);
                    allRenames.put(new ValueResourceElementWrapper(xmlElement), newStyleName);
                    renamedStyles.add(resourceName);
                }
            }
        }
        for (PsiField resField : resFields = AndroidResourceUtil.findResourceFieldsForValueResource(tag, false)) {
            String escaped = AndroidResourceUtil.getFieldNameByResourceName(newName2);
            allRenames.put((PsiElement)resField, escaped);
        }
        PsiField[] psiFieldArray = AndroidResourceUtil.findStyleableAttributeFields(tag, false);
        if (psiFieldArray.length > 0) {
            boolean isAttr;
            String tagName = tag.getName();
            boolean isDeclareStyleable = tagName.equals("declare-styleable");
            boolean bl = isAttr = !isDeclareStyleable && tagName.equals("attr") && tag.getParentTag() != null;
            assert (isDeclareStyleable || isAttr);
            String style = isAttr ? tag.getParentTag().getAttributeValue("name") : null;
            for (PsiField resField : psiFieldArray) {
                String fieldName = resField.getName();
                String newAttributeName = isDeclareStyleable && fieldName.startsWith(name) ? newName2 + fieldName.substring(name.length()) : (isAttr && style != null ? style + '_' + newName2 : name);
                String escaped = AndroidResourceUtil.getFieldNameByResourceName(newAttributeName);
                allRenames.put((PsiElement)resField, escaped);
            }
        }
    }

    private static void prepareResourceFileRenaming(PsiFile file, String newName2, Map<PsiElement, String> allRenames, AndroidFacet facet) {
        Project project = file.getProject();
        LocalResourceManager manager = ModuleResourceManagers.getInstance(facet).getLocalResourceManager();
        ResourceFolderType type = manager.getFileResourceFolderType(file);
        if (type == null) {
            return;
        }
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)file.getName());
        String resourceName = AndroidCommonUtils.getResourceName((String)type.getName(), (String)file.getName());
        if (AndroidCommonUtils.getResourceName((String)type.getName(), (String)nameWithoutExtension).equals(AndroidCommonUtils.getResourceName((String)type.getName(), (String)newName2))) {
            return;
        }
        Collection<PsiFile> resourceFiles = manager.findResourceFiles(ResourceNamespace.TODO(), type, resourceName, true, false);
        ArrayList<PsiFile> alternativeResources = new ArrayList<PsiFile>();
        for (PsiFile resourceFile : resourceFiles) {
            String alternativeFileName = AndroidCommonUtils.getResourceName((String)type.getName(), (String)resourceFile.getName());
            if (resourceFile.getManager().areElementsEquivalent((PsiElement)file, (PsiElement)resourceFile) || !alternativeFileName.equals(resourceName)) continue;
            alternativeResources.add(resourceFile);
        }
        if (!alternativeResources.isEmpty()) {
            int r = 0;
            if (ASK) {
                r = Messages.showDialog((Project)project, (String)AndroidBundle.message("rename.alternate.resources.question", new Object[0]), (String)AndroidBundle.message("rename.dialog.title", new Object[0]), (String[])new String[]{Messages.YES_BUTTON, Messages.NO_BUTTON}, (int)1, (Icon)Messages.getQuestionIcon());
            }
            if (r == 0) {
                for (PsiFile candidate : alternativeResources) {
                    String extension = FileUtilRt.getExtension((String)candidate.getName());
                    if (!extension.isEmpty()) {
                        extension = "." + extension;
                    }
                    allRenames.put((PsiElement)candidate, FileUtil.getNameWithoutExtension((String)newName2) + extension);
                }
            } else {
                return;
            }
        }
        PsiField[] resFields = AndroidResourceUtil.findResourceFieldsForFileResource(file, false);
        for (PsiField resField : resFields) {
            String newFieldName = AndroidCommonUtils.getResourceName((String)type.getName(), (String)newName2);
            allRenames.put((PsiElement)resField, AndroidResourceUtil.getFieldNameByResourceName(newFieldName));
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, boolean searchInCommentsAndStrings) {
        if (element instanceof ResourceFieldElementWrapper) {
            element = ((ResourceFieldElementWrapper)element).getWrappedElement();
        }
        return super.findReferences(element, searchInCommentsAndStrings);
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName2, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        if (element instanceof PsiField) {
            new RenameJavaVariableProcessor().renameElement(element, newName2, usages, listener2);
        } else if (element instanceof ResourceFieldElementWrapper) {
            new RenameJavaVariableProcessor().renameElement((PsiElement)((ResourceFieldElementWrapper)element).getWrappedElement(), newName2, usages, listener2);
        } else if (element instanceof PsiNamedElement) {
            VirtualFile virtualFile;
            super.renameElement(element, newName2, usages, listener2);
            if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null && !LocalHistory.getInstance().isUnderControl(virtualFile)) {
                DocumentReference ref = DocumentReferenceManager.getInstance().create(virtualFile);
                UndoManager.getInstance((Project)element.getProject()).nonundoableActionPerformed(ref, false);
            }
        } else if (element instanceof XmlAttributeValue) {
            new RenameXmlAttributeProcessor().renameElement(element, newName2, usages, listener2);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement originalElement, @NotNull String newName2, @NotNull MultiMap<PsiElement, String> conflicts) {
        String name;
        LocalResourceRepository appResources;
        ResourceType type = AndroidResourceRenameResourceProcessor.getResourceType(originalElement);
        if (type == null) {
            return;
        }
        PsiElement element = LazyValueResourceElementWrapper.computeLazyElement(originalElement);
        if (element == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            return;
        }
        if (element instanceof PsiFile) {
            newName2 = AndroidCommonUtils.getResourceName((String)type.getName(), (String)newName2);
        }
        if ((appResources = ResourceRepositoryManager.getAppResources(facet)).hasResources(ResourceNamespace.TODO(), type, newName2)) {
            FindUsagesHandler handler;
            AndroidFindUsagesHandlerFactory factory;
            boolean foundElements = false;
            PsiField[] resourceFields = AndroidResourceUtil.findResourceFields(facet, type.getName(), newName2, true);
            String message2 = String.format("Resource @%1$s/%2$s already exists", type, newName2);
            if (resourceFields.length > 0 && (factory = new AndroidFindUsagesHandlerFactory()).canFindUsages(originalElement) && (handler = factory.createFindUsagesHandler((PsiElement)resourceFields[0], false)) != null) {
                PsiElement[] elements;
                for (PsiElement e : elements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler.getPrimaryElements(), (Object[])handler.getSecondaryElements())) {
                    if (e instanceof LightElement) continue;
                    conflicts.putValue((Object)e, (Object)message2);
                    foundElements = true;
                }
            }
            if (!foundElements) {
                conflicts.putValue((Object)originalElement, (Object)message2);
            }
        }
        if ((name = AndroidResourceRenameResourceProcessor.getResourceName(originalElement)) != null) {
            Project project = facet.getModule().getProject();
            List<ResourceItem> all = appResources.getResources(ResourceNamespace.TODO(), type, name);
            List<ResourceItem> local = ResourceRepositoryManager.getProjectResources(facet).getResources(ResourceNamespace.TODO(), type, name);
            HtmlBuilder builder = null;
            if (local.isEmpty() && !all.isEmpty()) {
                builder = new HtmlBuilder(new StringBuilder(300));
                builder.add("Resource is also only defined in external libraries and cannot be renamed.");
            } else if (local.size() < all.size()) {
                builder = new HtmlBuilder(new StringBuilder(300));
                builder.add("The resource ").beginBold().add("@").add(type.getName()).add("/").add(name).endBold();
                builder.add(" is defined outside of the project (in one of the libraries) and cannot ");
                builder.add("be updated. This can change the behavior of the application.").newline().newline();
                builder.add("Are you sure you want to do this?");
            }
            if (builder != null) {
                AndroidResourceRenameResourceProcessor.appendUnhandledReferences(project, facet, all, local, builder);
                conflicts.putValue((Object)originalElement, (Object)builder.getHtml());
            }
        }
    }

    @Nullable
    private static ResourceType getResourceType(PsiElement originalElement) {
        LocalResourceManager manager;
        PsiElement element = LazyValueResourceElementWrapper.computeLazyElement(originalElement);
        if (element == null) {
            return null;
        }
        if (element instanceof PsiFile) {
            List types;
            ResourceFolderType folderType = ResourceHelper.getFolderType((PsiFile)element);
            if (folderType != null && folderType != ResourceFolderType.VALUES && !(types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)).isEmpty()) {
                return (ResourceType)types.get(0);
            }
        } else if (element instanceof PsiField) {
            PsiField field2 = (PsiField)element;
            if (AndroidResourceUtil.isResourceField(field2)) {
                return ResourceType.fromClassName((String)AndroidResourceUtil.getResourceClassName(field2));
            }
        } else if (element instanceof XmlAttributeValue && (manager = LocalResourceManager.getInstance(element)) != null) {
            if (AndroidResourceUtil.isIdDeclaration((XmlAttributeValue)element)) {
                return ResourceType.ID;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag != null && DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag) instanceof ResourceElement) {
                return AndroidResourceUtil.getResourceTypeForResourceTag(tag);
            }
        }
        return null;
    }

    @Nullable
    private static String getResourceName(PsiElement originalElement) {
        PsiElement element = LazyValueResourceElementWrapper.computeLazyElement(originalElement);
        if (element == null) {
            return null;
        }
        if (element instanceof PsiFile) {
            String type;
            PsiFile file = (PsiFile)element;
            LocalResourceManager manager = LocalResourceManager.getInstance(element);
            if (manager != null && (type = manager.getFileResourceType(file)) != null) {
                String name = file.getName();
                return AndroidCommonUtils.getResourceName((String)type, (String)name);
            }
            return Lint.getBaseName((String)file.getName());
        }
        if (element instanceof PsiField) {
            PsiField field2 = (PsiField)element;
            return field2.getName();
        }
        if (element instanceof XmlAttributeValue) {
            DomElement domElement;
            if (AndroidResourceUtil.isIdDeclaration((XmlAttributeValue)element)) {
                return AndroidResourceUtil.getResourceNameByReferenceText(((XmlAttributeValue)element).getValue());
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag != null && (domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag)) instanceof ResourceElement) {
                return (String)((ResourceElement)domElement).getName().getValue();
            }
        }
        return null;
    }

    private static void appendUnhandledReferences(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull List<ResourceItem> all, @NotNull List<ResourceItem> local, @NotNull HtmlBuilder builder) {
        File root = VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir());
        Collection<Library> libraries = null;
        ArrayList descriptions = Lists.newArrayList();
        for (ResourceItem item : all) {
            File sourceFile;
            PathString source;
            if (local.contains(item)) continue;
            if (libraries == null) {
                libraries = ResourceRepositoryManager.findAarLibraries(facet);
            }
            if ((source = item.getSource()) == null || (sourceFile = source.toFile()) == null) continue;
            File localRoot = root;
            File prev = sourceFile;
            for (File current = sourceFile.getParentFile(); current != null; current = current.getParentFile()) {
                String name = current.getName();
                if ("exploded-aar".equals(name)) {
                    localRoot = prev;
                    break;
                }
                prev = current;
            }
            if (FileUtil.isAncestor((File)localRoot, (File)sourceFile, (boolean)true)) {
                descriptions.add(FileUtil.getRelativePath((File)localRoot, (File)sourceFile));
                continue;
            }
            descriptions.add(sourceFile.getPath());
        }
        Collections.sort(descriptions);
        builder.newline().newline();
        builder.add("Unhandled references:");
        builder.newline();
        int count = 0;
        for (String s : descriptions) {
            builder.add(s).newline();
            if (++count != 10) continue;
            builder.add("...").newline();
            builder.add("(Additional results truncated)");
            break;
        }
    }
}

