/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.support.AndroidxName;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.psi.TagToClassMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.ProjectTopics;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;

class TagToClassMapperImpl
implements TagToClassMapper {
    private static final Logger LOG = Logger.getInstance(TagToClassMapper.class);
    private final Map<String, Map<String, SmartPsiElementPointer<PsiClass>>> myInitialClassMaps = new HashMap<String, Map<String, SmartPsiElementPointer<PsiClass>>>();
    private final Map<String, CachedValue<Map<String, PsiClass>>> myClassMaps = Maps.newConcurrentMap();
    private final Module myModule;

    TagToClassMapperImpl(@NotNull Module module) {
        this.myModule = module;
        MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                TagToClassMapperImpl.this.clear();
            }
        });
    }

    @Override
    @NotNull
    public Map<String, PsiClass> getFrameworkClassMap(@NotNull String frameworkClass) {
        Map<String, PsiClass> frameworkClasses = this.getClassMap(frameworkClass);
        return Collections.unmodifiableMap(frameworkClasses);
    }

    @Override
    @NotNull
    public Map<String, PsiClass> getAndroidXClassMap(@NotNull AndroidxName androidXClass) {
        String qualifiedName = MigrateToAndroidxUtil.getNameInProject(androidXClass, this.myModule.getProject());
        Map<String, PsiClass> libClasses = this.getClassMap(qualifiedName);
        return Collections.unmodifiableMap(libClasses);
    }

    private Map<String, PsiClass> getClassMap(String className) {
        CachedValue value2 = this.myClassMaps.get(className);
        if (value2 == null) {
            value2 = CachedValuesManager.getManager((Project)this.myModule.getProject()).createCachedValue(() -> {
                Map<String, PsiClass> map2 = this.computeClassMap(className);
                return CachedValueProvider.Result.create(map2, (Object[])new Object[]{((PsiModificationTrackerImpl)PsiManager.getInstance((Project)this.myModule.getProject()).getModificationTracker()).forLanguages(language -> language.is((Language)JavaLanguage.INSTANCE) || language.is((Language)KotlinLanguage.INSTANCE))});
            }, false);
            this.myClassMaps.put(className, (CachedValue<Map<String, PsiClass>>)value2);
        }
        return (Map)value2.getValue();
    }

    @NotNull
    private Map<String, PsiClass> computeClassMap(@NotNull String className) {
        PsiClass aClass;
        SmartPsiElementPointer<PsiClass> pointer;
        Map<String, SmartPsiElementPointer<PsiClass>> classMap = this.getInitialClassMap(className, false);
        HashMap<String, PsiClass> result2 = new HashMap<String, PsiClass>();
        boolean shouldRebuildInitialMap = false;
        int apiLevel = this.getMinApiLevel();
        for (String key : classMap.keySet()) {
            pointer = classMap.get(key);
            aClass = (PsiClass)pointer.getElement();
            if (aClass == null) continue;
            if (!TagToClassMapperImpl.isUpToDate(aClass, key, apiLevel)) {
                shouldRebuildInitialMap = true;
                break;
            }
            result2.put(key, aClass);
        }
        if (shouldRebuildInitialMap) {
            result2.clear();
            classMap = this.getInitialClassMap(className, true);
            for (String key : classMap.keySet()) {
                pointer = classMap.get(key);
                aClass = (PsiClass)pointer.getElement();
                if (aClass == null) continue;
                result2.put(key, aClass);
            }
        }
        this.fillMap(className, this.projectClassesScope(), result2);
        return result2;
    }

    private static boolean isUpToDate(@NotNull PsiClass aClass, @NotNull String tagName, int apiLevel) {
        return ArrayUtil.contains((String)tagName, (String[])LayoutViewClassUtils.getTagNamesByClass(aClass, apiLevel));
    }

    @NotNull
    private Map<String, SmartPsiElementPointer<PsiClass>> getInitialClassMap(@NotNull String className, boolean forceRebuild) {
        Map<String, SmartPsiElementPointer<PsiClass>> viewClassMap = this.myInitialClassMaps.get(className);
        if (viewClassMap != null && !forceRebuild) {
            return viewClassMap;
        }
        return this.computeInitialClassMap(className);
    }

    @VisibleForTesting
    @NotNull
    Map<String, SmartPsiElementPointer<PsiClass>> computeInitialClassMap(@NotNull String className) {
        LOG.info("Building initial class map for " + className);
        Map<String, SmartPsiElementPointer<PsiClass>> viewClassMap = null;
        HashMap<String, PsiClass> map2 = new HashMap<String, PsiClass>();
        if (this.fillMap(className, this.dependenciesClassesScope(), map2)) {
            viewClassMap = new HashMap<String, SmartPsiElementPointer<PsiClass>>(map2.size());
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.myModule.getProject());
            for (Map.Entry entry : map2.entrySet()) {
                viewClassMap.put((String)entry.getKey(), (SmartPsiElementPointer<PsiClass>)manager.createSmartPsiElementPointer((PsiElement)entry.getValue()));
            }
            this.myInitialClassMaps.put(className, viewClassMap);
        }
        return viewClassMap != null ? viewClassMap : Collections.emptyMap();
    }

    @NotNull
    private GlobalSearchScope moduleResolveScope() {
        return this.myModule.getModuleWithDependenciesAndLibrariesScope(false);
    }

    @NotNull
    private GlobalSearchScope allLibrariesScope() {
        return ProjectScope.getLibrariesScope((Project)this.myModule.getProject());
    }

    @NotNull
    private GlobalSearchScope projectClassesScope() {
        return this.moduleResolveScope().intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.allLibrariesScope()));
    }

    @NotNull
    private GlobalSearchScope dependenciesClassesScope() {
        return this.moduleResolveScope().intersectWith(this.allLibrariesScope());
    }

    private boolean fillMap(@NotNull String className, @NotNull GlobalSearchScope scope, @NotNull Map<String, PsiClass> map2) {
        String[] baseClassTagNames;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
        PsiClass baseClass = (PsiClass)ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass aClass;
            try {
                aClass = facade.findClass(className, this.moduleResolveScope());
            }
            catch (IndexNotReadyException e) {
                aClass = null;
            }
            return aClass;
        });
        if (baseClass == null) {
            return false;
        }
        int api = this.getMinApiLevel();
        for (String tagName : baseClassTagNames = LayoutViewClassUtils.getTagNamesByClass(baseClass, api)) {
            map2.put(tagName, baseClass);
        }
        try {
            ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true).forEach(c -> {
                String[] tagNames;
                for (String tagName : tagNames = LayoutViewClassUtils.getTagNamesByClass(c, api)) {
                    map2.put(tagName, (PsiClass)c);
                }
                return true;
            });
        }
        catch (IndexNotReadyException e) {
            Logger.getInstance(this.getClass()).info((Throwable)e);
            return false;
        }
        return !map2.isEmpty();
    }

    private int getMinApiLevel() {
        AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(this.myModule);
        return androidModuleInfo == null ? 1 : androidModuleInfo.getModuleMinApi();
    }

    public void clear() {
        this.myInitialClassMaps.clear();
    }
}

