/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.Client;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.android.actions.AndroidProcessChooserDialog;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidConnectDebuggerAction
extends AnAction {
    private final boolean isAndroidStudio = IdeInfo.getInstance().isAndroidStudio();

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        AndroidProcessChooserDialog dialog2 = new AndroidProcessChooserDialog(project, true);
        dialog2.show();
        if (dialog2.getExitCode() == 0) {
            Client client = dialog2.getClient();
            if (client == null) {
                return;
            }
            AppExecutorUtil.getAppExecutorService().submit(() -> AndroidConnectDebuggerAction.closeOldSessionAndRun(project, dialog2.getAndroidDebugger(), client));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Project project = e.getProject();
        boolean isVisible = this.isAndroidStudio || project != null && ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID);
        e.getPresentation().setVisible(isVisible);
    }

    @Slow
    private static void closeOldSessionAndRun(@NotNull Project project, @NotNull AndroidDebugger androidDebugger, @NotNull Client client) {
        AndroidConnectDebuggerAction.terminateRunSessions(project, client);
        androidDebugger.attachToClient(project, client);
    }

    private static void terminateRunSessions(@NotNull Project project, @NotNull Client selectedClient) {
        int pid = selectedClient.getClientData().getPid();
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            Client client;
            if (!(handler instanceof AndroidProcessHandler) || (client = ((AndroidProcessHandler)handler).getClient(selectedClient.getDevice())) == null || client.getClientData().getPid() != pid) continue;
            handler.notifyTextAvailable("Disconnecting run session: a new debug session will be established.\n", ProcessOutputTypes.STDOUT);
            handler.detachProcess();
            break;
        }
    }
}

