/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.Maps;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.JTextField;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.actions.ElementCreatingValidator;
import org.jetbrains.android.uipreview.DeviceConfiguratorPanel;
import org.jetbrains.android.uipreview.InvalidOptionValueException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateResourceFileDialogBase
extends DialogWrapper {
    protected final Map<ResourceFolderType, CreateTypedResourceFileAction> myResType2ActionMap = Maps.newEnumMap(ResourceFolderType.class);

    protected CreateResourceFileDialogBase(@Nullable Project project) {
        super(project);
    }

    @NotNull
    public abstract PsiElement[] getCreatedElements();

    @NotNull
    public abstract String getFileName();

    @Nullable
    protected String getHelpId() {
        return "reference.new.resource.file";
    }

    protected String setupSubActions(@NotNull Collection<CreateTypedResourceFileAction> actions2, @NotNull TemplateKindCombo resourceTypeCombo, @Nullable ResourceFolderType folderType) {
        CreateTypedResourceFileAction[] actionArray = actions2.toArray(new CreateTypedResourceFileAction[0]);
        Arrays.sort(actionArray, (a1, a2) -> a1.toString().compareTo(a2.toString()));
        String selectedTemplate = null;
        for (CreateTypedResourceFileAction action2 : actionArray) {
            ResourceFolderType resType = action2.getResourceFolderType();
            assert (!this.myResType2ActionMap.containsKey(resType));
            this.myResType2ActionMap.put(resType, action2);
            resourceTypeCombo.addItem(action2.toString(), null, resType.getName());
            if (folderType == null || folderType != resType) continue;
            selectedTemplate = resType.getName();
        }
        return selectedTemplate;
    }

    protected CreateTypedResourceFileAction getSelectedAction(TemplateKindCombo resourceTypeCombo) {
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)resourceTypeCombo.getSelectedName());
        if (folderType == null) {
            return null;
        }
        return this.myResType2ActionMap.get(folderType);
    }

    protected DeviceConfiguratorPanel setupDeviceConfigurationPanel(final JTextField directoryNameTextField, final TemplateKindCombo resourceTypeCombo, final JBLabel errorLabel) {
        return new DeviceConfiguratorPanel(){

            @Override
            public void applyEditors() {
                try {
                    this.doApplyEditors();
                    FolderConfiguration config = this.getConfiguration();
                    CreateTypedResourceFileAction selectedAction = CreateResourceFileDialogBase.this.getSelectedAction(resourceTypeCombo);
                    errorLabel.setText("");
                    directoryNameTextField.setText("");
                    if (selectedAction != null) {
                        ResourceFolderType resFolderType = selectedAction.getResourceFolderType();
                        directoryNameTextField.setText(config.getFolderName(resFolderType));
                    }
                }
                catch (InvalidOptionValueException e) {
                    errorLabel.setText(new HtmlBuilder().openHtmlBody().coloredText((Color)JBColor.RED, e.getMessage()).closeHtmlBody().getHtml());
                    directoryNameTextField.setText("");
                }
                CreateResourceFileDialogBase.this.updateOkAction();
            }
        };
    }

    protected abstract void updateOkAction();

    public static interface ValidatorFactory {
        @NotNull
        public ElementCreatingValidator create(@NotNull PsiDirectory var1, @NotNull String var2, @Nullable String var3);
    }
}

