/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdListDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAndroidAvdManagerAction
extends DumbAwareAction {
    @Nullable
    private AvdListDialog myDialog;

    public RunAndroidAvdManagerAction() {
        super(RunAndroidAvdManagerAction.getName());
    }

    public RunAndroidAvdManagerAction(@Nullable String name) {
        super(name);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        if (SystemInfo.isChromeOS) {
            presentation.setVisible(false);
            return;
        }
        presentation.setEnabled(AndroidSdkUtils.isAndroidSdkAvailable());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.openAvdManager(e.getProject());
    }

    public void openAvdManager(@Nullable Project project) {
        if (SystemInfo.isChromeOS) {
            return;
        }
        if (this.myDialog == null) {
            this.myDialog = new AvdListDialog(project);
            this.myDialog.init();
            this.myDialog.show();
            Disposer.register((Disposable)this.myDialog, () -> {
                this.myDialog = null;
            });
        } else {
            this.myDialog.getFrame().toFront();
        }
    }

    @Nullable
    public AvdInfo getSelected() {
        return this.myDialog == null ? null : this.myDialog.getSelected();
    }

    @NotNull
    public static String getName() {
        return AndroidBundle.message("android.run.avd.manager.action.text", new Object[0]);
    }
}

