/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceNameKeyedMap;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.AndroidLightInnerClassBase;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InnerRClassBase
extends AndroidLightInnerClassBase {
    private static final Logger LOG = Logger.getInstance(InnerRClassBase.class);
    @NotNull
    protected final ResourceType myResourceType;
    @Nullable
    private CachedValue<PsiField[]> myFieldsCache;
    protected static PsiType INT_ARRAY = PsiType.INT.createArrayType();

    public InnerRClassBase(@NotNull PsiClass context, @NotNull ResourceType resourceType) {
        super(context, resourceType.getName());
        this.myResourceType = resourceType;
    }

    @NotNull
    protected static PsiField[] buildResourceFields(@NotNull ResourceRepository repository, @NotNull ResourceNamespace namespace, @NotNull AndroidLightField.FieldModifier fieldModifier, @NotNull BiPredicate<ResourceType, String> isPublic, @NotNull ResourceType resourceType, @NotNull PsiClass context) {
        HashMap<String, PsiType> fieldNames = new HashMap<String, PsiType>();
        PsiType basicType = ResourceType.STYLEABLE == resourceType ? INT_ARRAY : PsiType.INT;
        for (String resName : repository.getResources(namespace, resourceType).keySet()) {
            fieldNames.put(resName, basicType);
        }
        if (ResourceType.STYLEABLE == resourceType) {
            Collection items2 = repository.getResources(namespace, ResourceType.STYLEABLE).values();
            for (ResourceItem item : items2) {
                StyleableResourceValue value2 = (StyleableResourceValue)item.getResourceValue();
                if (value2 == null) continue;
                List attributes = value2.getAllAttributes();
                for (AttrResourceValue attr : attributes) {
                    if (!isPublic.test(attr.getResourceType(), attr.getName())) continue;
                    ResourceNamespace attrNamespace = attr.getNamespace();
                    String packageName = attrNamespace.getPackageName();
                    if (attrNamespace.equals((Object)namespace) || StringUtil.isEmpty((String)packageName)) {
                        fieldNames.put(item.getName() + '_' + attr.getName(), (PsiType)PsiType.INT);
                        continue;
                    }
                    String fieldName = ResourceNameKeyedMap.flattenResourceName((String)item.getName()) + '_' + ResourceNameKeyedMap.flattenResourceName((String)packageName) + '_' + ResourceNameKeyedMap.flattenResourceName((String)attr.getName());
                    fieldNames.put(fieldName, (PsiType)PsiType.INT);
                }
            }
        }
        return InnerRClassBase.buildResourceFields(fieldNames, resourceType, context, fieldModifier);
    }

    @NotNull
    protected static PsiField[] buildResourceFields(@NotNull Map<String, PsiType> fieldNames, @NotNull ResourceType resourceType, @NotNull PsiClass context, @NotNull AndroidLightField.FieldModifier fieldModifier) {
        PsiField[] result2 = new PsiField[fieldNames.size()];
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        int idIterator = resourceType.ordinal() * 100000;
        int i2 = 0;
        for (Map.Entry<String, PsiType> entry : fieldNames.entrySet()) {
            String fieldName = AndroidResourceUtil.getFieldNameByResourceName(entry.getKey());
            PsiType type = entry.getValue();
            int id = -idIterator++;
            AndroidLightField field2 = new AndroidLightField(fieldName, context, type, fieldModifier, fieldModifier == AndroidLightField.FieldModifier.FINAL ? Integer.valueOf(id) : null);
            field2.setInitializer(factory.createExpressionFromText(Integer.toString(id), (PsiElement)field2));
            result2[i2++] = field2;
        }
        return result2;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        if (this.myFieldsCache == null) {
            this.myFieldsCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Recomputing fields for " + (Object)((Object)this));
                }
                return CachedValueProvider.Result.create((Object)this.doGetFields(), (Object[])this.getFieldsDependencies());
            });
        }
        return (PsiField[])this.myFieldsCache.getValue();
    }

    @NotNull
    protected abstract PsiField[] doGetFields();

    @NotNull
    protected abstract Object[] getFieldsDependencies();

    @NotNull
    public ResourceType getResourceType() {
        return this.myResourceType;
    }
}

