/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceRepositoryRClass;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.InnerRClassBase;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.annotations.NotNull;

public class ResourceRepositoryInnerRClass
extends InnerRClassBase {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ResourceRepositoryRClass.ResourcesSource mySource;

    public ResourceRepositoryInnerRClass(@NotNull AndroidFacet facet, @NotNull ResourceType resourceType, @NotNull ResourceRepositoryRClass.ResourcesSource source, @NotNull PsiClass parentClass) {
        super(parentClass, resourceType);
        this.myFacet = facet;
        this.mySource = source;
    }

    @NotNull
    static PsiField[] buildLocalResourceFields(@NotNull AndroidFacet facet, @NotNull ResourceType resourceType, @NotNull ResourceRepositoryRClass.ResourcesSource resourcesSource, @NotNull PsiClass context) {
        Module circularDepLibWithSamePackage = AndroidCompileUtil.findCircularDependencyOnLibraryWithSamePackage(facet);
        AndroidLightField.FieldModifier modifier2 = !((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject() && circularDepLibWithSamePackage == null ? AndroidLightField.FieldModifier.FINAL : AndroidLightField.FieldModifier.NON_FINAL;
        LocalResourceManager resourceManager = ModuleResourceManagers.getInstance(facet).getLocalResourceManager();
        return InnerRClassBase.buildResourceFields((ResourceRepository)resourcesSource.getResourceRepository(), resourcesSource.getResourceNamespace(), modifier2, (type, name) -> resourceManager.isResourcePublic(type.getName(), (String)name), resourceType, context);
    }

    @Override
    @NotNull
    protected PsiField[] doGetFields() {
        return ResourceRepositoryInnerRClass.buildLocalResourceFields(this.myFacet, this.myResourceType, this.mySource, this);
    }

    @Override
    public PsiField findFieldByName(String name, boolean checkBases) {
        if (this.myResourceType == ResourceType.STYLEABLE || !((AndroidFacetConfiguration)this.myFacet.getConfiguration()).isLibraryProject()) {
            return super.findFieldByName(name, checkBases);
        }
        if (!this.mySource.getResourceRepository().hasResources(this.mySource.getResourceNamespace(), this.myResourceType, name)) {
            return null;
        }
        return new AndroidLightField(name, this, (PsiType)PsiType.INT, AndroidLightField.FieldModifier.NON_FINAL, null);
    }

    @Override
    @NotNull
    protected Object[] getFieldsDependencies() {
        return new Object[]{this.mySource.getResourceRepository()};
    }
}

