/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.lang.aidl.AidlFileType;
import com.android.tools.idea.lang.rs.AndroidRenderscriptFileType;
import com.android.tools.idea.res.PsiProjectListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.ModuleSourceAutogenerating;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidResourceFilesListener
implements Disposable,
BulkFileListener {
    private static final Key<String> CACHED_PACKAGE_KEY = Key.create((String)"ANDROID_RESOURCE_LISTENER_CACHED_PACKAGE");
    private final MergingUpdateQueue myQueue;
    private final Project myProject;

    public AndroidResourceFilesListener(@NotNull Project project) {
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue("AndroidResourcesCompilationQueue", 300, true, null, (Disposable)this, null, false);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        Set<VirtualFile> filesToProcess = AndroidResourceFilesListener.getFilesToProcess(events);
        if (!filesToProcess.isEmpty()) {
            this.myQueue.queue((Update)new MyUpdate(filesToProcess));
        }
    }

    @NotNull
    private static Set<VirtualFile> getFilesToProcess(@NotNull List<? extends VFileEvent> events) {
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file == null || !PsiProjectListener.isRelevantFile(file)) continue;
            result2.add(file);
        }
        return result2;
    }

    public void dispose() {
    }

    private class MyUpdate
    extends Update {
        private final Set<VirtualFile> myFiles;

        MyUpdate(Set<VirtualFile> files2) {
            super(files2);
            this.myFiles = files2;
        }

        public void run() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            MultiMap map2 = (MultiMap)ApplicationManager.getApplication().runReadAction(() -> this.computeCompilersToRunAndInvalidateLocalAttributesMap());
            if (map2.isEmpty()) {
                return;
            }
            for (Map.Entry entry : map2.entrySet()) {
                Module module = (Module)entry.getKey();
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null || !ModuleSourceAutogenerating.requiresAutoSourceGeneration(facet)) continue;
                ModuleSourceAutogenerating sourceAutogenerator = ModuleSourceAutogenerating.getInstance(facet);
                assert (sourceAutogenerator != null);
                for (AndroidAutogeneratorMode mode : (Collection)entry.getValue()) {
                    sourceAutogenerator.scheduleSourceRegenerating(mode);
                }
            }
        }

        @NotNull
        private MultiMap<Module, AndroidAutogeneratorMode> computeCompilersToRunAndInvalidateLocalAttributesMap() {
            if (AndroidResourceFilesListener.this.myProject.isDisposed()) {
                return MultiMap.emptyInstance();
            }
            MultiMap result2 = MultiMap.create();
            for (VirtualFile file : this.myFiles) {
                List<AndroidAutogeneratorMode> modes;
                AndroidFacet facet;
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)AndroidResourceFilesListener.this.myProject);
                if (module == null || module.isDisposed() || (facet = AndroidFacet.getInstance(module)) == null || (modes = this.computeCompilersToRunAndInvalidateLocalAttributesMap(facet, file)).isEmpty()) continue;
                result2.putValues((Object)module, modes);
            }
            return result2;
        }

        @NotNull
        private List<AndroidAutogeneratorMode> computeCompilersToRunAndInvalidateLocalAttributesMap(AndroidFacet facet, VirtualFile file) {
            VirtualFile sourceRoot;
            VirtualFile parent = file.getParent();
            if (parent == null) {
                return Collections.emptyList();
            }
            Module module = facet.getModule();
            VirtualFile manifestFile = AndroidRootUtil.getManifestFile(facet);
            ArrayList<AndroidAutogeneratorMode> modes = new ArrayList<AndroidAutogeneratorMode>();
            if (Comparing.equal((Object)manifestFile, (Object)file)) {
                Manifest manifest = facet.getManifest();
                String aPackage = manifest != null ? (String)manifest.getPackage().getValue() : null;
                String cachedPackage = (String)facet.getUserData(CACHED_PACKAGE_KEY);
                if (cachedPackage != null && !cachedPackage.equals(aPackage)) {
                    String aptGenDirPath = AndroidRootUtil.getAptGenSourceRootPath(facet);
                    AndroidCompileUtil.removeDuplicatingClasses(module, cachedPackage, "R", null, aptGenDirPath);
                }
                facet.putUserData(CACHED_PACKAGE_KEY, aPackage);
                modes.add(AndroidAutogeneratorMode.AAPT);
                modes.add(AndroidAutogeneratorMode.BUILDCONFIG);
            } else if (file.getFileType() == AidlFileType.INSTANCE) {
                VirtualFile sourceRoot2 = AndroidUtils.findSourceRoot(module, file);
                if (sourceRoot2 != null && !Comparing.equal((Object)AndroidRootUtil.getAidlGenDir(facet), (Object)sourceRoot2)) {
                    modes.add(AndroidAutogeneratorMode.AIDL);
                }
            } else if (file.getFileType() == AndroidRenderscriptFileType.INSTANCE && (sourceRoot = AndroidUtils.findSourceRoot(module, file)) != null && !Comparing.equal((Object)AndroidRootUtil.getRenderscriptGenDir(facet), (Object)sourceRoot)) {
                modes.add(AndroidAutogeneratorMode.RENDERSCRIPT);
            }
            return modes;
        }

        public boolean canEat(Update update2) {
            return update2 instanceof MyUpdate && this.myFiles.containsAll(((MyUpdate)update2).myFiles);
        }
    }
}

