/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.apk.ApkFacet;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleSourceAutogenerating {
    private final Set<AndroidAutogeneratorMode> myDirtyModes = EnumSet.noneOf(AndroidAutogeneratorMode.class);
    private Sdk myPrevSdk;
    @GuardedBy(value="myAutogeneratedFiles")
    private final Map<AndroidAutogeneratorMode, Set<String>> myAutogeneratedFiles = new HashMap<AndroidAutogeneratorMode, Set<String>>();

    @Nullable
    public static ModuleSourceAutogenerating getInstance(@NotNull AndroidFacet facet) {
        return (ModuleSourceAutogenerating)ModuleServiceManager.getService((Module)facet.getModule(), ModuleSourceAutogenerating.class);
    }

    private ModuleSourceAutogenerating(final @NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            throw new IllegalArgumentException(module.getName() + " is not an Android module");
        }
        if (!ModuleSourceAutogenerating.requiresAutoSourceGeneration(facet)) {
            throw new IllegalArgumentException(module.getName() + " is built by an external build system and should not require the IDE to generate sources");
        }
        this.scheduleSourceRegenerating(AndroidAutogeneratorMode.AAPT);
        this.scheduleSourceRegenerating(AndroidAutogeneratorMode.AIDL);
        this.scheduleSourceRegenerating(AndroidAutogeneratorMode.RENDERSCRIPT);
        this.scheduleSourceRegenerating(AndroidAutogeneratorMode.BUILDCONFIG);
        this.myPrevSdk = ModuleRootManager.getInstance((Module)module).getSdk();
        module.getMessageBus().connect((Disposable)facet).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Sdk newSdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (newSdk != null && newSdk.getSdkType() instanceof AndroidSdkType && !newSdk.equals(ModuleSourceAutogenerating.this.myPrevSdk)) {
                    ModuleSourceAutogenerating.this.myPrevSdk = newSdk;
                    ModuleSourceAutogenerating.this.resetRegeneratingState();
                }
            }
        });
    }

    public static boolean requiresAutoSourceGeneration(@NotNull AndroidFacet facet) {
        return !facet.requiresAndroidModel() && ApkFacet.getInstance(facet.getModule()) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGeneratedFileRemoved(@NotNull AndroidAutogeneratorMode mode) {
        Map<AndroidAutogeneratorMode, Set<String>> map2 = this.myAutogeneratedFiles;
        synchronized (map2) {
            Set<String> filePaths = this.myAutogeneratedFiles.get((Object)mode);
            if (filePaths != null) {
                for (String path : filePaths) {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                    if (file != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        Map<AndroidAutogeneratorMode, Set<String>> map2 = this.myAutogeneratedFiles;
        synchronized (map2) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set != null) {
                set.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileAutogenerated(@NotNull AndroidAutogeneratorMode mode, @NotNull VirtualFile file) {
        Map<AndroidAutogeneratorMode, Set<String>> map2 = this.myAutogeneratedFiles;
        synchronized (map2) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set == null) {
                set = new HashSet<String>();
                this.myAutogeneratedFiles.put(mode, set);
            }
            set.add(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<String> getAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        Map<AndroidAutogeneratorMode, Set<String>> map2 = this.myAutogeneratedFiles;
        synchronized (map2) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            return set != null ? new HashSet<String>(set) : Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSourceRegenerating(@NotNull AndroidAutogeneratorMode mode) {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            this.myDirtyModes.add(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanRegeneratingState(@NotNull AndroidAutogeneratorMode mode) {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            return this.myDirtyModes.remove((Object)mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRegeneratingState() {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            Collections.addAll(this.myDirtyModes, AndroidAutogeneratorMode.values());
        }
    }
}

