/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlTagNameProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.dom.XmlTagInnerClassInsertHandler;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLayoutXmlTagNameProvider
implements XmlTagNameProvider {
    private static final List<String> NAMESPACES = Collections.singletonList("");

    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        PsiFile file = tag.getContainingFile();
        if (!(file instanceof XmlFile) || !LayoutDomFileDescription.isLayoutFile((XmlFile)file)) {
            return;
        }
        XmlExtension xmlExtension = XmlExtension.getExtension((PsiFile)file);
        List variants = TagNameVariantCollector.getTagDescriptors((XmlTag)tag, NAMESPACES, null);
        HashSet supportAlternatives = Sets.newHashSet();
        for (XmlElementDescriptor descriptor2 : variants) {
            String qualifiedName = descriptor2.getName((PsiElement)tag);
            if (!qualifiedName.startsWith("android.support.") && !qualifiedName.startsWith("androidx.")) continue;
            supportAlternatives.add(AndroidUtils.getUnqualifiedName(qualifiedName));
        }
        HashSet addedNames = Sets.newHashSet();
        for (XmlElementDescriptor descriptor3 : variants) {
            int priority;
            LookupElementBuilder lookupElement;
            String qualifiedName = descriptor3.getName((PsiElement)tag);
            if (!addedNames.add(qualifiedName)) continue;
            String simpleName = AndroidUtils.getUnqualifiedName(qualifiedName);
            PsiElement declaration = descriptor3.getDeclaration();
            LookupElementBuilder lookupElementBuilder = lookupElement = declaration == null ? LookupElementBuilder.create((String)qualifiedName) : LookupElementBuilder.create((Object)declaration, (String)qualifiedName);
            if (declaration instanceof PsiClass && !LayoutViewClassUtils.isViewClassVisibleAsTag((PsiClass)declaration)) continue;
            boolean isDeprecated = AndroidLayoutXmlTagNameProvider.isDeclarationDeprecated(declaration);
            if (isDeprecated) {
                lookupElement = lookupElement.withStrikeoutness(true);
            }
            if (simpleName != null) {
                lookupElement = lookupElement.withLookupString(simpleName);
            }
            if (descriptor3 instanceof PsiPresentableMetaData) {
                lookupElement = lookupElement.withIcon(((PsiPresentableMetaData)descriptor3).getIcon());
            }
            if (xmlExtension.useXmlTagInsertHandler()) {
                XmlTagInnerClassInsertHandler insertHandler = AndroidLayoutXmlTagNameProvider.isInnerViewClass(descriptor3.getDeclaration()) ? XmlTagInnerClassInsertHandler.INSTANCE : XmlTagInsertHandler.INSTANCE;
                lookupElement = lookupElement.withInsertHandler((InsertHandler)insertHandler);
            }
            int n = priority = isDeprecated ? 10 : 100;
            if (simpleName == null) {
                priority = supportAlternatives.contains(qualifiedName) ? --priority : (priority += 10);
            }
            elements.add(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)priority));
        }
    }

    private static boolean isInnerViewClass(@Nullable PsiElement declaration) {
        if (!(declaration instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)declaration;
        if (aClass.getContainingClass() == null) {
            return false;
        }
        HashSet<PsiClass> visited = new HashSet<PsiClass>();
        while (aClass != null && visited.add(aClass)) {
            if ("android.view.View".equals(aClass.getQualifiedName())) {
                return true;
            }
            aClass = aClass.getSuperClass();
        }
        return false;
    }

    private static boolean isDeclarationDeprecated(@Nullable PsiElement declaration) {
        if (!(declaration instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)declaration;
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        return modifierList.hasAnnotation("java.lang.Deprecated");
    }
}

