/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        ASTNode closingTagName;
        if (!(element instanceof XmlTag)) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null || AndroidFacet.getInstance(module) == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(element.getNode());
        String baseClassQName = AndroidXmlReferenceProvider.computeBaseClass((XmlTag)element);
        if (baseClassQName == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        XmlTag tag = (XmlTag)element;
        if (startTagName != null && AndroidXmlReferenceProvider.areReferencesProvidedByReferenceProvider(startTagName)) {
            AndroidXmlReferenceProvider.addReferences(tag, startTagName.getPsi(), result2, module, baseClassQName, true);
        }
        if ((closingTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(element.getNode())) != null && AndroidXmlReferenceProvider.areReferencesProvidedByReferenceProvider(closingTagName)) {
            AndroidXmlReferenceProvider.addReferences(tag, closingTagName.getPsi(), result2, module, baseClassQName, false);
        }
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static void addReferences(@NotNull XmlTag tag, @NotNull PsiElement nameElement, @NotNull List<PsiReference> result2, @NotNull Module module, @NotNull String baseClassQName, boolean startTag) {
        String text = nameElement.getText();
        if (text == null) {
            return;
        }
        String[] nameParts = text.split("\\.");
        if (nameParts.length == 0) {
            return;
        }
        int offset = 0;
        for (int i2 = 0; i2 < nameParts.length; ++i2) {
            String name = nameParts[i2];
            if (!name.isEmpty()) {
                TextRange range = new TextRange((offset += name.length()) - name.length(), offset);
                boolean isPackage = i2 < nameParts.length - 1;
                result2.add((PsiReference)new MyClassOrPackageReference(tag, nameElement, range, isPackage, module, baseClassQName, startTag));
            }
            ++offset;
        }
    }

    public static boolean areReferencesProvidedByReferenceProvider(ASTNode nameElement) {
        if (nameElement != null) {
            String baseClassQName;
            XmlTag tag;
            PsiElement psiNameElement = nameElement.getPsi();
            XmlTag xmlTag = tag = psiNameElement != null ? (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiNameElement, XmlTag.class) : null;
            if (tag != null && (baseClassQName = AndroidXmlReferenceProvider.computeBaseClass(tag)) != null) {
                return nameElement.getText().contains(".");
            }
        }
        return false;
    }

    @Nullable
    private static String computeBaseClass(XmlTag context) {
        XmlTag parentTag = context.getParentTag();
        if (parentTag != null && "layout".equals(parentTag.getName())) {
            parentTag = null;
        }
        Pair<AndroidDomElement, String> pair = AndroidDomElementDescriptorProvider.getDomElementAndBaseClassQName(parentTag != null ? parentTag : context);
        return pair != null ? (String)pair.getSecond() : null;
    }

    private static class MyClassOrPackageReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiElement myNameElement;
        private final TextRange myRangeInNameElement;
        private final boolean myIsPackage;
        private final Module myModule;
        private final String myBaseClassQName;
        private final boolean myStartTag;

        public MyClassOrPackageReference(@NotNull XmlTag tag, @NotNull PsiElement nameElement, @NotNull TextRange rangeInNameElement, boolean isPackage, @NotNull Module module, @NotNull String baseClassQName, boolean startTag) {
            super((PsiElement)tag, MyClassOrPackageReference.rangeInParent(nameElement, rangeInNameElement), true);
            this.myNameElement = nameElement;
            this.myRangeInNameElement = rangeInNameElement;
            this.myIsPackage = isPackage;
            this.myModule = module;
            this.myBaseClassQName = baseClassQName;
            this.myStartTag = startTag;
        }

        private static TextRange rangeInParent(PsiElement element, TextRange range) {
            int offset = element.getStartOffsetInParent();
            return new TextRange(range.getStartOffset() + offset, range.getEndOffset() + offset);
        }

        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (reference2, incompleteCode) -> this.resolveInner(), false, false);
        }

        @Nullable
        private PsiElement resolveInner() {
            int end = this.myRangeInNameElement.getEndOffset();
            String value2 = this.myNameElement.getText().substring(0, end);
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myElement.getProject());
            return this.myIsPackage ? facade.findPackage(value2) : facade.findClass(value2, this.myModule.getModuleWithDependenciesAndLibrariesScope(false));
        }

        @NotNull
        public Object[] getVariants() {
            String prefix = this.myNameElement.getText().substring(0, this.myRangeInNameElement.getStartOffset());
            if (!this.myStartTag) {
                String startTagName;
                ASTNode startTagNode = XmlChildRole.START_TAG_NAME_FINDER.findChild(this.myElement.getNode());
                if (startTagNode != null && (startTagName = startTagNode.getText()).startsWith(prefix)) {
                    return new Object[]{startTagName.substring(prefix.length())};
                }
                return EMPTY_ARRAY;
            }
            Project project = this.myModule.getProject();
            PsiClass baseClass = JavaPsiFacade.getInstance((Project)project).findClass(this.myBaseClassQName, this.myModule.getModuleWithDependenciesAndLibrariesScope(false));
            if (baseClass == null) {
                return EMPTY_ARRAY;
            }
            ArrayList result2 = new ArrayList();
            ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)this.myModule.getModuleWithDependenciesAndLibrariesScope(false), (boolean)true, (boolean)true, (boolean)false).forEach(psiClass -> {
                if (psiClass.getContainingClass() != null) {
                    return true;
                }
                String name = psiClass.getQualifiedName();
                if (name != null && name.startsWith(prefix) && LayoutViewClassUtils.isViewClassVisibleAsTag(psiClass)) {
                    name = name.substring(prefix.length());
                    result2.add(JavaLookupElementBuilder.forClass((PsiClass)psiClass, (String)name, (boolean)true));
                }
                return true;
            });
            return ArrayUtil.toObjectArray(result2);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String newName2 = this.myIsPackage ? ((PsiPackage)element).getQualifiedName() : ((PsiClass)element).getQualifiedName();
            ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myNameElement);
            TextRange range = new TextRange(0, this.myRangeInNameElement.getEndOffset());
            return manipulator != null ? manipulator.handleContentChange(this.myNameElement, range, newName2) : element;
        }

        @Nullable
        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myNameElement);
            assert (manipulator != null) : "Cannot find manipulator for " + this.myNameElement;
            return manipulator.handleContentChange(this.myNameElement, this.myRangeInNameElement, newElementName);
        }
    }
}

