/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.psi.TagToClassMapper;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtension;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.RequiredImpl;
import org.jetbrains.android.dom.Styleable;
import org.jetbrains.android.dom.animation.InterpolatorElement;
import org.jetbrains.android.dom.animation.fileDescriptions.InterpolatorDomFileDescription;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.dom.attrs.ToolsAttributeUtil;
import org.jetbrains.android.dom.converters.CompositeConverter;
import org.jetbrains.android.dom.converters.ManifestPlaceholderConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.DataBindingElement;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.Tag;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElement;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.dom.menu.MenuItem;
import org.jetbrains.android.dom.navigation.ConcreteDestinationElement;
import org.jetbrains.android.dom.navigation.NavDestinationElement;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.dom.raw.XmlRawResourceElement;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.Intent;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeProcessingUtil {
    private static final String PREFERENCE_TAG_NAME = "Preference";
    private static final ImmutableSet<String> SIZE_NOT_REQUIRED_TAG_NAMES = ImmutableSet.of((Object)"merge", (Object)"TableRow", (Object)"include", (Object)"requestFocus", (Object)"layout", (Object)"data", (Object[])new String[]{"import", "tag"});
    private static final ImmutableSet<String> SIZE_NOT_REQUIRED_PARENT_TAG_NAMES = ImmutableSet.of((Object)"TableRow", (Object)"TableLayout", (Object)"merge", (Object)"GridLayout", (Object)SdkConstants.FQCN_GRID_LAYOUT_V7.oldName(), (Object)SdkConstants.FQCN_GRID_LAYOUT_V7.newName(), (Object[])new String[]{"android.support.percent.PercentRelativeLayout", "android.support.percent.PercentFrameLayout"});

    private AttributeProcessingUtil() {
    }

    private static Logger getLog() {
        return Logger.getInstance(AttributeProcessingUtil.class);
    }

    public static boolean isLayoutAttributeRequired(@NotNull XmlName attributeName, @NotNull DomElement element) {
        String localName = attributeName.getLocalName();
        if (!"layout_width".equals(localName) && !"layout_height".equals(localName)) {
            return false;
        }
        if ((element instanceof LayoutViewElement || element instanceof Fragment) && "http://schemas.android.com/apk/res/android".equals(attributeName.getNamespaceKey())) {
            String tagName;
            XmlElement xmlElement = element.getXmlElement();
            XmlTag tag = xmlElement instanceof XmlTag ? (XmlTag)xmlElement : null;
            String string = tagName = tag != null ? tag.getName() : null;
            if (!(SIZE_NOT_REQUIRED_TAG_NAMES.contains((Object)tagName) || tag != null && tag.getAttribute("style") != null)) {
                String parentTagName;
                XmlTag parentTag = tag != null ? tag.getParentTag() : null;
                String string2 = parentTagName = parentTag != null ? parentTag.getName() : null;
                if (!SIZE_NOT_REQUIRED_PARENT_TAG_NAMES.contains((Object)parentTagName)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private static String getNamespaceUriByResourcePackage(@NotNull AndroidFacet facet, @Nullable String resPackage) {
        if (resPackage == null) {
            String aPackage;
            if (!((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject() || facet.requiresAndroidModel()) {
                return "http://schemas.android.com/apk/res-auto";
            }
            Manifest manifest = facet.getManifest();
            if (manifest != null && (aPackage = (String)manifest.getPackage().getValue()) != null && !aPackage.isEmpty()) {
                return "http://schemas.android.com/apk/res/" + aPackage;
            }
        } else if (resPackage.equals("android")) {
            return "http://schemas.android.com/apk/res/android";
        }
        return null;
    }

    private static void registerStyleableAttributes(@NotNull DomElement element, @NotNull StyleableDefinition styleable, @Nullable String namespaceUri, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skippedAttributes) {
        for (AttributeDefinition attrDef : styleable.getAttributes()) {
            XmlName xmlName = AttributeProcessingUtil.getXmlName(attrDef, namespaceUri);
            if (!skippedAttributes.add(xmlName)) continue;
            AttributeProcessingUtil.registerAttribute(attrDef, xmlName, styleable.getName(), element, callback2);
        }
    }

    private static boolean mustBeSoft(@NotNull Converter converter, @NotNull Collection<AttributeFormat> formats) {
        if (converter instanceof CompositeConverter || converter instanceof ResourceReferenceConverter) {
            return false;
        }
        return formats.size() > 1;
    }

    private static void registerAttribute(@NotNull AttributeDefinition attrDef, @NotNull XmlName xmlName, @Nullable String parentStyleableName, @NotNull DomElement element, @NotNull AttributeProcessor callback2) {
        DomExtension extension = callback2.processAttribute(xmlName, attrDef, parentStyleableName);
        if (extension == null) {
            return;
        }
        Object converter = AndroidDomUtil.getSpecificConverter(xmlName, element);
        if (converter == null) {
            if ("http://schemas.android.com/tools".equals(xmlName.getNamespaceKey())) {
                converter = ToolsAttributeUtil.getConverter(attrDef);
            } else {
                converter = AndroidDomUtil.getConverter(attrDef);
                if (converter != null && element.getParentOfType(Manifest.class, true) != null) {
                    converter = new ManifestPlaceholderConverter((Converter)converter);
                }
            }
        }
        if (converter != null) {
            extension.setConverter(converter, AttributeProcessingUtil.mustBeSoft(converter, attrDef.getFormats()));
        }
        if (element instanceof LayoutElement && AttributeProcessingUtil.isLayoutAttributeRequired(xmlName, element) || element instanceof ManifestElement && AndroidManifestUtils.isRequiredAttribute(xmlName, element)) {
            extension.addCustomAnnotation((Annotation)((Object)new RequiredImpl()));
        }
    }

    private static void registerAttributes(@NotNull AndroidFacet facet, @NotNull DomElement element, @NotNull String styleableName, @Nullable String resPackage, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skipNames) {
        ResourceManager manager = ModuleResourceManagers.getInstance(facet).getResourceManager(resPackage);
        if (manager == null) {
            return;
        }
        AttributeDefinitions attrDefs = manager.getAttributeDefinitions();
        if (attrDefs == null) {
            return;
        }
        String namespace = AttributeProcessingUtil.getNamespaceUriByResourcePackage(facet, resPackage);
        StyleableDefinition styleable = attrDefs.getStyleableByName(styleableName);
        if (styleable != null) {
            AttributeProcessingUtil.registerStyleableAttributes(element, styleable, namespace, callback2, skipNames);
        }
    }

    private static void registerAttributesForClassAndSuperclasses(@NotNull AndroidFacet facet, @NotNull DomElement element, @Nullable PsiClass c, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skipNames) {
        while (c != null) {
            String styleableName = c.getName();
            if (styleableName != null) {
                AttributeProcessingUtil.registerAttributes(facet, element, styleableName, AttributeProcessingUtil.getResourcePackage(c), callback2, skipNames);
            }
            for (PsiClass additional : AttributeProcessingUtil.getAdditionalAttributesClasses(facet, c)) {
                String additionalStyleableName = additional.getName();
                if (additionalStyleableName == null) continue;
                AttributeProcessingUtil.registerAttributes(facet, element, additionalStyleableName, AttributeProcessingUtil.getResourcePackage(additional), callback2, skipNames);
            }
            c = AttributeProcessingUtil.getSuperclass(c);
        }
    }

    private static Collection<PsiClass> getAdditionalAttributesClasses(@NotNull AndroidFacet facet, @NotNull PsiClass c) {
        if (SdkConstants.CLASS_NESTED_SCROLL_VIEW.isEquals(StringUtil.notNullize((String)c.getQualifiedName()))) {
            return Collections.singleton(AttributeProcessingUtil.getViewClassMap(facet).get("ScrollView"));
        }
        return Collections.emptySet();
    }

    @Nullable
    private static String getResourcePackage(@NotNull PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        return qualifiedName != null && qualifiedName.startsWith("android.") && !qualifiedName.startsWith("android.support.") && !qualifiedName.startsWith("androidx.") && !qualifiedName.startsWith("android.arch.") ? "android" : null;
    }

    @Nullable
    private static PsiClass getSuperclass(@NotNull PsiClass c) {
        return (PsiClass)ApplicationManager.getApplication().runReadAction(() -> c.isValid() ? c.getSuperClass() : null);
    }

    public static void processXmlAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull XmlResourceElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback2) {
        PsiClass widgetClass;
        String widgetClassName;
        Map<String, PsiClass> prefClassMap;
        PsiClass psiClass;
        String tagName = tag.getName();
        String styleableName = (String)AndroidXmlResourcesUtil.SPECIAL_STYLEABLE_NAMES.get((Object)tagName);
        if (styleableName != null) {
            HashSet<XmlName> newSkipAttrNames = new HashSet<XmlName>();
            if (element instanceof Intent) {
                newSkipAttrNames.add(new XmlName("action", "http://schemas.android.com/apk/res/android"));
            }
            AttributeProcessingUtil.registerAttributes(facet, element, styleableName, "android", callback2, newSkipAttrNames);
        }
        if ((psiClass = (prefClassMap = AndroidXmlResourcesUtil.isAndroidXPreferenceFile(tag, facet) ? AttributeProcessingUtil.getAndroidXPreferencesClassMap(facet) : AttributeProcessingUtil.getFrameworkPreferencesClassMap(facet)).get(tagName)) == null) {
            return;
        }
        AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, psiClass, callback2, skipAttrNames);
        if (StringUtil.notNullize((String)psiClass.getQualifiedName()).startsWith("android.preference.") && (widgetClassName = AndroidTextUtils.trimEndOrNullize((String)tagName, (String)PREFERENCE_TAG_NAME)) != null && (widgetClass = LayoutViewClassUtils.findClassByTagName(facet, widgetClassName, "android.view.View")) != null) {
            AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, widgetClass, callback2, skipAttrNames);
        }
    }

    public static Map<String, PsiClass> getAndroidXPreferencesClassMap(AndroidFacet facet) {
        if (DumbService.isDumb((Project)facet.getModule().getProject())) {
            return Collections.emptyMap();
        }
        return TagToClassMapper.getInstance(facet.getModule()).getAndroidXClassMap(SdkConstants.CLASS_PREFERENCE_ANDROIDX);
    }

    public static Map<String, PsiClass> getFrameworkPreferencesClassMap(AndroidFacet facet) {
        return AttributeProcessingUtil.getFrameworkClassMap(facet, "android.preference.Preference");
    }

    public static Map<String, PsiClass> getViewClassMap(@NotNull AndroidFacet facet) {
        return AttributeProcessingUtil.getFrameworkClassMap(facet, "android.view.View");
    }

    public static Map<String, PsiClass> getViewGroupClassMap(@NotNull AndroidFacet facet) {
        return AttributeProcessingUtil.getFrameworkClassMap(facet, "android.view.ViewGroup");
    }

    private static Map<String, PsiClass> getFrameworkClassMap(@NotNull AndroidFacet facet, @NotNull String frameworkClass) {
        if (DumbService.isDumb((Project)facet.getModule().getProject())) {
            return Collections.emptyMap();
        }
        return TagToClassMapper.getInstance(facet.getModule()).getFrameworkClassMap(frameworkClass);
    }

    @Nullable
    public static String getLayoutStyleablePrimary(@NotNull PsiClass psiLayoutClass) {
        String viewName = psiLayoutClass.getName();
        if (viewName == null) {
            return null;
        }
        switch (viewName) {
            case "ViewGroup": {
                return "ViewGroup_MarginLayout";
            }
            case "TableRow": {
                return "TableRow_Cell";
            }
        }
        return viewName + "_Layout";
    }

    @Nullable
    public static String getLayoutStyleableSecondary(@NotNull PsiClass psiLayoutClass) {
        String viewName = psiLayoutClass.getName();
        if (viewName == null) {
            return null;
        }
        switch (viewName) {
            case "AppBarLayout": 
            case "CollapsingToolbarLayout": 
            case "CoordinatorLayout": {
                return viewName + "_LayoutParams";
            }
        }
        return null;
    }

    private static void registerAttributesFromSuffixedStyleables(@NotNull AndroidFacet facet, @NotNull DomElement element, @NotNull PsiClass psiClass, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skipAttrNames) {
        String secondary;
        String primary = AttributeProcessingUtil.getLayoutStyleablePrimary(psiClass);
        if (primary != null) {
            AttributeProcessingUtil.registerAttributes(facet, element, primary, AttributeProcessingUtil.getResourcePackage(psiClass), callback2, skipAttrNames);
        }
        if ((secondary = AttributeProcessingUtil.getLayoutStyleableSecondary(psiClass)) != null) {
            AttributeProcessingUtil.registerAttributes(facet, element, secondary, null, callback2, skipAttrNames);
        }
    }

    public static void processNavAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull NavDestinationElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback2) {
        try {
            NavigationSchema.createIfNecessary(facet.getModule());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        NavigationSchema schema = NavigationSchema.get(facet.getModule());
        for (PsiClass psiClass : schema.getStyleablesForTag(tag.getName())) {
            AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, psiClass, callback2, skipAttrNames);
            if (!(element instanceof ConcreteDestinationElement)) continue;
            AttributeProcessingUtil.registerAttribute(new AttributeDefinition(ResourceNamespace.TOOLS, "layout", null, (Collection<AttributeFormat>)ImmutableList.of((Object)AttributeFormat.REFERENCE)), new XmlName("layout", "http://schemas.android.com/tools"), null, element, callback2);
        }
    }

    public static void processLayoutAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull LayoutElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback2) {
        String tagName;
        Map<String, PsiClass> map2 = AttributeProcessingUtil.getViewClassMap(facet);
        if (!(element instanceof DataBindingElement)) {
            PsiClass newRecyclerView;
            PsiClass oldRecyclerView;
            PsiClass newDrawerLayout;
            PsiClass oldDrawerLayout;
            AttributeProcessingUtil.registerToolsAttribute("targetApi", callback2);
            if (tag.getParentTag() == null) {
                AttributeProcessingUtil.registerToolsAttribute("context", callback2);
                AttributeProcessingUtil.registerToolsAttribute("menu", callback2);
                AttributeProcessingUtil.registerToolsAttribute("actionBarNavMode", callback2);
                AttributeProcessingUtil.registerToolsAttribute("showIn", callback2);
            }
            PsiClass adapterView = map2.get("AdapterView");
            String psiClass = map2.get(tag.getName());
            if (adapterView != null && psiClass != null && psiClass.isInheritor(adapterView, true)) {
                AttributeProcessingUtil.registerToolsAttribute("listitem", callback2);
                AttributeProcessingUtil.registerToolsAttribute("listheader", callback2);
                AttributeProcessingUtil.registerToolsAttribute("listfooter", callback2);
            }
            if ((oldDrawerLayout = map2.get(SdkConstants.CLASS_DRAWER_LAYOUT.oldName())) != null && psiClass != null && (psiClass.isEquivalentTo((PsiElement)oldDrawerLayout) || psiClass.isInheritor(oldDrawerLayout, true))) {
                AttributeProcessingUtil.registerToolsAttribute("openDrawer", callback2);
            }
            if ((newDrawerLayout = map2.get(SdkConstants.CLASS_DRAWER_LAYOUT.newName())) != null && psiClass != null && (psiClass.isEquivalentTo((PsiElement)newDrawerLayout) || psiClass.isInheritor(newDrawerLayout, true))) {
                AttributeProcessingUtil.registerToolsAttribute("openDrawer", callback2);
            }
            if ((oldRecyclerView = map2.get(SdkConstants.RECYCLER_VIEW.oldName())) != null && psiClass != null && (psiClass.isEquivalentTo((PsiElement)oldRecyclerView) || psiClass.isInheritor(oldRecyclerView, true))) {
                AttributeProcessingUtil.registerToolsAttribute("itemCount", callback2);
                AttributeProcessingUtil.registerToolsAttribute("listitem", callback2);
            }
            if ((newRecyclerView = map2.get(SdkConstants.RECYCLER_VIEW.newName())) != null && psiClass != null && (psiClass.isEquivalentTo((PsiElement)newRecyclerView) || psiClass.isInheritor(newRecyclerView, true))) {
                AttributeProcessingUtil.registerToolsAttribute("itemCount", callback2);
                AttributeProcessingUtil.registerToolsAttribute("listitem", callback2);
            }
            if (((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue()) {
                AttributeProcessingUtil.registerToolsAttribute("mockup", callback2);
                AttributeProcessingUtil.registerToolsAttribute("mockup_crop", callback2);
                AttributeProcessingUtil.registerToolsAttribute("mockup_opacity", callback2);
            }
        }
        if (element instanceof Tag || element instanceof Data) {
            return;
        }
        switch (tagName = tag.getName()) {
            case "fragment": {
                AttributeProcessingUtil.registerToolsAttribute("layout", callback2);
                break;
            }
            case "view": {
                for (PsiClass aClass : map2.values()) {
                    String name = aClass.getName();
                    if (name == null) continue;
                    AttributeProcessingUtil.registerAttributes(facet, element, name, AttributeProcessingUtil.getResourcePackage(aClass), callback2, skipAttrNames);
                }
                break;
            }
            case "merge": {
                if (tag.getParentTag() == null) {
                    AttributeProcessingUtil.registerToolsAttribute("parentTag", callback2);
                }
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, map2.get("merge"), callback2, skipAttrNames);
                String parentTagName = tag.getAttributeValue("parentTag", "http://schemas.android.com/tools");
                if (parentTagName == null) break;
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, map2.get(parentTagName), callback2, skipAttrNames);
                break;
            }
            default: {
                PsiClass c = map2.get(tagName);
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet, element, c, callback2, skipAttrNames);
            }
        }
        if (tagName.equals("merge")) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag != null) {
            String parentTagName = parentTag.getName();
            if ("merge".equals(parentTagName)) {
                parentTagName = parentTag.getAttributeValue("parentTag", "http://schemas.android.com/tools");
            }
            if ("layout".equals(parentTagName)) {
                parentTagName = "ViewGroup";
            }
            if (parentTagName != null) {
                PsiClass c = map2.get(parentTagName);
                while (c != null) {
                    AttributeProcessingUtil.registerAttributesFromSuffixedStyleables(facet, element, c, callback2, skipAttrNames);
                    c = AttributeProcessingUtil.getSuperclass(c);
                }
                return;
            }
        }
        for (PsiClass c : map2.values()) {
            AttributeProcessingUtil.registerAttributesFromSuffixedStyleables(facet, element, c, callback2, skipAttrNames);
        }
    }

    public static void processAttributes(@NotNull AndroidDomElement element, @NotNull AndroidFacet facet, boolean processAllExistingAttrsFirst, @NotNull AttributeProcessor callback2) {
        String styleableName;
        AttributeDefinitions definitions;
        HashSet<XmlName> skippedAttributes;
        if (DumbService.getInstance((Project)facet.getModule().getProject()).isDumb()) {
            return;
        }
        XmlTag tag = element.getXmlTag();
        assert (tag != null);
        Set<XmlName> set = skippedAttributes = processAllExistingAttrsFirst ? AttributeProcessingUtil.registerExistingAttributes(facet, tag, element, callback2) : new HashSet<XmlName>();
        if (element instanceof ManifestElement) {
            AttributeProcessingUtil.processManifestAttributes(tag, element, callback2);
        } else if (element instanceof LayoutElement) {
            AttributeProcessingUtil.processLayoutAttributes(facet, tag, (LayoutElement)element, skippedAttributes, callback2);
        } else if (element instanceof XmlResourceElement) {
            AttributeProcessingUtil.processXmlAttributes(facet, tag, (XmlResourceElement)element, skippedAttributes, callback2);
        } else if (element instanceof XmlRawResourceElement) {
            AttributeProcessingUtil.processRawAttributes(tag, callback2);
        } else if (element instanceof NavDestinationElement) {
            AttributeProcessingUtil.processNavAttributes(facet, tag, (NavDestinationElement)element, skippedAttributes, callback2);
        }
        Styleable styleableAnnotation = (Styleable)element.getAnnotation(Styleable.class);
        if (styleableAnnotation == null) {
            return;
        }
        boolean isSystem = styleableAnnotation.packageName().equals("android");
        if (isSystem) {
            String[] manager = ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager();
            if (manager == null) {
                return;
            }
            definitions = manager.getAttributeDefinitions();
            if (definitions == null) {
                return;
            }
        } else {
            definitions = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getAttributeDefinitions();
        }
        if (element instanceof MenuItem) {
            AttributeProcessingUtil.processMenuItemAttributes(facet, element, skippedAttributes, callback2);
            return;
        }
        for (String styleableName2 : styleableAnnotation.value()) {
            StyleableDefinition styleable = definitions.getStyleableByName(styleableName2);
            if (styleable != null) {
                AttributeProcessingUtil.registerStyleableAttributes(element, styleable, isSystem ? "http://schemas.android.com/apk/res/android" : "http://schemas.android.com/apk/res-auto", callback2, skippedAttributes);
                continue;
            }
            if (!isSystem) continue;
            AttributeProcessingUtil.getLog().warn(String.format("@Styleable(%s) annotation doesn't point to existing styleable", styleableName2));
        }
        if (element instanceof InterpolatorElement && (styleableName = InterpolatorDomFileDescription.getInterpolatorStyleableByTagName(tag.getName())) != null) {
            StyleableDefinition styleable = definitions.getStyleableByName(styleableName);
            if (styleable == null) {
                AttributeProcessingUtil.getLog().warn(String.format("%s doesn't point to existing styleable for interpolator", styleableName));
            } else {
                AttributeProcessingUtil.registerStyleableAttributes(element, styleable, "http://schemas.android.com/apk/res/android", callback2, skippedAttributes);
            }
        }
    }

    public static void processRawAttributes(@NotNull XmlTag tag, @NotNull AttributeProcessor callback2) {
        if ("resources".equals(tag.getName())) {
            AttributeProcessingUtil.registerToolsAttribute("shrinkMode", callback2);
            AttributeProcessingUtil.registerToolsAttribute("keep", callback2);
            AttributeProcessingUtil.registerToolsAttribute("discard", callback2);
        }
    }

    public static void processManifestAttributes(@NotNull XmlTag tag, @NotNull AndroidDomElement element, @NotNull AttributeProcessor callback2) {
        if (tag.getParentTag() != null) {
            AttributeProcessingUtil.registerToolsAttribute("node", callback2);
            AttributeProcessingUtil.registerToolsAttribute("strict", callback2);
            AttributeProcessingUtil.registerToolsAttribute("remove", callback2);
            AttributeProcessingUtil.registerToolsAttribute("replace", callback2);
        }
        if (element instanceof UsesSdk) {
            AttributeProcessingUtil.registerToolsAttribute("overrideLibrary", callback2);
        }
    }

    private static void processMenuItemAttributes(@NotNull AndroidFacet facet, @NotNull DomElement element, @NotNull Collection<XmlName> skippedAttributes, @NotNull AttributeProcessor callback2) {
        FrameworkResourceManager manager = ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager();
        if (manager == null) {
            return;
        }
        AttributeDefinitions styleables = ((ResourceManager)manager).getAttributeDefinitions();
        if (styleables == null) {
            return;
        }
        StyleableDefinition styleable = styleables.getStyleableByName("MenuItem");
        if (styleable == null) {
            AttributeProcessingUtil.getLog().warn("No StyleableDefinition for MenuItem");
            return;
        }
        for (AttributeDefinition attribute : styleable.getAttributes()) {
            XmlName xmlName;
            String name = attribute.getName();
            if (name.equals("showAsAction")) {
                boolean hasAppCompat;
                boolean bl = hasAppCompat = DependencyManagementUtil.dependsOn(facet.getModule(), GoogleMavenArtifactId.APP_COMPAT_V7) || DependencyManagementUtil.dependsOn(facet.getModule(), GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
                if (hasAppCompat) {
                    XmlName xmlName2 = new XmlName(name, "http://schemas.android.com/apk/res-auto");
                    if (!skippedAttributes.add(xmlName2)) continue;
                    AttributeProcessingUtil.registerAttribute(attribute, xmlName2, "MenuItem", element, callback2);
                    continue;
                }
            }
            if (!skippedAttributes.add(xmlName = new XmlName(name, "http://schemas.android.com/apk/res/android"))) continue;
            AttributeProcessingUtil.registerAttribute(attribute, xmlName, "MenuItem", element, callback2);
        }
    }

    private static void registerToolsAttribute(@NotNull String attributeName, @NotNull AttributeProcessor callback2) {
        AttributeDefinition definition = ToolsAttributeUtil.getAttrDefByName(attributeName);
        if (definition != null) {
            XmlName name = new XmlName(attributeName, "http://schemas.android.com/tools");
            DomExtension domExtension = callback2.processAttribute(name, definition, null);
            Converter converter = ToolsAttributeUtil.getConverter(definition);
            if (domExtension != null && converter != null) {
                domExtension.setConverter(converter);
            }
        } else {
            AttributeProcessingUtil.getLog().warn("No attribute definition for tools attribute " + attributeName);
        }
    }

    @NotNull
    private static Set<XmlName> registerExistingAttributes(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull AndroidDomElement element, @NotNull AttributeProcessor callback2) {
        XmlAttribute[] attrs;
        HashSet<XmlName> result2 = new HashSet<XmlName>();
        for (XmlAttribute attr : attrs = tag.getAttributes()) {
            AttributeDefinition attrDef;
            String localName = attr.getLocalName();
            if (localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED) || "xmlns".equals(attr.getNamespacePrefix()) || (attrDef = AndroidDomUtil.getAttributeDefinition(facet, attr)) == null) continue;
            XmlName xmlName = AttributeProcessingUtil.getXmlName(attrDef, attr.getNamespace());
            result2.add(xmlName);
            String namespaceUri = attr.getNamespace();
            AttributeProcessingUtil.registerAttribute(attrDef, xmlName, null, element, callback2);
        }
        return result2;
    }

    private static XmlName getXmlName(@NotNull AttributeDefinition attrDef, @Nullable String namespaceUri) {
        ResourceReference attrReference = attrDef.getResourceReference();
        String attrNamespaceUri = attrReference.getNamespace().getXmlNamespaceUri();
        return new XmlName(attrReference.getName(), "http://schemas.android.com/tools".equals(namespaceUri) ? "http://schemas.android.com/tools" : attrNamespaceUri);
    }

    public static interface AttributeProcessor {
        @Nullable
        public DomExtension processAttribute(@NotNull XmlName var1, @NotNull AttributeDefinition var2, @Nullable String var3);
    }
}

