/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public final class FileDescriptionUtils {
    private FileDescriptionUtils() {
    }

    public static boolean isResourceOfTypeWithRootTag(@NotNull XmlFile file, @NotNull ResourceFolderType folderType, @NotNull Collection<String> rootTags) {
        return (Boolean)ApplicationManager.getApplication().runReadAction(FileDescriptionUtils.newResourceTypeVerifier(file, folderType, rootTags));
    }

    @NotNull
    private static Stream<XmlTag> asStream(@NotNull XmlTag rootTag) {
        return Stream.concat(Stream.of(rootTag), Arrays.stream(rootTag.getSubTags()).filter(XmlTag.class::isInstance).map(XmlTag.class::cast).flatMap(FileDescriptionUtils::asStream));
    }

    public static boolean isResourceOfTypeContainingTag(@NotNull XmlFile file, @NotNull ResourceFolderType folderType, @NotNull Collection<String> tagNames) {
        Condition tagCondition = tagNames.isEmpty() ? Condition.TRUE : rootTag -> FileDescriptionUtils.asStream(rootTag).anyMatch(tag -> tagNames.contains(tag.getName()));
        return (Boolean)ApplicationManager.getApplication().runReadAction(FileDescriptionUtils.newResourceTypeVerifier(file, folderType, (Condition<XmlTag>)tagCondition));
    }

    @NotNull
    private static Computable<Boolean> newResourceTypeVerifier(@NotNull XmlFile file, @NotNull ResourceFolderType folderType, @NotNull Condition<XmlTag> tagVerifier) {
        return () -> {
            if (file.getProject().isDisposed()) {
                return false;
            }
            if (!AndroidResourceUtil.isInResourceSubdirectory((PsiFile)file, folderType.getName())) {
                return false;
            }
            XmlTag rootTag = file.getRootTag();
            assert (rootTag != null);
            return tagVerifier.value((Object)rootTag);
        };
    }

    @NotNull
    static Computable<Boolean> newResourceTypeVerifier(@NotNull XmlFile file, @NotNull ResourceFolderType folderType, @NotNull Collection<String> rootTags) {
        return rootTags.isEmpty() ? FileDescriptionUtils.newResourceTypeVerifier(file, folderType, (Condition<XmlTag>)Condition.TRUE) : FileDescriptionUtils.newResourceTypeVerifier(file, folderType, (Condition<XmlTag>)((Condition)element -> rootTags.contains(element.getName())));
    }
}

