/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.converters.StaticEnumConverter;
import org.jetbrains.android.dom.converters.TargetApiConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolsAttributeUtil {
    private static final ResolvingConverter LAYOUT_REFERENCE_CONVERTER = new ResourceReferenceConverter(EnumSet.of(ResourceType.LAYOUT));
    private static final Converter ACTIVITY_CLASS_CONVERTER = new PackageClassConverter.Builder().useManifestBasePackage(true).withExtendClassNames("android.app.Activity").build();
    private static final Converter VIEW_CONVERTER = new PackageClassConverter.Builder().completeLibraryClasses(true).withExtendClassNames("android.view.View").withExtraBasePackages("android.widget.").build();
    private static final Converter VIEW_GROUP_CONVERTER = new PackageClassConverter.Builder().completeLibraryClasses(true).withExtendClassNames("android.view.ViewGroup").withExtraBasePackages("android.widget.").build();
    private static final List<AttributeFormat> NO_FORMATS = Collections.emptyList();
    public static final String ATTR_NODE = "node";
    public static final String ATTR_STRICT = "strict";
    public static final String ATTR_REMOVE = "remove";
    public static final String ATTR_REPLACE = "replace";
    public static final String ATTR_OVERRIDE_LIBRARY = "overrideLibrary";
    private static final ImmutableMap<String, List<AttributeFormat>> ATTRIBUTES = ImmutableMap.builder().put((Object)"actionBarNavMode", Collections.singletonList(AttributeFormat.FLAGS)).put((Object)"context", (Object)ImmutableList.of((Object)AttributeFormat.REFERENCE, (Object)AttributeFormat.STRING)).put((Object)"ignore", NO_FORMATS).put((Object)"itemCount", Collections.singletonList(AttributeFormat.INTEGER)).put((Object)"listfooter", Collections.singletonList(AttributeFormat.REFERENCE)).put((Object)"listheader", Collections.singletonList(AttributeFormat.REFERENCE)).put((Object)"listitem", Collections.singletonList(AttributeFormat.REFERENCE)).put((Object)"layout", Collections.singletonList(AttributeFormat.REFERENCE)).put((Object)"locale", NO_FORMATS).put((Object)"menu", NO_FORMATS).put((Object)"mockup", Collections.singletonList(AttributeFormat.STRING)).put((Object)"mockup_opacity", Collections.singletonList(AttributeFormat.FLOAT)).put((Object)"mockup_crop", Collections.singletonList(AttributeFormat.STRING)).put((Object)"openDrawer", Collections.singletonList(AttributeFormat.ENUM)).put((Object)"parentTag", Collections.singletonList(AttributeFormat.STRING)).put((Object)"showIn", Collections.singletonList(AttributeFormat.REFERENCE)).put((Object)"targetApi", NO_FORMATS).put((Object)"node", Collections.singletonList(AttributeFormat.ENUM)).put((Object)"strict", NO_FORMATS).put((Object)"remove", NO_FORMATS).put((Object)"replace", NO_FORMATS).put((Object)"overrideLibrary", NO_FORMATS).put((Object)"shrinkMode", Collections.singletonList(AttributeFormat.ENUM)).put((Object)"keep", NO_FORMATS).put((Object)"discard", NO_FORMATS).put((Object)"useHandler", Collections.singletonList(AttributeFormat.REFERENCE)).put((Object)"srcCompat", Collections.singletonList(AttributeFormat.REFERENCE)).build();
    private static final ImmutableMap<String, Converter> CONVERTERS = ImmutableMap.builder().put((Object)"actionBarNavMode", (Object)new StaticEnumConverter("standard", "list", "tabs")).put((Object)"openDrawer", (Object)new StaticEnumConverter("start", "end", "left", "right")).put((Object)"context", (Object)ACTIVITY_CLASS_CONVERTER).put((Object)"listfooter", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"listheader", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"listitem", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"layout", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"showIn", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"node", (Object)new StaticEnumConverter("merge", "replace", "strict", "merge-only-attributes", "remove", "removeAll")).put((Object)"targetApi", (Object)new TargetApiConverter()).put((Object)"shrinkMode", (Object)new StaticEnumConverter("strict", "safe")).put((Object)"useHandler", (Object)VIEW_CONVERTER).put((Object)"parentTag", (Object)VIEW_GROUP_CONVERTER).build();

    @Nullable
    public static Converter getConverter(@NotNull AttributeDefinition attrDef) {
        String name = attrDef.getName();
        Converter converter = (Converter)CONVERTERS.get((Object)name);
        return converter != null ? converter : AndroidDomUtil.getConverter(attrDef);
    }

    @NotNull
    public static Set<String> getAttributeNames() {
        return ATTRIBUTES.keySet();
    }

    @Nullable
    public static AttributeDefinition getAttrDefByName(@NotNull String name) {
        if (!ATTRIBUTES.containsKey((Object)name)) {
            return null;
        }
        Collection formats = (Collection)ATTRIBUTES.get((Object)name);
        return new AttributeDefinition(ResourceNamespace.TOOLS, name, null, formats);
    }
}

