/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.dom.converters.AndroidConstraintIdsConverter;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J5\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0016\u0010\f\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e\u0018\u00010\rH\u0014\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0014J%\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/android/dom/converters/AndroidConstraintIdsConverter;", "Lcom/intellij/util/xml/converters/DelimitedListConverter;", "Lorg/jetbrains/android/dom/resources/ResourceValue;", "()V", "convertString", "string", "", "context", "Lcom/intellij/util/xml/ConvertContext;", "getReferenceVariants", "", "", "genericDomValue", "Lcom/intellij/util/xml/GenericDomValue;", "", "(Lcom/intellij/util/xml/ConvertContext;Lcom/intellij/util/xml/GenericDomValue;)[Ljava/lang/Object;", "getUnresolvedMessage", "value", "pickMostRelevantId", "Lcom/intellij/psi/ResolveResult;", "resolveResultList", "([Lcom/intellij/psi/ResolveResult;Lcom/intellij/util/xml/ConvertContext;)Lcom/intellij/psi/ResolveResult;", "resolveReference", "Lcom/intellij/psi/PsiElement;", "toString", "intellij.android.core"})
public final class AndroidConstraintIdsConverter
extends DelimitedListConverter<ResourceValue> {
    @Nullable
    protected ResourceValue convertString(@Nullable String string, @Nullable ConvertContext context) {
        ResourceValue resourceValue2 = ResourceValue.reference(string, false);
        if (resourceValue2 == null) {
            return null;
        }
        ResourceValue value2 = resourceValue2;
        value2.setResourceType(ResourceType.ID.getName());
        return value2;
    }

    @Nullable
    protected String toString(@Nullable ResourceValue value2) {
        ResourceValue resourceValue2 = value2;
        return resourceValue2 != null ? resourceValue2.getResourceName() : null;
    }

    @NotNull
    protected Object[] getReferenceVariants(@Nullable ConvertContext context, @Nullable GenericDomValue<? extends List<ResourceValue>> genericDomValue) {
        ConvertContext convertContext = context;
        if (convertContext == null || (convertContext = convertContext.getFile()) == null) {
            return AndroidConstraintIdsConverter.access$getEMPTY_ARRAY$p$s1618771273();
        }
        ConvertContext file = convertContext;
        return ResourceHelper.findIdsInFile((PsiFile)file).stream().map(getReferenceVariants.1.INSTANCE).toArray();
    }

    @Nullable
    protected PsiElement resolveReference(@Nullable ResourceValue value2, @Nullable ConvertContext context) {
        if (value2 == null || context == null || context.getReferenceXmlElement() == null) {
            return null;
        }
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        Module module2 = module;
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet(module2);
        if (androidFacet == null) {
            return null;
        }
        AndroidFacet facet = androidFacet;
        AndroidResourceToPsiResolver androidResourceToPsiResolver = AndroidResourceToPsiResolver.getInstance();
        XmlElement xmlElement = context.getReferenceXmlElement();
        if (xmlElement == null) {
            Intrinsics.throwNpe();
        }
        ResolveResult[] resolveResultList = androidResourceToPsiResolver.resolveToPsi(value2, xmlElement, facet);
        ResolveResult resolveResult = this.pickMostRelevantId(resolveResultList, context);
        return resolveResult != null ? resolveResult.getElement() : null;
    }

    @NotNull
    protected String getUnresolvedMessage(@Nullable String value2) {
        return CodeInsightBundle.message((String)"error.cannot.resolve.default.message", (Object[])new Object[]{value2});
    }

    private final ResolveResult pickMostRelevantId(ResolveResult[] resolveResultList, ConvertContext context) {
        return (ResolveResult)SequencesKt.minWith((Sequence)ArraysKt.asSequence((Object[])resolveResultList), Comparator.comparing(new Function<T, U>(context){
            final /* synthetic */ ConvertContext $context;

            public final boolean apply(ResolveResult it) {
                PsiElement psiElement = it.getElement();
                return Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getContainingFile() : null), (Object)this.$context.getFile()) ^ true;
            }
            {
                this.$context = convertContext;
            }
        }).thenComparing(Comparator.comparing(pickMostRelevantId.2.INSTANCE)));
    }

    public AndroidConstraintIdsConverter() {
        super(",");
    }

    public static final /* synthetic */ Object[] access$getEMPTY_ARRAY$p$s1618771273() {
        return DelimitedListConverter.EMPTY_ARRAY;
    }
}

