/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceReferenceBase
extends PsiReferenceBase.Poly<XmlElement> {
    protected final AndroidFacet myFacet;
    protected final ResourceValue myResourceValue;

    public AndroidResourceReferenceBase(@NotNull GenericDomValue value2, @Nullable TextRange range, @NotNull ResourceValue resourceValue2, @NotNull AndroidFacet facet) {
        super((PsiElement)DomUtil.getValueElement((GenericDomValue)value2), range, true);
        this.myResourceValue = resourceValue2;
        this.myFacet = facet;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return null;
    }

    @NotNull
    public ResourceValue getResourceValue() {
        return this.myResourceValue;
    }

    @NotNull
    public PsiElement[] computeTargetElements() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        ArrayList<PsiElement> results = new ArrayList<PsiElement>();
        for (ResolveResult result2 : resolveResults) {
            PsiElement element = result2.getElement();
            if (element instanceof LazyValueResourceElementWrapper) {
                element = ((LazyValueResourceElementWrapper)element).computeElement();
            }
            if (element instanceof ResourceElementWrapper) {
                element = ((ResourceElementWrapper)element).getWrappedElement();
            }
            if (element == null) continue;
            results.add(element);
        }
        return results.toArray(PsiElement.EMPTY_ARRAY);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        return ResolveCache.getInstance((Project)((XmlElement)this.myElement).getProject()).resolveWithCaching((PsiPolyVariantReference)this, (reference2, incompleteCode1) -> this.resolveInner(), false, incompleteCode);
    }

    @NotNull
    private ResolveResult[] resolveInner() {
        return AndroidResourceToPsiResolver.getInstance().resolveToPsi(this.myResourceValue, (XmlElement)this.myElement, this.myFacet);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element instanceof LazyValueResourceElementWrapper && (element = ((LazyValueResourceElementWrapper)element).computeElement()) == null) {
            return false;
        }
        ResolveResult[] results = this.multiResolve(false);
        PsiFile psiFile = element.getContainingFile();
        VirtualFile vFile = psiFile != null ? psiFile.getVirtualFile() : null;
        for (ResolveResult result2 : results) {
            ValueResourceInfo info;
            PsiElement target = result2.getElement();
            if (element.getManager().areElementsEquivalent(target, element)) {
                return true;
            }
            if (!(target instanceof LazyValueResourceElementWrapper) || vFile == null || !(info = ((LazyValueResourceElementWrapper)target).getResourceInfo()).getContainingFile().equals(vFile)) continue;
            XmlAttributeValue realTarget = info.computeXmlElement();
            if (!element.getManager().areElementsEquivalent((PsiElement)realTarget, element)) continue;
            return true;
        }
        return false;
    }
}

