/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlagConverter
extends DelimitedListConverter<String> {
    private final Set<String> myValues = new HashSet<String>();
    private final ResolvingConverter<String> additionalConverter;

    public FlagConverter(@Nullable ResolvingConverter<String> additionalConverter, String ... values) {
        super("|");
        this.additionalConverter = additionalConverter;
        Collections.addAll(this.myValues, values);
    }

    @NotNull
    public Collection<? extends List<String>> getVariants(ConvertContext context) {
        if (this.additionalConverter == null) {
            return super.getVariants(context);
        }
        Collection variants = this.additionalConverter.getVariants(context);
        ArrayList<List<String>> result2 = new ArrayList<List<String>>();
        for (String variant : variants) {
            result2.add(Arrays.asList(variant));
        }
        return result2;
    }

    protected String convertString(@Nullable String s, ConvertContext context) {
        if (s == null || this.myValues.contains(s)) {
            return s;
        }
        return this.additionalConverter != null ? (String)this.additionalConverter.fromString(s, context) : null;
    }

    protected String toString(@Nullable String s) {
        return s;
    }

    protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<? extends List<String>> value2) {
        ArrayList<String> variants = new ArrayList<String>(this.myValues);
        FlagConverter.filterVariants(variants, value2);
        return ArrayUtil.toStringArray(variants);
    }

    protected PsiElement resolveReference(@Nullable String s, ConvertContext context) {
        return s == null ? null : context.getReferenceXmlElement();
    }

    protected String getUnresolvedMessage(String value2) {
        return MessageFormat.format(AndroidBundle.message("cannot.resolve.flag.error", new Object[0]), value2);
    }

    @NotNull
    public Set<String> getValues() {
        return this.myValues;
    }
}

