/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.model.MergedManifestManager;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.FilteredQuery;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.android.dom.converters.CreateMissingClassQuickFix;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageClassConverter
extends Converter<PsiClass>
implements CustomReferenceConverter<PsiClass> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.dom.converters.PackageClassConverter");
    private final boolean myUseManifestBasePackage;
    private final String[] myExtendClassesNames;
    private final String[] myExtraBasePackages;
    private final boolean myCompleteLibraryClasses;

    protected PackageClassConverter(boolean useManifestBasePackage, String[] extraBasePackages, boolean completeLibraryClasses, String[] extendClassesNames) {
        this.myUseManifestBasePackage = useManifestBasePackage;
        this.myExtraBasePackages = extraBasePackages;
        this.myCompleteLibraryClasses = completeLibraryClasses;
        this.myExtendClassesNames = extendClassesNames;
    }

    public PackageClassConverter(String ... extendClassesNames) {
        this(false, ArrayUtil.EMPTY_STRING_ARRAY, false, extendClassesNames);
    }

    public PackageClassConverter() {
        this(false, ArrayUtil.EMPTY_STRING_ARRAY, false, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    @Nullable
    private String getManifestPackage(@NotNull ConvertContext context) {
        Module module;
        String manifestPackage;
        DomElement domElement = context.getInvocationElement();
        Manifest manifest = (Manifest)domElement.getParentOfType(Manifest.class, true);
        String string = manifestPackage = manifest != null ? (String)manifest.getPackage().getValue() : null;
        if (manifestPackage == null && this.myUseManifestBasePackage && (module = context.getModule()) != null) {
            manifestPackage = MergedManifestManager.getSnapshot(module).getPackage();
        }
        return manifestPackage;
    }

    @Nullable
    public PsiClass fromString(@Nullable @NonNls String nameValue, @NotNull ConvertContext context) {
        String manifestPackage = this.getManifestPackage(context);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getPsiManager().getProject());
        Module module = context.getModule();
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : context.getInvocationElement().getResolveScope();
        return PackageClassConverter.findClassFromString(nameValue, facade, scope, manifestPackage, this.myExtraBasePackages);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static PsiClass findClassFromString(@Nullable String s, @NotNull JavaPsiFacade facade, @NotNull GlobalSearchScope scope, @Nullable String manifestPackage, @NotNull String[] extraBasePackages) {
        if (s == null) {
            return null;
        }
        s = s.replace('$', '.');
        ArrayList<String> prefixes = new ArrayList<String>();
        if (s.startsWith(".")) {
            if (manifestPackage == null) return null;
            prefixes.add(manifestPackage);
        } else {
            if (extraBasePackages.length > 0) {
                prefixes.addAll(Arrays.asList(extraBasePackages));
            }
            if (manifestPackage != null) {
                prefixes.add(manifestPackage + ".");
            }
            prefixes.add("");
        }
        String className = s;
        return prefixes.stream().map(prefix -> facade.findClass(prefix + className, scope)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static PsiPackage findPackageFromString(@Nullable String s, @NotNull JavaPsiFacade facade, @Nullable String manifestPackage) {
        if (s == null) {
            return null;
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        if (s.startsWith(".")) {
            if (manifestPackage == null) return null;
            prefixes.add(manifestPackage);
            return prefixes.stream().map(prefix -> facade.findPackage(prefix + s)).filter(Objects::nonNull).findFirst().orElse(null);
        } else {
            if (manifestPackage != null) {
                prefixes.add(manifestPackage + ".");
            }
            prefixes.add("");
        }
        return prefixes.stream().map(prefix -> facade.findPackage(prefix + s)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiClass> value2, final PsiElement element, ConvertContext context) {
        boolean isTestFile;
        assert (element instanceof XmlAttributeValue);
        XmlAttributeValue attrValue = (XmlAttributeValue)element;
        String strValue = StringUtil.notNullize((String)attrValue.getValue());
        final boolean startsWithPoint = strValue.startsWith(".");
        final int start = attrValue.getValueTextRange().getStartOffset() - attrValue.getTextRange().getStartOffset();
        DomElement domElement = context.getInvocationElement();
        final String manifestPackage = this.getManifestPackage(context);
        final String[] extendClassesNames = this.getClassNames(domElement);
        final boolean completeLibraryClasses = this.getCompleteLibraryClasses(domElement);
        AndroidFacet facet = AndroidFacet.getInstance(context);
        VirtualFile file = element.getContainingFile().getVirtualFile();
        boolean bl = isTestFile = facet != null && file != null && IdeaSourceProvider.isTestFile(facet, file);
        if (strValue.isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        final ArrayList result2 = new ArrayList();
        final Module module = context.getModule();
        class CustomConsumer
        implements Consumer<Integer> {
            int myPartStart = 0;
            private boolean myIsPackage = true;

            CustomConsumer() {
            }

            public void consume(Integer index) {
                if (index > this.myPartStart) {
                    TextRange range = new TextRange(start + this.myPartStart, start + index);
                    MyReference reference2 = new MyReference(element, range, manifestPackage, PackageClassConverter.this.myExtraBasePackages, startsWithPoint, start, this.myIsPackage, module, extendClassesNames, completeLibraryClasses, isTestFile);
                    result2.add(reference2);
                }
                this.myPartStart = index + 1;
            }
        }
        CustomConsumer consumer = new CustomConsumer();
        AndroidTextUtils.forEachOccurrence((String)strValue, (char)'.', (Consumer)consumer);
        consumer.myIsPackage = false;
        AndroidTextUtils.forEachOccurrence((String)strValue, (char)'$', (int)consumer.myPartStart, (Consumer)consumer);
        consumer.consume(strValue.length());
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    public boolean getCompleteLibraryClasses(@NotNull DomElement domElement) {
        Options options = (Options)domElement.getAnnotation(Options.class);
        return options != null ? options.completeLibraryClasses() : this.myCompleteLibraryClasses;
    }

    @NotNull
    private String[] getClassNames(@NotNull DomElement domElement) {
        Options options = (Options)domElement.getAnnotation(Options.class);
        return options != null ? options.inheriting() : this.myExtendClassesNames;
    }

    @Nullable
    public static String getQualifiedName(@NotNull PsiClass aClass) {
        PsiElement parent = aClass.getParent();
        if (parent instanceof PsiClass) {
            String parentQName = PackageClassConverter.getQualifiedName((PsiClass)parent);
            if (parentQName == null) {
                return null;
            }
            return parentQName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    @Nullable
    private static String getName(@NotNull PsiClass aClass) {
        PsiElement parent = aClass.getParent();
        if (parent instanceof PsiClass) {
            String parentName = PackageClassConverter.getName((PsiClass)parent);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass.getName();
        }
        return aClass.getName();
    }

    @Nullable
    public String toString(@Nullable PsiClass psiClass, ConvertContext context) {
        DomElement domElement = context.getInvocationElement();
        Manifest manifest = (Manifest)domElement.getParentOfType(Manifest.class, true);
        String packageName = manifest == null ? null : (String)manifest.getPackage().getValue();
        return PackageClassConverter.classToString(psiClass, packageName, "");
    }

    @Nullable
    public static String getPackageName(@NotNull PsiClass psiClass) {
        return JavaHierarchyUtil.getPackageName((PsiClass)psiClass);
    }

    @Nullable
    private static String classToString(PsiClass psiClass, String basePackageName, String prefix) {
        if (psiClass == null) {
            return null;
        }
        String qName = PackageClassConverter.getQualifiedName(psiClass);
        if (qName == null) {
            return null;
        }
        PsiFile file = psiClass.getContainingFile();
        if (file instanceof PsiClassOwner) {
            String name;
            PsiClassOwner psiFile = (PsiClassOwner)file;
            if (Comparing.equal((String)psiFile.getPackageName(), (String)basePackageName)) {
                String name2 = PackageClassConverter.getName(psiClass);
                if (name2 != null) {
                    String dottedName = '.' + name2;
                    if (dottedName.startsWith(prefix)) {
                        return dottedName;
                    }
                    if (name2.startsWith(prefix)) {
                        return name2;
                    }
                }
            } else if (basePackageName != null && qName.startsWith(basePackageName + ".") && (name = qName.substring(basePackageName.length())).startsWith(prefix)) {
                return name;
            }
        }
        return qName;
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        private final int myStart;
        private final String myManifestPackage;
        private final String[] myExtraBasePackages;
        private final boolean myStartsWithPoint;
        private final boolean myIsPackage;
        @Nullable
        private final Module myModule;
        private final String[] myExtendsClasses;
        private final boolean myCompleteLibraryClasses;
        private final boolean myIncludeTests;

        private MyReference(PsiElement element, TextRange range, String manifestPackage, String[] extraBasePackages, boolean startsWithPoint, int start, boolean isPackage, @Nullable Module module, String[] extendsClasses, boolean completeLibraryClasses, boolean includeTests) {
            super(element, range, true);
            this.myManifestPackage = manifestPackage;
            this.myExtraBasePackages = extraBasePackages;
            this.myStartsWithPoint = startsWithPoint;
            this.myStart = start;
            this.myIsPackage = isPackage;
            this.myModule = module;
            this.myExtendsClasses = extendsClasses;
            this.myCompleteLibraryClasses = completeLibraryClasses;
            this.myIncludeTests = includeTests;
        }

        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)((ResolveCache.Resolver)(reference2, incompleteCode) -> this.resolveInner()), false, false);
        }

        @Nullable
        private PsiElement resolveInner() {
            String value2 = this.getCurrentValue();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myElement.getProject());
            GlobalSearchScope scope = this.myModule != null ? this.myModule.getModuleWithDependenciesAndLibrariesScope(this.myIncludeTests) : this.myElement.getResolveScope();
            return this.myIsPackage ? PackageClassConverter.findPackageFromString(value2, facade, this.myManifestPackage) : PackageClassConverter.findClassFromString(value2, facade, scope, this.myManifestPackage, this.myExtraBasePackages);
        }

        @NotNull
        private String getCurrentValue() {
            int end = this.getRangeInElement().getEndOffset();
            return this.myElement.getText().substring(this.myStart, end).replace('$', '.');
        }

        @Nullable
        private String getAbsoluteName(String value2) {
            if (this.myManifestPackage == null) {
                return null;
            }
            return this.myManifestPackage + (this.myStartsWithPoint ? "" : ".") + value2;
        }

        @NotNull
        public Object[] getVariants() {
            if (this.myExtendsClasses != null) {
                ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
                for (String extendsClass : this.myExtendsClasses) {
                    classes.addAll(this.findInheritors(extendsClass));
                }
                ArrayList<LookupElementBuilder> result2 = new ArrayList<LookupElementBuilder>(classes.size());
                int n = classes.size();
                for (int i2 = 0; i2 < n; ++i2) {
                    String prefix;
                    PsiClass psiClass = (PsiClass)classes.get(i2);
                    String name = PackageClassConverter.classToString(psiClass, this.myManifestPackage, prefix = this.myElement.getText().substring(this.myStart, this.getRangeInElement().getStartOffset()));
                    if (name == null || !name.startsWith(prefix)) continue;
                    name = name.substring(prefix.length());
                    result2.add(JavaLookupElementBuilder.forClass((PsiClass)psiClass, (String)name, (boolean)true));
                }
                return ArrayUtil.toObjectArray(result2);
            }
            return EMPTY_ARRAY;
        }

        @NotNull
        private Collection<PsiClass> findInheritors(@NotNull String className) {
            Project project = this.myElement.getProject();
            PsiClass base = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
            if (base == null) {
                return new ArrayList<PsiClass>();
            }
            GlobalSearchScope scope = this.myModule == null ? GlobalSearchScope.allScope((Project)project) : (this.myCompleteLibraryClasses ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule, (boolean)false) : GlobalSearchScope.moduleWithDependenciesScope((Module)this.myModule));
            FilteredQuery query = new FilteredQuery(ClassInheritorsSearch.search((PsiClass)base, (SearchScope)scope, (boolean)true), psiClass -> psiClass.hasModifier(JvmModifier.PUBLIC));
            return query.findAll();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element instanceof PsiClass || element instanceof PsiPackage) {
                String newName2;
                if (this.myIsPackage && this.myManifestPackage != null && AndroidUtils.isPackagePrefix(this.getCurrentValue(), this.myManifestPackage)) {
                    return super.bindToElement(element);
                }
                if (element instanceof PsiClass) {
                    newName2 = PackageClassConverter.classToString((PsiClass)element, this.myManifestPackage, "");
                    if (this.myManifestPackage != null && AndroidUtils.isPackagePrefix(this.myManifestPackage, this.getCurrentValue()) && newName2 != null && !newName2.startsWith(this.myManifestPackage)) {
                        newName2 = this.myManifestPackage + (newName2.startsWith(".") ? "" : ".") + newName2;
                    }
                } else {
                    newName2 = MyReference.packageToString((PsiPackage)element, this.myManifestPackage, this.resolve() != null);
                }
                assert (newName2 != null);
                ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
                TextRange range = new TextRange(this.myStart, this.getRangeInElement().getEndOffset());
                if (manipulator != null) {
                    return manipulator.handleContentChange(this.myElement, range, newName2);
                }
                return element;
            }
            LOG.error("PackageClassConverter resolved to " + element.getClass());
            return super.bindToElement(element);
        }

        private static String packageToString(PsiPackage psiPackage, String basePackageName, boolean isFullQualified) {
            String qName = psiPackage.getQualifiedName();
            return basePackageName != null && AndroidUtils.isPackagePrefix(basePackageName, qName) && !isFullQualified ? qName.substring(basePackageName.length()) : qName;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            return this.myIsPackage ? "Unresolved package ''{0}''" : "Unresolved class ''{0}''";
        }

        @NotNull
        public LocalQuickFix[] getQuickFixes() {
            if (this.myIsPackage || this.myModule == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            String value2 = this.getCurrentValue();
            if (this.myStartsWithPoint && this.myManifestPackage != null) {
                value2 = this.getAbsoluteName(value2);
            }
            if (value2 == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            int dot = value2.lastIndexOf(46);
            if (dot == -1) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myModule.getProject()).findPackage(value2.substring(0, dot));
            if (aPackage == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            String baseClassFqcn = this.myExtendsClasses.length == 0 ? null : this.myExtendsClasses[0];
            return new LocalQuickFix[]{new CreateMissingClassQuickFix(aPackage, value2.substring(dot + 1), this.myModule, baseClassFqcn)};
        }
    }

    public static class Builder {
        private boolean myUseManifestBasePackage;
        private String[] myExtendClassesNames = ArrayUtil.EMPTY_STRING_ARRAY;
        private String[] myExtraBasePackages = ArrayUtil.EMPTY_STRING_ARRAY;
        private boolean myCompleteLibraryClasses;

        public Builder useManifestBasePackage(boolean doUseManifestBasePackage) {
            this.myUseManifestBasePackage = doUseManifestBasePackage;
            return this;
        }

        public Builder completeLibraryClasses(boolean doCompleteLibraryClasses) {
            this.myCompleteLibraryClasses = doCompleteLibraryClasses;
            return this;
        }

        public Builder withExtendClassNames(String ... classNames) {
            this.myExtendClassesNames = (String[])Stream.of(classNames).map(jvmName -> jvmName.replace('$', '.')).toArray(String[]::new);
            return this;
        }

        public Builder withExtraBasePackages(String ... basePackages) {
            this.myExtraBasePackages = basePackages;
            return this;
        }

        public PackageClassConverter build() {
            return new PackageClassConverter(this.myUseManifestBasePackage, this.myExtraBasePackages, this.myCompleteLibraryClasses, this.myExtendClassesNames);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Options {
        @Nullable
        public String[] inheriting();

        public boolean completeLibraryClasses() default false;
    }
}

