/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceNamespaceContext;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.AdditionalConverter;
import org.jetbrains.android.dom.AndroidResourceType;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.dom.converters.AttributeValueDocumentationProvider;
import org.jetbrains.android.dom.converters.ResourceNamespaceReference;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateFileResourceQuickFix;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceReferenceConverter
extends ResolvingConverter<ResourceValue>
implements CustomReferenceConverter<ResourceValue>,
AttributeValueDocumentationProvider {
    private static final Pattern NAMESPACE_COLON = Pattern.compile("^((?:\\w|\\.)+):.*");
    private static final Pattern PREFIX_NAMESPACE_COLON = Pattern.compile("^@((?:\\w|\\.)+):.*");
    private static final ImmutableSet<String> TOP_PRIORITY_VALUES = ImmutableSet.of((Object)"match_parent", (Object)"wrap_content");
    private final Set<ResourceType> myResourceTypes;
    private ResolvingConverter<String> myAdditionalConverter;
    private boolean myAdditionalConverterSoft = false;
    private boolean myWithPrefix = true;
    private boolean myWithExplicitResourceType = true;
    private boolean myQuiet = false;
    private boolean myAllowAttributeReferences = true;
    private boolean myExpandedCompletionSuggestion = true;
    private boolean myAllowLiterals = true;
    @Nullable
    private AttributeDefinition myAttributeDefinition = null;

    public ResourceReferenceConverter() {
        this(EnumSet.noneOf(ResourceType.class));
    }

    public ResourceReferenceConverter(@NotNull Collection<ResourceType> resourceTypes) {
        this.myResourceTypes = EnumSet.copyOf(resourceTypes);
    }

    public ResourceReferenceConverter(@NotNull Collection<ResourceType> resourceTypes, @Nullable AttributeDefinition attributeDefinition) {
        this.myResourceTypes = EnumSet.copyOf(resourceTypes);
        this.myAttributeDefinition = attributeDefinition;
    }

    public void setAllowLiterals(boolean allowLiterals) {
        this.myAllowLiterals = allowLiterals;
    }

    public ResourceReferenceConverter(@NotNull ResourceType resourceType, boolean withPrefix, boolean withExplicitResourceType) {
        this.myResourceTypes = EnumSet.of(resourceType);
        this.myWithPrefix = withPrefix;
        this.myWithExplicitResourceType = withExplicitResourceType;
    }

    public void setAdditionalConverter(@Nullable ResolvingConverter<String> additionalConverter, boolean soft) {
        this.myAdditionalConverter = additionalConverter;
        this.myAdditionalConverterSoft = soft;
    }

    public void setQuiet(boolean quiet) {
        this.myQuiet = quiet;
    }

    public void setExpandedCompletionSuggestion(boolean expandedCompletionSuggestion) {
        this.myExpandedCompletionSuggestion = expandedCompletionSuggestion;
    }

    public void setAllowAttributeReferences(boolean allowAttributeReferences) {
        this.myAllowAttributeReferences = allowAttributeReferences;
    }

    @Nullable
    static String getValue(XmlElement element) {
        if (element instanceof XmlAttribute) {
            return ((XmlAttribute)element).getValue();
        }
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getValue().getText();
        }
        return null;
    }

    @NotNull
    public Collection<? extends ResourceValue> getVariants(ConvertContext context) {
        ResolvingConverter<String> additionalConverter;
        XmlElement element;
        Module module = context.getModule();
        if (module == null || module.isDisposed()) {
            return Collections.emptySet();
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return Collections.emptySet();
        }
        HashSet<ResourceValue> result2 = new HashSet<ResourceValue>();
        Set<ResourceType> recommendedTypes = this.getResourceTypes(context);
        if (recommendedTypes.contains(ResourceType.BOOL) && recommendedTypes.size() < AndroidResourceUtil.VALUE_RESOURCE_TYPES.size()) {
            result2.add(ResourceValue.literal("true"));
            result2.add(ResourceValue.literal("false"));
        }
        if (recommendedTypes.contains(ResourceType.ID) && recommendedTypes.size() == 1) {
            result2.add(ResourceValue.reference("@+id/"));
        }
        if ((element = context.getXmlElement()) == null) {
            return result2;
        }
        String value2 = ResourceReferenceConverter.getValue(element);
        assert (value2 != null);
        boolean startsWithRefChar = StringUtil.startsWithChar((CharSequence)value2, (char)'@');
        if (!this.myQuiet || startsWithRefChar) {
            char prefix;
            ResourceNamespace namespace = null;
            String namespacePrefix = null;
            Matcher matcher = (this.myWithPrefix ? PREFIX_NAMESPACE_COLON : NAMESPACE_COLON).matcher(value2);
            if (matcher.matches()) {
                ResourceNamespaceContext namespacesContext = ResourceHelper.getNamespacesContext(element);
                namespacePrefix = matcher.group(1);
                namespace = namespacesContext != null ? ResourceNamespace.fromNamespacePrefix((String)namespacePrefix, (ResourceNamespace)namespacesContext.getCurrentNs(), (ResourceNamespace.Resolver)namespacesContext.getResolver()) : ResourceNamespace.fromPackageName((String)namespacePrefix);
            } else if (((Boolean)StudioFlags.COLLAPSE_ANDROID_NAMESPACE.get()).booleanValue()) {
                ResourceNamespace.Resolver resolver = ResourceHelper.getNamespaceResolver(element);
                String frameworkPrefix = (String)MoreObjects.firstNonNull((Object)resolver.uriToPrefix(ResourceNamespace.ANDROID.getXmlNamespaceUri()), (Object)ResourceNamespace.ANDROID.getPackageName());
                result2.add(ResourceValue.literal(this.myWithPrefix || startsWithRefChar ? '@' + frameworkPrefix + ':' : frameworkPrefix + ':'));
            }
            char c = prefix = this.myWithPrefix || startsWithRefChar ? (char)'@' : '\u0000';
            if (value2.startsWith("@+id/")) {
                this.addVariantsForIdDeclaration(context, facet, prefix, value2, result2);
            }
            if (this.myExpandedCompletionSuggestion) {
                boolean explicitResourceType = startsWithRefChar || this.myWithExplicitResourceType;
                for (ResourceType type : recommendedTypes) {
                    if (!type.getCanBeReferenced() && type != ResourceType.SAMPLE_DATA) continue;
                    ResourceReferenceConverter.addResourceReferenceValues(facet, element, prefix, type, namespace, result2, explicitResourceType);
                }
            } else {
                Set<ResourceType> filteringSet = namespace == ResourceNamespace.ANDROID ? EnumSet.allOf(ResourceType.class) : ResourceReferenceConverter.getResourceTypesInCurrentModule(facet);
                for (ResourceType resourceType : ResourceType.values()) {
                    if (!resourceType.getCanBeReferenced()) continue;
                    String typePrefix = this.getTypePrefix(namespacePrefix, resourceType);
                    if (value2.startsWith(typePrefix)) {
                        ResourceReferenceConverter.addResourceReferenceValues(facet, element, prefix, resourceType, namespace, result2, true);
                        continue;
                    }
                    if (!recommendedTypes.contains(resourceType) || !filteringSet.contains(resourceType)) continue;
                    result2.add(ResourceValue.literal(typePrefix));
                }
            }
        }
        if (this.myAllowAttributeReferences) {
            ResourceReferenceConverter.completeAttributeReferences(value2, facet, result2);
        }
        if ((additionalConverter = this.getAdditionalConverter(context)) != null) {
            for (String variant : additionalConverter.getVariants(context)) {
                result2.add(ResourceValue.literal(variant));
            }
        }
        return result2;
    }

    private void addVariantsForIdDeclaration(@NotNull ConvertContext context, @NotNull AndroidFacet facet, final char prefix, final @NotNull String value2, final @NotNull Set<ResourceValue> result2) {
        final ResourceNamespace namespace = ResourceNamespace.TODO();
        XmlFile file = context.getFile();
        file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                String valueText = attributeValue.getValue();
                if (valueText != null && valueText.startsWith("@id/") && valueText.length() > "@id/".length()) {
                    String name = valueText.substring("@id/".length());
                    ResourceValue ref = ResourceReferenceConverter.referenceTo(prefix, "+id", namespace.getPackageName(), name, true);
                    if (!value2.startsWith(ResourceReferenceConverter.this.doToString(ref))) {
                        result2.add(ref);
                    }
                }
            }
        });
        Set ids = ResourceRepositoryManager.getAppResources(facet).getResources(namespace, ResourceType.ID).keySet();
        for (String name : ids) {
            ResourceValue ref = ResourceReferenceConverter.referenceTo(prefix, "+id", namespace.getPackageName(), name, true);
            if (value2.startsWith(this.doToString(ref))) continue;
            result2.add(ref);
        }
    }

    private static void completeAttributeReferences(String value2, AndroidFacet facet, Set<ResourceValue> result2) {
        if (StringUtil.startsWith((CharSequence)value2, (CharSequence)"?attr/")) {
            ResourceReferenceConverter.addResourceReferenceValues(facet, null, '?', ResourceType.ATTR, null, result2, true);
        } else if (StringUtil.startsWith((CharSequence)value2, (CharSequence)"?android:attr/")) {
            ResourceReferenceConverter.addResourceReferenceValues(facet, null, '?', ResourceType.ATTR, ResourceNamespace.ANDROID, result2, true);
        } else if (StringUtil.startsWithChar((CharSequence)value2, (char)'?')) {
            ResourceReferenceConverter.addResourceReferenceValues(facet, null, '?', ResourceType.ATTR, null, result2, false);
            ResourceReferenceConverter.addResourceReferenceValues(facet, null, '?', ResourceType.ATTR, ResourceNamespace.ANDROID, result2, false);
            result2.add(ResourceValue.literal("?attr/"));
            result2.add(ResourceValue.literal("?android:attr/"));
        }
    }

    @NotNull
    public static Set<ResourceType> getResourceTypesInCurrentModule(@NotNull AndroidFacet facet) {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(facet);
        LocalResourceRepository repository = repositoryManager.getAppResources();
        return repository.getResourceTypes(repositoryManager.getNamespace());
    }

    @NotNull
    private String getTypePrefix(@Nullable String namespacePrefix, @NotNull ResourceType type) {
        StringBuilder sb = new StringBuilder();
        if (this.myWithPrefix) {
            sb.append('@');
        }
        if (namespacePrefix != null) {
            sb.append(namespacePrefix).append(':');
        }
        sb.append(type.getName()).append('/');
        return sb.toString();
    }

    @NotNull
    private Set<ResourceType> getResourceTypes(ConvertContext context) {
        return this.getResourceTypes(context.getInvocationElement());
    }

    @NotNull
    public Set<ResourceType> getResourceTypes(@NotNull DomElement element) {
        String s;
        ResourceType t;
        AndroidResourceType resourceType = (AndroidResourceType)element.getAnnotation(AndroidResourceType.class);
        EnumSet<ResourceType> types = EnumSet.copyOf(this.myResourceTypes);
        if (resourceType != null && (t = ResourceType.fromClassName((String)(s = resourceType.value()))) != null) {
            types.add(t);
        }
        if (types.isEmpty()) {
            return AndroidResourceUtil.VALUE_RESOURCE_TYPES;
        }
        if (types.contains(ResourceType.DRAWABLE)) {
            types.add(ResourceType.COLOR);
        }
        if ("http://schemas.android.com/tools".equals(element.getXmlElementNamespace())) {
            types.add(ResourceType.SAMPLE_DATA);
        }
        return types;
    }

    private static void addResourceReferenceValues(AndroidFacet facet, @Nullable XmlElement element, char prefix, ResourceType type, @Nullable ResourceNamespace onlyNamespace, Collection<ResourceValue> result2, boolean explicitResourceType) {
        PsiFile file;
        PsiFile psiFile = file = element != null ? element.getContainingFile() : null;
        if (type == ResourceType.ID && onlyNamespace != ResourceNamespace.ANDROID && file != null && ResourceReferenceConverter.isNonValuesResourceFile(file)) {
            for (String id : ResourceHelper.findIdsInFile(file)) {
                result2.add(ResourceReferenceConverter.referenceTo(prefix, type.getName(), null, id, explicitResourceType));
            }
        } else {
            ResourceRepository frameworkResources;
            ResourceRepositoryManager repoManager = ResourceRepositoryManager.getInstance(facet);
            LocalResourceRepository appResources = repoManager.getAppResources();
            ResourceVisibilityLookup visibilityLookup = repoManager.getResourceVisibility();
            if ((onlyNamespace == ResourceNamespace.ANDROID || onlyNamespace == null && !((Boolean)StudioFlags.COLLAPSE_ANDROID_NAMESPACE.get()).booleanValue()) && (frameworkResources = repoManager.getFrameworkResources(false)) != null) {
                ResourceReferenceConverter.addResourceReferenceValuesFromRepo(frameworkResources, repoManager, visibilityLookup, element, prefix, type, ResourceNamespace.ANDROID, result2, explicitResourceType);
            }
            if (onlyNamespace == null) {
                for (ResourceNamespace namespace : appResources.getNamespaces()) {
                    ResourceReferenceConverter.addResourceReferenceValuesFromRepo((ResourceRepository)appResources, repoManager, visibilityLookup, element, prefix, type, namespace, result2, explicitResourceType);
                }
            } else {
                ResourceReferenceConverter.addResourceReferenceValuesFromRepo((ResourceRepository)appResources, repoManager, visibilityLookup, element, prefix, type, onlyNamespace, result2, explicitResourceType);
            }
        }
    }

    private static void addResourceReferenceValuesFromRepo(ResourceRepository repo, ResourceRepositoryManager repoManager, ResourceVisibilityLookup visibilityLookup, @Nullable XmlElement element, char prefix, ResourceType type, @NotNull ResourceNamespace onlyNamespace, Collection<ResourceValue> result2, boolean explicitResourceType) {
        Collection<String> names = ResourceHelper.getResourceItems(repo, onlyNamespace, type, visibilityLookup, ResourceVisibility.PUBLIC);
        ResourceNamespace.Resolver resolver = ResourceNamespace.Resolver.EMPTY_RESOLVER;
        if (element != null) {
            resolver = (ResourceNamespace.Resolver)MoreObjects.firstNonNull((Object)ResourceHelper.getNamespaceResolver(element), (Object)resolver);
        }
        String namespacePrefix = new ResourceReference((ResourceNamespace)onlyNamespace, (ResourceType)ResourceType.STRING, (String)"dummy").getRelativeResourceUrl((ResourceNamespace)repoManager.getNamespace(), (ResourceNamespace.Resolver)resolver).namespace;
        for (String name : names) {
            result2.add(ResourceReferenceConverter.referenceTo(prefix, type.getName(), namespacePrefix, name, explicitResourceType));
        }
    }

    private static boolean isNonValuesResourceFile(@NotNull PsiFile file) {
        ResourceFolderType resourceType = ResourceHelper.getFolderType(file.getOriginalFile());
        return resourceType != null && resourceType != ResourceFolderType.VALUES;
    }

    private static ResourceValue referenceTo(char prefix, String type, String resPackage, String name, boolean explicitResourceType) {
        return ResourceValue.referenceTo(prefix, resPackage, explicitResourceType ? type : null, name);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        if (s == null || s.isEmpty()) {
            return "Missing value";
        }
        ResourceValue parsed = ResourceValue.parse(s, true, this.myWithPrefix, false);
        if (parsed == null || !parsed.isReference()) {
            ResolvingConverter<String> additionalConverter = this.getAdditionalConverter(context);
            if (this.myResourceTypes.contains(ResourceType.STRING)) {
                return null;
            }
            if (additionalConverter != null) {
                return additionalConverter.getErrorMessage(s, context);
            }
        } else {
            String errorMessage = parsed.getErrorMessage();
            if (errorMessage != null) {
                return errorMessage;
            }
        }
        return super.getErrorMessage(s, context);
    }

    @Nullable
    public LookupElement createLookupElement(ResourceValue resourceValue2) {
        String value2 = resourceValue2.toString();
        boolean deprecated = false;
        String doc = null;
        if (this.myAttributeDefinition != null) {
            doc = this.myAttributeDefinition.getValueDescription(value2);
            deprecated = this.myAttributeDefinition.isValueDeprecated(value2);
        }
        LookupElementBuilder builder = doc == null ? LookupElementBuilder.create((String)value2) : LookupElementBuilder.create((Object)new DocumentationHolder(value2, doc.trim()), (String)value2);
        builder = builder.withCaseSensitivity(true).withStrikeoutness(deprecated);
        String resourceName = resourceValue2.getResourceName();
        if (resourceName != null) {
            builder = builder.withLookupString(resourceName);
        } else if (this.isNamespaceLiteral(resourceValue2.getValue())) {
            builder = builder.withInsertHandler((context, item) -> context.setLaterRunnable(() -> new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(context.getProject(), context.getEditor())));
        }
        int priority = deprecated ? 0 : (TOP_PRIORITY_VALUES.contains((Object)value2) ? 2 : 1);
        return PrioritizedLookupElement.withPriority((LookupElement)builder, (double)priority);
    }

    public boolean isNamespaceLiteral(@Nullable String value2) {
        return value2 != null && value2.charAt(value2.length() - 1) == ':' && value2.indexOf(47) == -1;
    }

    public ResourceValue fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        if (DataBindingUtil.isBindingExpression(s)) {
            return ResourceValue.INVALID;
        }
        ResourceValue parsed = ResourceValue.parse(s, true, this.myWithPrefix, true);
        ResolvingConverter<String> additionalConverter = this.getAdditionalConverter(context);
        if (parsed == null || !parsed.isReference()) {
            if (additionalConverter != null) {
                String value2 = (String)additionalConverter.fromString(s, context);
                if (value2 != null) {
                    return ResourceValue.literal(value2);
                }
                if (!this.myAdditionalConverterSoft) {
                    return null;
                }
            } else if (!this.myAllowLiterals) {
                return null;
            }
        }
        if (parsed != null) {
            String resType = parsed.getResourceType();
            if (parsed.getPrefix() == '?') {
                if (!this.myAllowAttributeReferences) {
                    return null;
                }
                if (resType == null) {
                    parsed.setResourceType(ResourceType.ATTR.getName());
                } else if (!ResourceType.ATTR.getName().equals(resType)) {
                    return null;
                }
            } else if (resType == null) {
                if (parsed.isReference()) {
                    if (this.myWithExplicitResourceType && !"@null".equals(s)) {
                        return null;
                    }
                    if (this.myResourceTypes.size() == 1) {
                        parsed.setResourceType(this.myResourceTypes.iterator().next().getName());
                    }
                } else {
                    Set<ResourceType> types = this.getResourceTypes(context);
                    if (types.contains(ResourceType.BOOL) && types.size() < AndroidResourceUtil.VALUE_RESOURCE_TYPES.size() && !"true".equals(s) && !"false".equals(s)) {
                        return null;
                    }
                }
            }
        }
        return parsed;
    }

    @Nullable
    private ResolvingConverter<String> getAdditionalConverter(ConvertContext context) {
        if (this.myAdditionalConverter != null) {
            return this.myAdditionalConverter;
        }
        AdditionalConverter additionalConverterAnnotation = (AdditionalConverter)context.getInvocationElement().getAnnotation(AdditionalConverter.class);
        if (additionalConverterAnnotation != null) {
            Class<? extends ResolvingConverter> converterClass = additionalConverterAnnotation.value();
            ConverterManager converterManager = (ConverterManager)ServiceManager.getService(ConverterManager.class);
            return (ResolvingConverter)converterManager.getConverterInstance(converterClass);
        }
        return null;
    }

    public String toString(@Nullable ResourceValue element, ConvertContext context) {
        return this.doToString(element);
    }

    private String doToString(ResourceValue element) {
        if (element == null) {
            return null;
        }
        if (this.myWithExplicitResourceType || !element.isReference()) {
            return element.toString();
        }
        return ResourceValue.referenceTo(element.getPrefix(), element.getPackage(), null, element.getResourceName()).toString();
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        ResourceValue resourceValue2;
        String value2;
        DomElement domElement;
        AndroidFacet facet = AndroidFacet.getInstance(context);
        if (facet != null && (domElement = context.getInvocationElement()) instanceof GenericDomValue && (value2 = ((GenericDomValue)domElement).getStringValue()) != null && (resourceValue2 = ResourceValue.parse(value2, false, this.myWithPrefix, true)) != null) {
            String aPackage = resourceValue2.getPackage();
            ResourceType resType = resourceValue2.getType();
            if (resType == null && this.myResourceTypes.size() == 1) {
                resType = this.myResourceTypes.iterator().next();
            }
            String resourceName = resourceValue2.getResourceName();
            if (aPackage == null && resType != null && resourceName != null && AndroidResourceUtil.isCorrectAndroidResourceName(resourceName)) {
                ArrayList<Object> fixes = new ArrayList<Object>();
                ResourceFolderType folderType = FolderTypeRelationship.getNonValuesRelatedFolder((ResourceType)resType);
                if (folderType != null) {
                    fixes.add(new CreateFileResourceQuickFix(facet, folderType, resourceName, (PsiFile)context.getFile(), false));
                }
                if (AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(resType) && resType != ResourceType.LAYOUT) {
                    fixes.add(new CreateValueResourceQuickFix(facet, resType, resourceName, (PsiFile)context.getFile(), false));
                }
                return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
            }
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<ResourceValue> value2, PsiElement element, ConvertContext context) {
        XmlAttribute attribute;
        if ("@null".equals(value2.getStringValue())) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = context.getModule();
        if (module == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ResourceValue resValue = (ResourceValue)value2.getValue();
        if (resValue == null || !resValue.isReference()) {
            return PsiReference.EMPTY_ARRAY;
        }
        String resType = resValue.getResourceType();
        if (resType == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (resValue.getPackage() == null && "+id".equals(resType) && element != null && element.getParent() instanceof XmlAttribute && "id".equals((attribute = (XmlAttribute)element.getParent()).getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
            return PsiReference.EMPTY_ARRAY;
        }
        AndroidResourceReference resourceReference = new AndroidResourceReference(value2, facet, resValue);
        if (!StringUtil.isEmpty((String)resValue.getPackage())) {
            ResourceNamespaceReference namespaceReference = new ResourceNamespaceReference(value2, resValue);
            return new PsiReference[]{namespaceReference, resourceReference};
        }
        return new PsiReference[]{resourceReference};
    }

    @Override
    public String getDocumentation(@NotNull String value2) {
        return this.myAdditionalConverter instanceof AttributeValueDocumentationProvider ? ((AttributeValueDocumentationProvider)this.myAdditionalConverter).getDocumentation(value2) : null;
    }

    public static class DocumentationHolder {
        @NotNull
        private final String myValue;
        @NotNull
        private final String myDocumentation;

        public DocumentationHolder(@NotNull String value2, @NotNull String documentation) {
            this.myValue = value2;
            this.myDocumentation = documentation;
        }

        @NotNull
        public String getValue() {
            return this.myValue;
        }

        @NotNull
        public String getDocumentation() {
            return this.myDocumentation;
        }
    }
}

