/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.text.StringKt;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import kotlin.Metadata;
import kotlin.TypeCastException;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/android/dom/converters/StyleItemConverter;", "Lcom/intellij/util/xml/WrappingConverter;", "()V", "getConverter", "Lcom/intellij/util/xml/Converter;", "element", "Lcom/intellij/util/xml/GenericDomValue;", "intellij.android.core"})
public final class StyleItemConverter
extends WrappingConverter {
    @Nullable
    public Converter<?> getConverter(@NotNull GenericDomValue<?> element) {
        GenericDomValue<?> genericDomValue = element;
        if (genericDomValue == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.android.dom.resources.StyleItem");
        }
        GenericAttributeValue<String> attributeName = ((StyleItem)genericDomValue).getName();
        XmlAttribute xmlAttribute = attributeName.getXmlAttribute();
        if (xmlAttribute == null) {
            return null;
        }
        XmlAttribute psiElement = xmlAttribute;
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((DomElement)element);
        if (androidFacet == null) {
            return null;
        }
        AndroidFacet facet = androidFacet;
        String string = StringKt.nullize((String)attributeName.getStringValue(), (boolean)true);
        if (string == null) {
            return null;
        }
        String name = string;
        ResourceUrl resourceUrl = ResourceUrl.parseAttrReference((String)name);
        if (resourceUrl == null || (resourceUrl = ResourceHelper.resolve(resourceUrl, (XmlElement)psiElement)) == null) {
            return null;
        }
        ResourceUrl reference2 = resourceUrl;
        ResourceManager resourceManager = ModuleResourceManagers.getInstance(facet).getResourceManager(reference2.getNamespace().getPackageName());
        if (resourceManager == null) {
            return null;
        }
        ResourceManager resourceManager2 = resourceManager;
        Object object = resourceManager2.getAttributeDefinitions();
        if (object == null || (object = object.getAttrDefinition((ResourceReference)reference2)) == null) {
            return null;
        }
        Object attrDefinition = object;
        return (Converter)AndroidDomUtil.getConverter((AttributeDefinition)attrDefinition);
    }
}

