/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceNamespaceContext;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleItemNameConverter
extends ResolvingConverter<String> {
    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        AttributeDefinitions attrDefs;
        FrameworkResourceManager manager;
        XmlTag styleTag;
        ArrayList result2 = Lists.newArrayList();
        if (context.getModule() != null && context.getTag() != null && (styleTag = context.getTag().getParentTag()) != null) {
            result2.addAll(StyleItemNameConverter.getAttributesUsedByParentStyle(styleTag));
        }
        if ((manager = FrameworkResourceManager.getInstance(context)) != null && (attrDefs = ((ResourceManager)manager).getAttributeDefinitions()) != null) {
            for (ResourceReference attr : attrDefs.getAttrs()) {
                result2.add(attr.getQualifiedName());
            }
        }
        return result2;
    }

    @NotNull
    private static Collection<String> getAttributesUsedByParentStyle(@NotNull XmlTag styleTag) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)styleTag);
        if (module == null) {
            return Collections.emptyList();
        }
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(module);
        if (appResources == null) {
            return Collections.emptyList();
        }
        ResourceReference parentStyleReference = StyleItemNameConverter.getParentStyleFromTag(styleTag);
        if (parentStyleReference == null) {
            return Collections.emptyList();
        }
        List parentStyles = appResources.getResources(parentStyleReference);
        ResourceNamespaceContext namespacesContext = ResourceHelper.getNamespacesContext((XmlElement)styleTag);
        if (namespacesContext == null) {
            return Collections.emptyList();
        }
        ResourceNamespace namespace = namespacesContext.getCurrentNs();
        ResourceNamespace.Resolver resolver = namespacesContext.getResolver();
        HashSet<String> attributeNames = new HashSet<String>();
        ArrayDeque<Pair> toExplore = new ArrayDeque<Pair>();
        for (ResourceItem parentStyle : parentStyles) {
            toExplore.push(Pair.pair((Object)parentStyle, (Object)0));
        }
        while (!toExplore.isEmpty()) {
            ResourceItem parentItem;
            StyleResourceValue parentValue;
            Pair top = (Pair)toExplore.pop();
            int depth = (Integer)top.second;
            if (depth > 50 || (parentValue = (StyleResourceValue)(parentItem = (ResourceItem)top.first).getResourceValue()) == null || parentValue.isFramework()) continue;
            for (StyleItemResourceValue value2 : parentValue.getDefinedItems()) {
                ResourceReference attr;
                if (value2.isFramework() || (attr = value2.getAttr()) == null) continue;
                attributeNames.add(attr.getRelativeResourceUrl(namespace, resolver).getQualifiedName());
            }
            parentStyleReference = parentValue.getParentStyle();
            if (parentStyleReference == null) continue;
            for (ResourceItem parentStyle : appResources.getResources(parentStyleReference)) {
                toExplore.add(Pair.pair((Object)parentStyle, (Object)(depth + 1)));
            }
        }
        return attributeNames;
    }

    @Nullable
    private static ResourceReference getParentStyleFromTag(@NotNull XmlTag styleTag) {
        ResourceUrl parentUrl;
        String parentName = styleTag.getAttributeValue("parent");
        if (parentName == null) {
            String styleName = styleTag.getAttributeValue("name");
            if (styleName == null) {
                return null;
            }
            int lastDot = styleName.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            parentName = styleName.substring(0, lastDot);
        }
        if ((parentUrl = ResourceUrl.parseStyleParentReference((String)parentName)) == null) {
            return null;
        }
        return ResourceHelper.resolve(parentUrl, (XmlElement)styleTag);
    }

    public LookupElement createLookupElement(String s) {
        if (s == null) {
            return null;
        }
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)s), (double)(s.startsWith("android:") ? 0.0 : 1.0));
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        LocalResourceRepository repository;
        if (s == null) {
            return null;
        }
        XmlElement xmlElement = context.getXmlElement();
        if (xmlElement == null) {
            return null;
        }
        ResourceUrl attrUrl = ResourceUrl.parseAttrReference((String)s);
        if (attrUrl == null) {
            return null;
        }
        ResourceReference attributeReference = ResourceHelper.resolve(attrUrl, xmlElement);
        if (attributeReference == null) {
            return null;
        }
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(module);
        if (repositoryManager == null) {
            return null;
        }
        LocalResourceRepository localResourceRepository = repository = attributeReference.getNamespace() == ResourceNamespace.ANDROID ? repositoryManager.getFrameworkResources(false) : repositoryManager.getAppResources();
        if (repository == null) {
            return null;
        }
        return repository.getResources(attributeReference).isEmpty() ? null : s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }
}

