/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.drawable;

import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.drawable.fileDescriptions.AdaptiveIconDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidDrawableDomUtil {
    private static final String[] DRAWABLE_ROOTS_V1 = new String[]{"selector", "bitmap", "nine-patch", "layer-list", "level-list", "transition", "inset", "clip", "scale", "shape", "animation-list", "animated-rotate", "rotate", "color"};
    private static final String[] DRAWABLE_ROOTS_V16 = new String[]{"drawable"};
    private static final String[] DRAWABLE_ROOTS_V21 = new String[]{"ripple", "animated-selector", "vector", "animated-vector"};

    private AndroidDrawableDomUtil() {
    }

    public static boolean isDrawableResourceFile(@NotNull XmlFile file) {
        return AndroidResourceDomFileDescription.isFileInResourceFolderType(file, ResourceFolderType.DRAWABLE);
    }

    @NotNull
    public static List<String> getPossibleRoots(@NotNull AndroidFacet facet, @NotNull ResourceFolderType folderType) {
        AndroidVersion sdkVersion = AndroidModuleInfo.getInstance(facet).getBuildSdkVersion();
        ArrayList<String> result2 = new ArrayList<String>(DRAWABLE_ROOTS_V1.length + DRAWABLE_ROOTS_V16.length + DRAWABLE_ROOTS_V21.length + AdaptiveIconDomFileDescription.TAGS.size());
        if (folderType != ResourceFolderType.MIPMAP) {
            Collections.addAll(result2, DRAWABLE_ROOTS_V1);
            if (sdkVersion == null || sdkVersion.getFeatureLevel() >= 16 || ApplicationManager.getApplication().isUnitTestMode()) {
                Collections.addAll(result2, DRAWABLE_ROOTS_V16);
            }
            if (sdkVersion == null || sdkVersion.getFeatureLevel() >= 21 || ApplicationManager.getApplication().isUnitTestMode()) {
                Collections.addAll(result2, DRAWABLE_ROOTS_V21);
            }
        }
        if (sdkVersion == null || sdkVersion.getFeatureLevel() >= 26 || ApplicationManager.getApplication().isUnitTestMode()) {
            result2.addAll((Collection<String>)AdaptiveIconDomFileDescription.TAGS);
        }
        return result2;
    }

    @NotNull
    public static List<String> getPossibleRoots(@NotNull AndroidFacet facet) {
        return AndroidDrawableDomUtil.getPossibleRoots(facet, ResourceFolderType.DRAWABLE);
    }
}

