/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.inspections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidXmlExtension;
import org.jetbrains.android.dom.converters.AndroidPackageConverter;
import org.jetbrains.android.dom.converters.AndroidPermissionConverter;
import org.jetbrains.android.dom.converters.ConstantFieldConverter;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.DeclareStyleableNameConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidDomInspection
extends BasicDomElementsInspection<AndroidDomElement> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.dom.inspections.AndroidDomInspection");

    public AndroidDomInspection() {
        super(AndroidDomElement.class, new Class[0]);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return AndroidBundle.message("android.inspections.group.name", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return AndroidBundle.message("android.inspections.dom.name", new Object[0]);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "AndroidDomInspection";
    }

    public void checkFileElement(DomFileElement<AndroidDomElement> domFileElement, DomElementAnnotationHolder holder) {
        XmlTag rootTag = domFileElement.getRootTag();
        if (rootTag == null || StringUtil.isEmpty((String)rootTag.getName())) {
            return;
        }
        super.checkFileElement(domFileElement, holder);
    }

    protected boolean shouldCheckResolveProblems(GenericDomValue value2) {
        Converter realConverter = WrappingConverter.getDeepestConverter((Converter)value2.getConverter(), (GenericDomValue)value2);
        return (!(realConverter instanceof ResourceReferenceConverter) || !AndroidDomInspection.isInTestFile(value2)) && !(realConverter instanceof AndroidPackageConverter) && !(realConverter instanceof DeclareStyleableNameConverter) && !(realConverter instanceof OnClickConverter) && !(realConverter instanceof ConstantFieldConverter) && !(realConverter instanceof AndroidPermissionConverter);
    }

    private static boolean isInTestFile(GenericDomValue value2) {
        AndroidFacet facet;
        Module module;
        VirtualFile virtualFile;
        PsiFile psiFile = value2.getXmlTag().getContainingFile();
        return psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null && (module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)psiFile.getProject())) != null && (facet = AndroidFacet.getInstance(module)) != null && IdeaSourceProvider.isTestFile(facet, virtualFile);
    }

    protected void checkChildren(DomElement element, Consumer<? super DomElement> visitor) {
        XmlElement xmlElement = element.getXmlElement();
        if (xmlElement instanceof XmlTag) {
            for (DomElement child : DomUtil.getDefinedChildren((DomElement)element, (boolean)true, (boolean)true)) {
                XmlElement element1 = child.getXmlElement();
                if (element1 == null) {
                    LOG.error("No XML element for DomElement " + child + " of class " + child.getClass().getName() + "; parent=" + element);
                    continue;
                }
                if (!element1.isPhysical()) continue;
                visitor.consume((Object)child);
            }
            for (AbstractDomChildrenDescription description : element.getGenericInfo().getChildrenDescriptions()) {
                if (description.getAnnotation(Required.class) == null) continue;
                for (DomElement child : description.getValues(element)) {
                    if (child.exists()) continue;
                    String name = child.getXmlElementName();
                    String namespaceKey = child.getXmlElementNamespaceKey();
                    if (namespaceKey != null) {
                        name = namespaceKey + ':' + name;
                    }
                    if (AndroidXmlExtension.isAaptAttributeDefined((XmlTag)xmlElement, name)) continue;
                    visitor.consume((Object)child);
                }
            }
        }
    }
}

