/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.inspections;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.databinding.DataBindingModuleComponent;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.AndroidAnyAttributeDescriptor;
import org.jetbrains.android.dom.AndroidDomExtender;
import org.jetbrains.android.dom.AndroidXmlTagDescriptor;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AndroidUnknownAttributeInspection
extends LocalInspectionTool {
    private static volatile Set<ResourceFolderType> ourSupportedResourceTypes;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return AndroidBundle.message("android.inspections.group.name", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return AndroidBundle.message("android.inspections.unknown.attribute.name", new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "AndroidUnknownAttribute";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!(file instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!AndroidDomExtender.areExtensionsKnown()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (AndroidUnknownAttributeInspection.isMyFile(facet, (XmlFile)file)) {
            Module module = facet.getModule();
            DataBindingModuleComponent dataBindingComponent = (DataBindingModuleComponent)module.getComponent(DataBindingModuleComponent.class);
            Set<Object> bindingAdapterAttributes = dataBindingComponent != null ? dataBindingComponent.getBindingAdapterAttributes() : Collections.emptySet();
            MyVisitor visitor = new MyVisitor(manager, bindingAdapterAttributes, isOnTheFly);
            file.accept((PsiElementVisitor)visitor);
            return visitor.myResult.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    static boolean isMyFile(@NotNull AndroidFacet facet, XmlFile file) {
        ResourceFolderType resourceType = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getFileResourceFolderType((PsiFile)file);
        if (resourceType != null) {
            if (ourSupportedResourceTypes == null) {
                ourSupportedResourceTypes = EnumSet.complementOf(EnumSet.of(ResourceFolderType.INTERPOLATOR, ResourceFolderType.VALUES));
            }
            if (!ourSupportedResourceTypes.contains(resourceType) || ResourceFolderType.RAW == resourceType) {
                return false;
            }
            if (ResourceFolderType.XML == resourceType) {
                XmlTag rootTag = file.getRootTag();
                return rootTag != null && AndroidXmlResourcesUtil.isSupportedRootTag(facet, rootTag.getName());
            }
            return true;
        }
        return ManifestDomFileDescription.isManifestFile(file, facet);
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final Set<String> myBindingAdapterAttributes;
        private final boolean myOnTheFly;
        final List<ProblemDescriptor> myResult = new ArrayList<ProblemDescriptor>();

        private MyVisitor(InspectionManager inspectionManager, Set<String> bindingAdapterAttributes, boolean onTheFly) {
            this.myInspectionManager = inspectionManager;
            this.myBindingAdapterAttributes = bindingAdapterAttributes;
            this.myOnTheFly = onTheFly;
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            XmlTag tag;
            String namespace;
            if (!"xmlns".equals(attribute.getNamespacePrefix()) && ("http://schemas.android.com/apk/res/android".equals(namespace = attribute.getNamespace()) || namespace.isEmpty()) && (tag = attribute.getParent()) != null && tag.getDescriptor() instanceof AndroidXmlTagDescriptor && attribute.getDescriptor() instanceof AndroidAnyAttributeDescriptor) {
                PsiElement nameElement;
                if (this.myBindingAdapterAttributes.contains(attribute.getName())) {
                    return;
                }
                ASTNode node = attribute.getNode();
                assert (node != null);
                ASTNode nameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
                PsiElement psiElement = nameElement = nameNode != null ? nameNode.getPsi() : null;
                if (nameElement != null) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor(nameElement, AndroidBundle.message("android.inspections.unknown.attribute.message", attribute.getName()), this.myOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
            }
        }
    }
}

