/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.manifest;

import com.android.builder.model.ProductFlavor;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.android.dom.manifest.CompatibleScreensScreen;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestUtils {
    @Nullable
    public static String getPackageName(@NotNull AndroidFacet androidFacet) {
        return (String)CachedValuesManager.getManager((Project)androidFacet.getModule().getProject()).getCachedValue((UserDataHolder)androidFacet, () -> {
            Manifest manifest = androidFacet.getManifest();
            if (manifest == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
            }
            String packageName = (String)manifest.getPackage().getValue();
            return CachedValueProvider.Result.create((Object)StringUtil.nullize((String)packageName, (boolean)true), (Object[])new Object[]{manifest.getXmlTag()});
        });
    }

    @Nullable
    public static String getTestPackageName(@NotNull AndroidFacet androidFacet) {
        String applicationId2;
        AndroidModuleModel moduleModel = AndroidModuleModel.get(androidFacet);
        if (moduleModel == null) {
            return null;
        }
        ProductFlavor flavor = moduleModel.getSelectedVariant().getMergedFlavor();
        String testApplicationId2 = flavor.getTestApplicationId();
        if (testApplicationId2 != null) {
            return testApplicationId2;
        }
        String string = applicationId2 = ((AndroidFacetConfiguration)androidFacet.getConfiguration()).isLibraryProject() ? AndroidManifestUtils.getPackageName(androidFacet) : flavor.getApplicationId();
        if (StringUtil.isNotEmpty((String)applicationId2)) {
            return applicationId2 + ".test";
        }
        return null;
    }

    public static boolean isRequiredAttribute(@NotNull XmlName attrName, @NotNull DomElement element) {
        if (element instanceof CompatibleScreensScreen && "http://schemas.android.com/apk/res/android".equals(attrName.getNamespaceKey())) {
            String localName = attrName.getLocalName();
            return "screenSize".equals(localName) || "screenDensity".equals(localName);
        }
        return false;
    }

    @Nullable
    public static Collection<String> getCustomPermissions(@NotNull AndroidFacet androidFacet) {
        XmlFile manifest = AndroidManifestUtils.getManifest(androidFacet);
        return manifest == null ? null : AndroidManifestUtils.getAndroidNamesForTags(manifest, "permission");
    }

    @Nullable
    public static Collection<String> getCustomPermissionGroups(@NotNull AndroidFacet androidFacet) {
        XmlFile manifest = AndroidManifestUtils.getManifest(androidFacet);
        return manifest == null ? null : AndroidManifestUtils.getAndroidNamesForTags(manifest, "permission-group");
    }

    @Nullable
    private static XmlFile getManifest(@NotNull AndroidFacet androidFacet) {
        VirtualFile file = androidFacet.getManifestFile();
        if (file == null) {
            return null;
        }
        PsiFile manifest = AndroidPsiUtils.getPsiFileSafely(androidFacet.getModule().getProject(), file);
        if (!(manifest instanceof XmlFile)) {
            return null;
        }
        return (XmlFile)manifest;
    }

    private static Collection<String> getAndroidNamesForTags(@NotNull XmlFile xmlFile, final @NotNull String tagName) {
        final ArrayList<String> androidNames = new ArrayList<String>();
        xmlFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                if (!tagName.equals(tag.getName())) {
                    return;
                }
                String androidName = tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                if (androidName != null) {
                    androidNames.add(androidName);
                }
            }
        });
        return androidNames;
    }

    private AndroidManifestUtils() {
    }
}

