/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.navigation;

import com.android.SdkConstants;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.navigation.ConcreteDestinationElement;
import org.jetbrains.android.dom.navigation.DeeplinkElement;
import org.jetbrains.android.dom.navigation.NavActionElement;
import org.jetbrains.android.dom.navigation.NavArgumentElement;
import org.jetbrains.android.dom.navigation.NavGraphElement;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationSchema
implements Disposable {
    public static final String TAG_ACTION = "action";
    public static final String TAG_ARGUMENT = "argument";
    public static final String ATTR_DESTINATION = "destination";
    public static final String INCLUDE_GRAPH_LABEL = "Include Graph";
    public static final String ACTION_LABEL = "Action";
    private static final String NAVIGATOR_CLASS_NAME = "androidx.navigation.Navigator";
    private static final String ANNOTATION_NAV_TAG_NAME = "androidx.navigation.Navigator.Name";
    private static final String ANNOTATION_NAV_CLASS_TYPE = "androidx.navigation.NavDestination.ClassType";
    public static final String ATTR_POP_UP_TO = "popUpTo";
    public static final String ATTR_POP_UP_TO_INCLUSIVE = "popUpToInclusive";
    public static final String ATTR_SINGLE_TOP = "launchSingleTop";
    public static final String ATTR_ENTER_ANIM = "enterAnim";
    public static final String ATTR_EXIT_ANIM = "exitAnim";
    public static final String ATTR_POP_ENTER_ANIM = "popEnterAnim";
    public static final String ATTR_POP_EXIT_ANIM = "popExitAnim";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_DATA = "data";
    public static final String ATTR_DATA_PATTERN = "dataPattern";
    public static final String ATTR_DEFAULT_VALUE = "defaultValue";
    public static final String NAV_GRAPH_DESTINATION = "androidx.navigation.NavGraph";
    private Map<DestinationType, String> myTypeToRootTag;
    public static final String ROOT_ACTIVITY_NAVIGATOR = "androidx.navigation.ActivityNavigator";
    public static final String ROOT_FRAGMENT_NAVIGATOR = "androidx.navigation.fragment.FragmentNavigator";
    public static final String ROOT_NAV_GRAPH_NAVIGATOR = "androidx.navigation.NavGraphNavigator";
    private final TypeRef NULL_TYPE = new TypeRef();
    private final Map<String, TypeRef> myTypeCache = new HashMap<String, TypeRef>();
    private ImmutableList<NavigatorKeyInfo> myNavigatorCacheKeys;
    private final Module myModule;
    private ImmutableMultimap<DestinationType, TypeRef> myTypeToDestinationClass;
    private ImmutableMultimap<String, TypeRef> myTagToDestinationClass;
    private ImmutableMultimap<String, TypeRef> myTagToStyleables;
    private static final Map<Module, NavigationSchema> ourSchemas = new HashMap<Module, NavigationSchema>();
    private static final Multimap<Module, Runnable> ourListeners = ArrayListMultimap.create();
    private static final Object ourListenerLock = new Object();
    private CompletableFuture<NavigationSchema> myRebuildTask;
    private final Object myTaskLock = new Object();
    private int myCustomNavigatorCount;
    private int myCustomTagCount;
    private int myCustomDestinationCount;

    @Nullable
    private PsiClass getClass(@Nullable String className) {
        PsiClass c;
        if (className == null) {
            return null;
        }
        TypeRef ref = this.myTypeCache.get(className);
        if (ref != null && (c = ref.dereference()) != null) {
            return c;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
        PsiClass result2 = javaPsiFacade.findClass(className, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule, (boolean)true));
        if (result2 != null) {
            this.myTypeCache.put(className, new TypeRef(result2));
        } else {
            this.myTypeCache.remove(className);
        }
        return result2;
    }

    public int hashCode() {
        return Objects.hash(this.myModule, this.myTagToDestinationClass, this.myTagToDestinationClass, this.myTagToStyleables);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NavigationSchema)) {
            return false;
        }
        NavigationSchema otherSchema = (NavigationSchema)obj;
        return Objects.equals(this.myModule, otherSchema.myModule) && Objects.equals(this.myTypeToDestinationClass, otherSchema.myTypeToDestinationClass) && Objects.equals(this.myTagToDestinationClass, otherSchema.myTagToDestinationClass) && Objects.equals(this.myTagToStyleables, otherSchema.myTagToStyleables);
    }

    @NotNull
    public static synchronized NavigationSchema get(@NotNull Module module) {
        NavigationSchema result2 = ourSchemas.get(module);
        Preconditions.checkNotNull((Object)result2, (Object)"NavigationSchema must be created first!");
        return result2;
    }

    public static synchronized void createIfNecessary(@NotNull Module module) throws ClassNotFoundException {
        NavigationSchema result2 = ourSchemas.get(module);
        if (result2 == null) {
            result2 = new NavigationSchema(module);
            result2.init();
            Disposer.register((Disposable)module, (Disposable)result2);
            ourSchemas.put(module, result2);
        }
    }

    private NavigationSchema(@NotNull Module module) {
        this.myModule = module;
    }

    public void dispose() {
        ApplicationManager.getApplication().invokeLater(() -> ourSchemas.remove(this.myModule, this));
    }

    private void init() throws ClassNotFoundException {
        GlobalSearchScope scope;
        Project project = this.myModule.getProject();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass navigatorRoot = javaPsiFacade.findClass(NAVIGATOR_CLASS_NAME, scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
        if (navigatorRoot == null) {
            Logger.getInstance(this.getClass()).warn("Navigator class not found.");
            throw new ClassNotFoundException(NAVIGATOR_CLASS_NAME);
        }
        HashMap<PsiClass, String> navigatorToTag = new HashMap<PsiClass, String>();
        HashMap<PsiClass, PsiClass> navigatorToDestinationClass = new HashMap<PsiClass, PsiClass>();
        navigatorToDestinationClass.put(this.getClass(ROOT_NAV_GRAPH_NAVIGATOR), this.getClass(NAV_GRAPH_DESTINATION));
        HashSet nonCustomDestinations = new HashSet();
        HashSet nonCustomTags = new HashSet();
        for (PsiClass navClass : ClassInheritorsSearch.search((PsiClass)navigatorRoot, (SearchScope)scope, (boolean)true)) {
            if (navClass.equals(navigatorRoot)) continue;
            String qName = navClass.getQualifiedName();
            if (qName != null) {
                if (qName.startsWith("androidx.")) {
                    if (!navClass.hasModifier(JvmModifier.PUBLIC)) {
                        continue;
                    }
                } else {
                    ++this.myCustomNavigatorCount;
                }
            }
            NavigationSchema.collectDestinationsForNavigator(navigatorRoot, navClass, navigatorToDestinationClass);
            NavigationSchema.collectTagsForNavigator(navClass, navigatorToTag);
            if (qName == null || !qName.startsWith("androidx.")) continue;
            nonCustomDestinations.add(navigatorToDestinationClass.get(navClass));
            nonCustomTags.add(navigatorToTag.get(navClass));
        }
        this.myTagToStyleables = this.buildTagToStyleables(navigatorToTag);
        this.myTagToDestinationClass = this.buildTagToDestinationMap(navigatorToTag, navigatorToDestinationClass);
        this.myTypeToDestinationClass = this.buildDestinationTypeToDestinationMap();
        this.myCustomDestinationCount = new HashSet(this.myTagToDestinationClass.values()).size() - nonCustomDestinations.size();
        this.myCustomTagCount = this.myTagToDestinationClass.keySet().size() - nonCustomTags.size();
        this.myTypeToRootTag = this.buildTypeToDefaultTag(navigatorToTag);
        this.myNavigatorCacheKeys = this.buildCacheKeys(navigatorToTag, navigatorToDestinationClass);
    }

    private ImmutableList<NavigatorKeyInfo> buildCacheKeys(Map<PsiClass, String> tagMap, Map<PsiClass, PsiClass> destinationTypeMap) {
        ImmutableList.Builder result2 = new ImmutableList.Builder();
        for (PsiClass navigator : Sets.union(tagMap.keySet(), destinationTypeMap.keySet())) {
            NavigatorKeyInfo key = new NavigatorKeyInfo(navigator, tagMap.get(navigator), destinationTypeMap.get(navigator));
            result2.add((Object)key);
        }
        return result2.build();
    }

    private ImmutableMultimap<String, TypeRef> buildTagToStyleables(Map<PsiClass, String> navigatorToTag) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        navigatorToTag.forEach((navigator, tag) -> builder.put(tag, (Object)new TypeRef((PsiClass)navigator)));
        return builder.build();
    }

    @NotNull
    private ImmutableMultimap<DestinationType, TypeRef> buildDestinationTypeToDestinationMap() {
        PsiClass newFragment;
        HashMap<PsiClass, DestinationType> destinationClassToType = new HashMap<PsiClass, DestinationType>();
        destinationClassToType.put(this.getClass("android.app.Activity"), DestinationType.ACTIVITY);
        PsiClass oldFragment = this.getClass(SdkConstants.CLASS_V4_FRAGMENT.oldName());
        if (oldFragment != null) {
            destinationClassToType.put(oldFragment, DestinationType.FRAGMENT);
        }
        if ((newFragment = this.getClass(SdkConstants.CLASS_V4_FRAGMENT.newName())) != null) {
            destinationClassToType.put(newFragment, DestinationType.FRAGMENT);
        }
        destinationClassToType.put(this.getClass(NAV_GRAPH_DESTINATION), DestinationType.NAVIGATION);
        for (TypeRef destinationClassRef : this.myTagToDestinationClass.values()) {
            PsiClass destinationClass;
            if (destinationClassRef == this.NULL_TYPE || (destinationClass = destinationClassRef.dereference()) == null) continue;
            ArrayList<PsiClass> toUpdate = new ArrayList<PsiClass>();
            DestinationType result2 = DestinationType.OTHER;
            while (destinationClass != null) {
                toUpdate.add(destinationClass);
                DestinationType t = (DestinationType)((Object)destinationClassToType.get(destinationClass));
                if (t != null) {
                    result2 = t;
                    break;
                }
                destinationClass = destinationClass.getSuperClass();
            }
            for (PsiClass d : toUpdate) {
                destinationClassToType.put(d, result2);
            }
        }
        ImmutableMultimap.Builder typeToDestinationBuilder = ImmutableMultimap.builder();
        destinationClassToType.forEach((destination, type) -> typeToDestinationBuilder.put((Object)type, (Object)new TypeRef((PsiClass)destination)));
        typeToDestinationBuilder.put((Object)DestinationType.OTHER, (Object)this.NULL_TYPE);
        return typeToDestinationBuilder.build();
    }

    @NotNull
    private ImmutableMultimap<String, TypeRef> buildTagToDestinationMap(@NotNull Map<PsiClass, String> navigatorToTag, @NotNull Map<PsiClass, PsiClass> navigatorToDestinationClass) {
        ImmutableMultimap.Builder tagToDestBuilder = new ImmutableMultimap.Builder();
        for (Map.Entry<PsiClass, PsiClass> navToDestEntry : navigatorToDestinationClass.entrySet()) {
            String tag = navigatorToTag.get(navToDestEntry.getKey());
            if (tag == null) continue;
            PsiClass destClass = navToDestEntry.getValue();
            tagToDestBuilder.put((Object)tag, (Object)(destClass == null ? this.NULL_TYPE : new TypeRef(destClass)));
        }
        return tagToDestBuilder.build();
    }

    private static void collectTagsForNavigator(@NotNull PsiClass navClass, @NotNull Map<PsiClass, String> navigatorToTagCollector) {
        String result2;
        PsiClass tempNavigator = navClass;
        ArrayList childrenToUpdate = Lists.newArrayList();
        do {
            childrenToUpdate.add(tempNavigator);
            result2 = navigatorToTagCollector.get(tempNavigator);
        } while (result2 == null && (result2 = NavigationSchema.getTagAnnotationValue(navClass)) == null && (tempNavigator = tempNavigator.getSuperClass()) != null && !NAVIGATOR_CLASS_NAME.equals(tempNavigator.getQualifiedName()));
        if (result2 != null) {
            for (PsiClass navigator : childrenToUpdate) {
                navigatorToTagCollector.put(navigator, result2);
            }
        }
    }

    private static void collectDestinationsForNavigator(@NotNull PsiClass navigatorRoot, @NotNull PsiClass navClass, @NotNull Map<PsiClass, PsiClass> navigatorToDestinationClassCollector) {
        PsiClass resultDestination = navigatorToDestinationClassCollector.get(navClass);
        if (resultDestination == null) {
            resultDestination = NavigationSchema.getDestinationClassAnnotationValue(navClass, navigatorRoot);
        }
        if (resultDestination == null) {
            for (PsiClass parentClass = navClass.getSuperClass(); parentClass != null && resultDestination == null; parentClass = parentClass.getSuperClass()) {
                resultDestination = navigatorToDestinationClassCollector.get(parentClass);
            }
        }
        navigatorToDestinationClassCollector.put(navClass, resultDestination);
    }

    @Nullable
    private static PsiClass getDestinationClassAnnotationValue(@NotNull PsiClass subNav, @NotNull PsiClass navigatorRoot) {
        PsiTypeParameter destinationTypeParam = navigatorRoot.getTypeParameters()[0];
        PsiType resolved = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)navigatorRoot, (PsiClassType)PsiTypesUtil.getClassType((PsiClass)subNav)).substitute(destinationTypeParam);
        if (resolved == null) {
            return null;
        }
        ArrayList<PsiType> resolvedWithSupers = new ArrayList<PsiType>(Arrays.asList(resolved.getSuperTypes()));
        resolvedWithSupers.add(0, resolved);
        for (PsiType t : resolvedWithSupers) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)PsiTypesUtil.getPsiClass((PsiType)t), (String[])new String[]{ANNOTATION_NAV_CLASS_TYPE});
            if (annotation == null) continue;
            PsiAnnotationMemberValue expression = annotation.findAttributeValue("value");
            if (!(expression instanceof PsiClassObjectAccessExpression)) {
                return null;
            }
            return PsiTypesUtil.getPsiClass((PsiType)((PsiClassObjectAccessExpression)expression).getOperand().getType());
        }
        return null;
    }

    @Nullable
    private static String getTagAnnotationValue(@NotNull PsiClass subNav) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)subNav, (String[])new String[]{ANNOTATION_NAV_TAG_NAME});
        return annotation == null ? null : AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"value");
    }

    private Map<DestinationType, String> buildTypeToDefaultTag(Map<PsiClass, String> navigatorToTag) {
        HashMap<DestinationType, String> result2 = new HashMap<DestinationType, String>();
        result2.put(DestinationType.FRAGMENT, navigatorToTag.get(this.getClass(ROOT_FRAGMENT_NAVIGATOR)));
        result2.put(DestinationType.ACTIVITY, navigatorToTag.get(this.getClass(ROOT_ACTIVITY_NAVIGATOR)));
        result2.put(DestinationType.NAVIGATION, navigatorToTag.get(this.getClass(ROOT_NAV_GRAPH_NAVIGATOR)));
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompletableFuture<NavigationSchema> getRebuildTask() {
        Object object = this.myTaskLock;
        synchronized (object) {
            return this.myRebuildTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quickValidate() {
        Object object = this.myTaskLock;
        synchronized (object) {
            if (this.myRebuildTask != null) {
                return false;
            }
            return this.myNavigatorCacheKeys.stream().allMatch(value2 -> value2.checkConsistent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<NavigationSchema> rebuildSchema() {
        CompletableFuture<NavigationSchema> task;
        Object object = this.myTaskLock;
        synchronized (object) {
            if (this.myRebuildTask != null) {
                return this.myRebuildTask;
            }
            task = this.myRebuildTask = new CompletableFuture();
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ArrayList listeners;
            NavigationSchema newVersion = new NavigationSchema(this.myModule);
            DumbService.getInstance((Project)this.myModule.getProject()).runReadActionInSmartMode(() -> {
                try {
                    newVersion.init();
                }
                catch (Throwable t) {
                    Object object = this.myTaskLock;
                    synchronized (object) {
                        this.myRebuildTask.completeExceptionally(t);
                        this.myRebuildTask = null;
                    }
                }
            });
            if (this.myRebuildTask == null) {
                return;
            }
            if (this.equals(newVersion)) {
                Object object = this.myTaskLock;
                synchronized (object) {
                    this.myRebuildTask.complete(this);
                    this.myRebuildTask = null;
                }
                return;
            }
            Disposer.register((Disposable)this.myModule, (Disposable)newVersion);
            ourSchemas.put(this.myModule, newVersion);
            Object object = this.myTaskLock;
            synchronized (object) {
                this.myRebuildTask.complete(newVersion);
            }
            Object object2 = ourListenerLock;
            synchronized (object2) {
                listeners = new ArrayList(ourListeners.get((Object)this.myModule));
            }
            listeners.forEach(Runnable::run);
            Disposer.dispose((Disposable)this);
        });
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSchemaRebuildListener(@NotNull Module module, @NotNull Runnable listener2) {
        Object object = ourListenerLock;
        synchronized (object) {
            ourListeners.put((Object)module, (Object)listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSchemaRebuildListener(@NotNull Module module, Runnable listener2) {
        Object object = ourListenerLock;
        synchronized (object) {
            ourListeners.remove((Object)module, (Object)listener2);
        }
    }

    @NotNull
    public Multimap<Class<? extends AndroidDomElement>, String> getDestinationSubtags(@NotNull String tagName) {
        if (tagName.equals("action")) {
            return ImmutableSetMultimap.of(NavArgumentElement.class, (Object)TAG_ARGUMENT);
        }
        HashMultimap result2 = HashMultimap.create();
        for (DestinationType type : this.getDestinationTypesForTag(tagName)) {
            if (type == null || this.isIncludeTag(tagName).booleanValue()) continue;
            if (type == DestinationType.NAVIGATION) {
                this.myTypeToDestinationClass.forEach((arg_0, arg_1) -> this.lambda$getDestinationSubtags$6((Multimap)result2, arg_0, arg_1));
                result2.put(NavGraphElement.class, (Object)"include");
            }
            if (type != DestinationType.ACTIVITY) {
                result2.put(NavActionElement.class, (Object)"action");
            }
            result2.put(DeeplinkElement.class, (Object)"deepLink");
            result2.put(NavArgumentElement.class, (Object)TAG_ARGUMENT);
        }
        return result2;
    }

    @NotNull
    public static List<String> getPossibleRootsMaybeWithoutSchema(@NotNull Module module) {
        Application application = ApplicationManager.getApplication();
        AtomicReference result2 = new AtomicReference();
        application.invokeAndWait(() -> application.runReadAction(() -> {
            try {
                NavigationSchema.createIfNecessary(module);
                result2.set(NavigationSchema.get(module).getPossibleRoots());
            }
            catch (ClassNotFoundException e) {
                result2.set(ImmutableList.of((Object)"navigation"));
            }
        }));
        return (List)result2.get();
    }

    @NotNull
    public List<String> getPossibleRoots() {
        return this.myTypeToDestinationClass.get((Object)DestinationType.NAVIGATION).stream().flatMap(c -> this.myTagToDestinationClass.inverse().get(c).stream()).collect(Collectors.toList());
    }

    @NotNull
    public Collection<PsiClass> getStyleablesForTag(@NotNull String tag) {
        return this.myTagToStyleables.get((Object)tag).stream().map(TypeRef::dereference).collect(Collectors.toList());
    }

    @NotNull
    public Collection<String> getAllTags() {
        return this.myTagToDestinationClass.keySet();
    }

    @NotNull
    public Collection<DestinationType> getDestinationTypesForTag(@NotNull String tag) {
        if (tag.equals("include")) {
            return ImmutableList.of((Object)((Object)DestinationType.NAVIGATION));
        }
        EnumSet<DestinationType> result2 = EnumSet.noneOf(DestinationType.class);
        for (TypeRef destinationClassRef : this.myTagToDestinationClass.get((Object)tag)) {
            if (destinationClassRef == this.NULL_TYPE) {
                result2.add(DestinationType.OTHER);
                continue;
            }
            result2.addAll((Collection<DestinationType>)this.myTypeToDestinationClass.inverse().get((Object)destinationClassRef));
        }
        return result2;
    }

    @Nullable
    public DestinationType getDestinationTypeForDestinationClassName(@NotNull String className) {
        ImmutableCollection types = this.myTypeToDestinationClass.inverse().get((Object)new TypeRef(className));
        return types.isEmpty() ? null : (DestinationType)((Object)types.iterator().next());
    }

    @Contract(value="null -> null")
    @Nullable
    public Collection<String> getTagsForDestinationClass(@Nullable PsiClass layoutClass) {
        while (layoutClass != null) {
            ImmutableCollection result2 = this.myTagToDestinationClass.inverse().get((Object)new TypeRef(layoutClass));
            if (!result2.isEmpty()) {
                return result2;
            }
            layoutClass = layoutClass.getSuperClass();
        }
        return null;
    }

    @NotNull
    public Collection<PsiClass> getDestinationClassesForTag(@NotNull String tagName) {
        return this.myTagToDestinationClass.get((Object)tagName).stream().map(TypeRef::dereference).filter(c -> c != null).collect(Collectors.toSet());
    }

    @Nullable
    public String getDefaultTag(@NotNull DestinationType type) {
        return this.myTypeToRootTag.get((Object)type);
    }

    @NotNull
    public String getTagLabel(@NotNull String tag) {
        return this.getTagLabel(tag, false);
    }

    @NotNull
    public String getTagLabel(@NotNull String tag, boolean isRoot) {
        String text = null;
        if (this.isIncludeTag(tag).booleanValue()) {
            text = INCLUDE_GRAPH_LABEL;
        } else if ("action".equals(tag)) {
            text = ACTION_LABEL;
        } else {
            Collection<DestinationType> types = this.getDestinationTypesForTag(tag);
            if (types.size() > 1) {
                text = "Ambiguous Type";
            } else if (types.contains((Object)DestinationType.NAVIGATION)) {
                text = isRoot ? "Root Graph" : "Nested Graph";
            } else if (types.contains((Object)DestinationType.FRAGMENT)) {
                text = "Fragment";
            } else if (types.contains((Object)DestinationType.ACTIVITY)) {
                text = "Activity";
            } else if (types.contains((Object)DestinationType.OTHER)) {
                text = tag;
            }
            if (types.stream().map(this::getDefaultTag).noneMatch(t -> t == null || t.equals(tag))) {
                text = text + " (" + tag + ")";
            }
        }
        assert (text != null);
        return text;
    }

    public Boolean isFragmentTag(@NotNull String tag) {
        return this.getDestinationTypesForTag(tag).contains((Object)DestinationType.FRAGMENT);
    }

    public Boolean isActivityTag(@NotNull String tag) {
        return this.getDestinationTypesForTag(tag).contains((Object)DestinationType.ACTIVITY);
    }

    public Boolean isNavigationTag(@NotNull String tag) {
        return this.getDestinationTypesForTag(tag).contains((Object)DestinationType.NAVIGATION);
    }

    public Boolean isOtherTag(@NotNull String tag) {
        return this.getDestinationTypesForTag(tag).contains((Object)DestinationType.OTHER);
    }

    public Boolean isIncludeTag(@NotNull String tag) {
        return tag.equals("include");
    }

    public int getCustomNavigatorCount() {
        return this.myCustomNavigatorCount;
    }

    public int getCustomTagCount() {
        return this.myCustomTagCount;
    }

    public int getCustomDestinationCount() {
        return this.myCustomDestinationCount;
    }

    private /* synthetic */ void lambda$getDestinationSubtags$6(Multimap result2, DestinationType childType, TypeRef childDestinationClass) {
        for (String tag : this.myTagToDestinationClass.inverse().get((Object)childDestinationClass)) {
            result2.put(childType == DestinationType.NAVIGATION ? NavGraphElement.class : ConcreteDestinationElement.class, (Object)tag);
        }
    }

    private class NavigatorKeyInfo {
        long myModificationCount;
        @NotNull
        TypeRef myNavigatorTypeRef;
        @Nullable
        String myTagName;
        @Nullable
        TypeRef myDestinationClassRef;

        private NavigatorKeyInfo(@Nullable PsiClass navigator, @Nullable String tag, PsiClass destinationClass) {
            this.myModificationCount = this.getModificationCount(navigator);
            this.myNavigatorTypeRef = new TypeRef(navigator);
            this.myTagName = tag;
            this.myDestinationClassRef = destinationClass == null ? NavigationSchema.this.NULL_TYPE : new TypeRef(destinationClass);
        }

        boolean checkConsistent(@NotNull NavigationSchema schema) {
            PsiClass otherClass = this.myNavigatorTypeRef.dereference();
            if (otherClass == null) {
                return false;
            }
            if (this.getModificationCount(otherClass) == this.myModificationCount) {
                return true;
            }
            String tag = NavigationSchema.getTagAnnotationValue(otherClass);
            if (!Objects.equals(this.myTagName, tag)) {
                return false;
            }
            PsiClass rootNavigator = schema.getClass(NavigationSchema.NAVIGATOR_CLASS_NAME);
            if (rootNavigator == null) {
                return false;
            }
            PsiClass otherDestination = null;
            for (PsiClass otherOrParent = otherClass; otherDestination == null && otherOrParent != null && otherOrParent.isInheritor(rootNavigator, true); otherOrParent = otherOrParent.getSuperClass()) {
                otherDestination = NavigationSchema.getDestinationClassAnnotationValue(otherOrParent, rootNavigator);
            }
            PsiClass destinationClass = this.myDestinationClassRef == null ? null : this.myDestinationClassRef.dereference();
            String destinationName = destinationClass == null ? null : destinationClass.getQualifiedName();
            String otherName = otherDestination == null ? null : otherDestination.getQualifiedName();
            return Objects.equals(destinationName, otherName);
        }

        private long getModificationCount(@NotNull PsiClass psiClass) {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)psiClass.getProject());
            if (manager == null) {
                return 0L;
            }
            PsiFile file = psiClass.getContainingFile();
            if (file == null) {
                return 0L;
            }
            Document document = manager.getDocument(file);
            return document == null ? 0L : document.getModificationStamp();
        }
    }

    private class TypeRef {
        private String myClassName;
        private SmartPsiElementPointer<PsiClass> myPointer;

        TypeRef(PsiClass c) {
            this.myClassName = c.getQualifiedName();
            this.myPointer = SmartPointerManager.getInstance((Project)c.getProject()).createSmartPsiElementPointer((PsiElement)c);
        }

        TypeRef(String className) {
            this.myClassName = className;
        }

        TypeRef() {
        }

        @Nullable
        PsiClass dereference() {
            PsiClass result2;
            PsiClass psiClass = result2 = this.myPointer == null ? null : (PsiClass)this.myPointer.getElement();
            if (result2 == null) {
                NavigationSchema.this.myTypeCache.remove(this.myClassName);
                result2 = NavigationSchema.this.getClass(this.myClassName);
                if (result2 != null) {
                    this.myPointer = SmartPointerManager.getInstance((Project)result2.getProject()).createSmartPsiElementPointer((PsiElement)result2);
                }
            }
            return result2;
        }

        public int hashCode() {
            return this.myClassName == null ? 0 : this.myClassName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TypeRef && Objects.equals(((TypeRef)obj).myClassName, this.myClassName);
        }
    }

    public static enum DestinationType {
        NAVIGATION,
        FRAGMENT,
        ACTIVITY,
        OTHER;

    }
}

