/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.resources;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclareStyleableNameConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value2, PsiElement element, ConvertContext context) {
        AndroidFacet facet;
        Module module = context.getModule();
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
            return new PsiReference[]{new MyReference(facet, value2)};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static class MyReference
    extends PsiPolyVariantReferenceBase<PsiElement> {
        private final GenericDomValue<String> myValue;
        private final AndroidFacet myFacet;

        public MyReference(@NotNull AndroidFacet facet, @NotNull GenericDomValue<String> value2) {
            super((PsiElement)DomUtil.getValueElement(value2), true);
            this.myFacet = facet;
            this.myValue = value2;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            return ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)new ResolveCache.PolyVariantResolver<MyReference>(){

                @NotNull
                public ResolveResult[] resolve(@NotNull MyReference reference2, boolean incompleteCode) {
                    return this.resolveInner();
                }
            }, false, incompleteCode);
        }

        private ResolveResult[] resolveInner() {
            String value2 = this.myValue.getStringValue();
            if (value2 == null || value2.length() <= 0) {
                return ResolveResult.EMPTY_ARRAY;
            }
            PsiClass[] classes = PsiShortNamesCache.getInstance((Project)this.myElement.getProject()).getClassesByName(value2, this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false));
            if (classes.length == 0) {
                return ResolveResult.EMPTY_ARRAY;
            }
            ResolveResult[] result2 = new ResolveResult[classes.length];
            for (int i2 = 0; i2 < result2.length; ++i2) {
                result2[i2] = new PsiElementResolveResult((PsiElement)classes[i2]);
            }
            return result2;
        }

        @NotNull
        public Object[] getVariants() {
            PsiClass viewClass = JavaPsiFacade.getInstance((Project)this.myElement.getProject()).findClass("android.view.View", this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false));
            if (viewClass == null) {
                return EMPTY_ARRAY;
            }
            HashSet shortNames = new HashSet();
            ClassInheritorsSearch.search((PsiClass)viewClass, (SearchScope)this.myFacet.getModule().getModuleWithDependenciesScope(), (boolean)true).forEach((Processor)new Processor<PsiClass>((Set)shortNames){
                final /* synthetic */ Set val$shortNames;
                {
                    this.val$shortNames = set;
                }

                public boolean process(PsiClass aClass) {
                    String name = aClass.getName();
                    if (name != null) {
                        this.val$shortNames.add(JavaLookupElementBuilder.forClass((PsiClass)aClass, (String)name, (boolean)true));
                    }
                    return true;
                }
            });
            return shortNames.toArray();
        }
    }
}

