/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.structure.layout;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.structure.StructureUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutStructureViewBuilder
extends TreeBasedStructureViewBuilder {
    private final DomFileElement<LayoutViewElement> myElement;

    public LayoutStructureViewBuilder(@NotNull DomFileElement<LayoutViewElement> element) {
        this.myElement = element;
    }

    @NotNull
    public StructureViewModel createStructureViewModel(@Nullable Editor editor2) {
        return new StructureViewModelBase((PsiFile)this.myElement.getFile(), (StructureViewTreeElement)new LayoutNode((LayoutViewElement)this.myElement.getRootElement()));
    }

    private static class LayoutNode
    extends PsiTreeElementBase<XmlTag> {
        private final LayoutViewElement myElement;

        public LayoutNode(@NotNull LayoutViewElement element) {
            super((PsiElement)element.getXmlTag());
            this.myElement = element;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            final ArrayList result2 = Lists.newArrayList();
            DomElementVisitor visitor = new DomElementVisitor(){

                public void visitLayoutViewElement(LayoutViewElement element) {
                    result2.add(new LayoutNode(element));
                }

                public void visitFragment(Fragment element) {
                    result2.add(new FragmentNode(element));
                }

                public void visitInclude(Include element) {
                    result2.add(new IncludeNode(element));
                }

                public void visitDomElement(DomElement element) {
                }
            };
            StructureUtils.acceptChildrenInOrder(this.myElement, visitor);
            return result2;
        }

        public Icon getIcon(boolean open) {
            XmlTag tag = this.myElement.getXmlTag();
            if (tag == null) {
                return null;
            }
            return AndroidDomElementDescriptorProvider.getIconForViewTag(tag.getName());
        }

        public String getLocationString() {
            XmlTag xmlTag = this.myElement.getXmlTag();
            XmlAttribute idAttribute = xmlTag == null ? null : xmlTag.getAttribute("id", "http://schemas.android.com/apk/res/android");
            return idAttribute == null ? null : idAttribute.getValue();
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        @NotNull
        public String getPresentableText() {
            XmlTag xmlTag = this.myElement.getXmlTag();
            if (xmlTag == null) {
                return "";
            }
            String className = xmlTag.getName();
            return className.substring(className.lastIndexOf(46) + 1);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.dumpIndented(builder, 0);
            return builder.toString();
        }

        private void dumpIndented(@NotNull StringBuilder builder, int indentLevel) {
            for (int i2 = 0; i2 < indentLevel; ++i2) {
                builder.append("  ");
            }
            builder.append(this.getPresentableText());
            String locationString = this.getLocationString();
            if (locationString != null) {
                builder.append(" (").append(locationString).append(")");
            }
            builder.append('\n');
            for (StructureViewTreeElement element : this.getChildrenBase()) {
                if (element instanceof LayoutNode) {
                    ((LayoutNode)element).dumpIndented(builder, indentLevel + 1);
                    continue;
                }
                for (int i3 = 0; i3 < indentLevel + 1; ++i3) {
                    builder.append("  ");
                }
                builder.append(element.toString()).append("\n");
            }
        }
    }

    private static class IncludeNode
    extends PsiTreeElementBase<XmlTag> {
        private final Include myElement;

        private IncludeNode(@NotNull Include element) {
            super((PsiElement)element.getXmlTag());
            this.myElement = element;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            return Collections.emptyList();
        }

        @Nullable
        public String getPresentableText() {
            String result2 = "Include";
            String text = this.myElement.getLayout().getRawText();
            if (text != null) {
                result2 = result2 + " " + text;
            }
            return result2;
        }

        public Icon getIcon(boolean open) {
            return StudioIcons.LayoutEditor.Palette.INCLUDE;
        }

        public String toString() {
            return this.getPresentableText();
        }
    }

    private static class FragmentNode
    extends PsiTreeElementBase<XmlTag> {
        private final Fragment myElement;

        public FragmentNode(@NotNull Fragment element) {
            super((PsiElement)element.getXmlTag());
            this.myElement = element;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            return Collections.emptyList();
        }

        public Icon getIcon(boolean open) {
            return StudioIcons.LayoutEditor.Palette.FRAGMENT;
        }

        @Nullable
        public String getPresentableText() {
            return Joiner.on((String)" ").skipNulls().join((Object)"Fragment", (Object)this.myElement.getFragmentName().getRawText(), new Object[0]);
        }

        public String toString() {
            return this.getPresentableText();
        }
    }
}

