/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.wrappers;

import com.android.tools.idea.res.psi.ResourceNavigationItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyValueResourceElementWrapper
extends RenameableFakePsiElement
implements PsiTarget,
Comparable<LazyValueResourceElementWrapper> {
    private final ValueResourceInfo myResourceInfo;
    private final PsiElement myParent;

    public LazyValueResourceElementWrapper(@NotNull ValueResourceInfo resourceInfo, @NotNull PsiElement parent) {
        super(parent);
        this.myParent = parent;
        this.myResourceInfo = resourceInfo;
    }

    @NotNull
    public String getName() {
        return this.myResourceInfo.getName();
    }

    @Nullable
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        XmlAttributeValue element = this.computeElement();
        if (element == null) {
            throw new IncorrectOperationException("Cannot find resource '" + this.myResourceInfo.getName() + "' in file " + this.myResourceInfo.getContainingFile().getPath());
        }
        return new ValueResourceElementWrapper(element).setName(name);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ResourceNavigationItem.ResourceItemPresentation(this.myResourceInfo.getResource(), this.myResourceInfo.getContainingFile());
    }

    @Nullable
    public XmlAttributeValue computeElement() {
        return this.myResourceInfo.computeXmlElement();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        XmlAttributeValue element = this.myResourceInfo.computeXmlElement();
        return element != null ? element : this.myParent;
    }

    @NotNull
    public ValueResourceInfo getResourceInfo() {
        return this.myResourceInfo;
    }

    @NotNull
    public String getTypeName() {
        return "Android Value Resource";
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    public static PsiElement computeLazyElement(PsiElement element) {
        if (element instanceof LazyValueResourceElementWrapper) {
            element = ((LazyValueResourceElementWrapper)element).computeElement();
        }
        return element;
    }

    @Override
    public int compareTo(@NotNull LazyValueResourceElementWrapper other) {
        return this.myResourceInfo.compareTo(other.myResourceInfo);
    }
}

