/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.xml;

import com.android.SdkConstants;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidXmlResourcesUtil {
    @NonNls
    public static final String SEARCHABLE_TAG_NAME = "searchable";
    @NonNls
    public static final String KEYBOARD_TAG_NAME = "Keyboard";
    @NonNls
    public static final String DEVICE_ADMIN_TAG_NAME = "device-admin";
    @NonNls
    public static final String ACCOUNT_AUTHENTICATOR_TAG_NAME = "account-authenticator";
    @NonNls
    public static final String PREFERENCE_HEADERS_TAG_NAME = "preference-headers";
    public static final ImmutableMap<String, String> SPECIAL_STYLEABLE_NAMES = ImmutableMap.builder().put((Object)"appwidget-provider", (Object)"AppWidgetProviderInfo").put((Object)"searchable", (Object)"Searchable").put((Object)"actionkey", (Object)"SearchableActionKey").put((Object)"intent", (Object)"Intent").put((Object)"Keyboard", (Object)"Keyboard").put((Object)"Row", (Object)"Keyboard_Row").put((Object)"Key", (Object)"Keyboard_Key").put((Object)"device-admin", (Object)"DeviceAdmin").put((Object)"account-authenticator", (Object)"AccountAuthenticator").put((Object)"header", (Object)"PreferenceHeader").build();
    private static final ImmutableSet<String> ROOT_TAGS = ImmutableSet.of((Object)"appwidget-provider", (Object)"searchable", (Object)"Keyboard", (Object)"device-admin", (Object)"account-authenticator", (Object)"preference-headers", (Object[])new String[]{"paths"});

    private AndroidXmlResourcesUtil() {
    }

    @NotNull
    public static List<String> getPossibleRoots(@NotNull AndroidFacet facet) {
        boolean hasAndroidXClass;
        ArrayList<String> result2 = new ArrayList<String>();
        String preferencesLibName = MigrateToAndroidxUtil.getNameInProject(SdkConstants.CLASS_PREFERENCE_ANDROIDX, facet.getModule().getProject());
        boolean bl = hasAndroidXClass = JavaPsiFacade.getInstance((Project)facet.getModule().getProject()).findClass(preferencesLibName, facet.getModule().getModuleWithLibrariesScope()) != null;
        if (hasAndroidXClass) {
            result2.addAll(AndroidDomUtil.removeUnambiguousNames(AttributeProcessingUtil.getAndroidXPreferencesClassMap(facet)));
        } else {
            result2.addAll(AndroidDomUtil.removeUnambiguousNames(AttributeProcessingUtil.getFrameworkPreferencesClassMap(facet)));
        }
        result2.addAll((Collection<String>)ROOT_TAGS);
        return result2;
    }

    public static boolean isSupportedRootTag(@NotNull AndroidFacet facet, @NotNull String rootTagName) {
        return ROOT_TAGS.contains((Object)rootTagName) || LayoutViewClassUtils.findClassByTagName(facet, rootTagName, "android.preference.Preference") != null;
    }

    public static boolean isAndroidXPreferenceFile(@NotNull XmlTag tag, @NotNull AndroidFacet facet) {
        XmlTag rootTag = ((XmlFile)tag.getContainingFile()).getRootTag();
        if (rootTag == null) {
            return false;
        }
        String rootTagName = rootTag.getName();
        if (rootTagName.startsWith("androidx.")) {
            return true;
        }
        if (rootTagName.startsWith("android.")) {
            return false;
        }
        if (rootTagName.startsWith("android.support.v") && StringUtil.getPackageName((String)rootTagName).endsWith("preference")) {
            return true;
        }
        Project project = facet.getModule().getProject();
        String preferencesLibName = MigrateToAndroidxUtil.getNameInProject(SdkConstants.CLASS_PREFERENCE_ANDROIDX, project);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        if (psiFacade.findClass(preferencesLibName, rootTag.getResolveScope()) == null) {
            return false;
        }
        PsiJavaParserFacade parser = psiFacade.getParserFacade();
        try {
            PsiType type = parser.createTypeFromText(rootTagName, null);
            if (type instanceof PsiClassType && ((PsiClassType)type).resolve() != null) {
                return InheritanceUtil.isInheritor((PsiType)type, (String)preferencesLibName);
            }
        }
        catch (IncorrectOperationException e) {
            return true;
        }
        return true;
    }
}

