/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.xml;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.dom.CustomLogicResourceDomFileDescription;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlResourceDomFileDescription
extends CustomLogicResourceDomFileDescription<XmlResourceElement> {
    public XmlResourceDomFileDescription() {
        super(XmlResourceElement.class, ResourceFolderType.XML, "PreferenceScreen");
    }

    @Override
    public boolean checkFile(@NotNull XmlFile file, @Nullable Module module) {
        XmlTag rootTag = file.getRootTag();
        if (rootTag == null || !rootTag.getNamespace().isEmpty()) {
            return false;
        }
        for (XmlAttribute attribute : rootTag.getAttributes()) {
            if (!attribute.getName().equals("xmlns")) continue;
            return false;
        }
        return true;
    }

    public static boolean isXmlResourceFile(@NotNull XmlFile file) {
        return (Boolean)ReadAction.compute(() -> new XmlResourceDomFileDescription().isMyFile(file, null));
    }
}

