/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.actions.GoToApkLocationTask;
import com.android.tools.idea.gradle.actions.GoToBundleLocationTask;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleTaskFinder;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.ExportEncryptedPrivateKeyTool;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.gradle.tooling.BuildAction;
import org.jetbrains.android.AndroidCommonBundle;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.exportSignedPackage.ApkStep;
import org.jetbrains.android.exportSignedPackage.ChooseBundleOrApkStep;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.exportSignedPackage.GenerateSignedApkSettings;
import org.jetbrains.android.exportSignedPackage.GradleSignStep;
import org.jetbrains.android.exportSignedPackage.GradleSigningInfo;
import org.jetbrains.android.exportSignedPackage.KeystoreStep;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportSignedPackageWizard
extends AbstractWizard<ExportSignedPackageWizardStep> {
    public static final String BUNDLE = "bundle";
    public static final String APK = "apk";
    private static final String ENCRYPTED_PRIVATE_KEY_FILE = "private_key.pepk";
    private static final String GOOGLE_PUBLIC_KEY = "eb10fe8f7c7c9df715022017b00c6471f8ba8170b13049a11e6c09ffe3056a104a3bbe4ac5a955f4ba4fe93fc8cef27558a3eb9d2a529a2092761fb833b656cd48b9de6a";
    @NotNull
    private final Project myProject;
    private AndroidFacet myFacet;
    private PrivateKey myPrivateKey;
    private X509Certificate myCertificate;
    private boolean mySigned;
    private CompileScope myCompileScope;
    private String myApkPath;
    private boolean myV1Signature;
    private boolean myV2Signature;
    private String myExportKeyPath;
    @NotNull
    private String myTargetType = "apk";
    @NotNull
    private ExportEncryptedPrivateKeyTool myEncryptionTool;
    private boolean myExportPrivateKey;
    private List<String> myBuildVariants;
    private GradleSigningInfo myGradleSigningInfo;

    private static Logger getLog() {
        return Logger.getInstance(ExportSignedPackageWizard.class);
    }

    public ExportSignedPackageWizard(@NotNull Project project, @NotNull List<AndroidFacet> facets, boolean signed, Boolean showBundle, @NotNull ExportEncryptedPrivateKeyTool encryptionTool) {
        super(AndroidBundle.message(showBundle != false ? "android.export.package.wizard.bundle.title" : "android.export.package.wizard.title", new Object[0]), project);
        this.myProject = project;
        this.mySigned = signed;
        this.myEncryptionTool = encryptionTool;
        assert (!facets.isEmpty());
        this.myFacet = facets.get(0);
        if (showBundle.booleanValue()) {
            this.addStep((Step)new ChooseBundleOrApkStep(this));
        }
        boolean useGradleToSign = this.myFacet.requiresAndroidModel();
        if (signed) {
            this.addStep((Step)new KeystoreStep(this, useGradleToSign, facets));
        }
        if (useGradleToSign) {
            this.addStep((Step)new GradleSignStep(this));
        } else {
            this.addStep((Step)new ApkStep(this));
        }
        this.init();
    }

    public boolean isSigned() {
        return this.mySigned;
    }

    protected void doOKAction() {
        if (!this.commitCurrentStep()) {
            return;
        }
        super.doOKAction();
        assert (this.myFacet != null);
        if (this.myFacet.requiresAndroidModel()) {
            this.buildAndSignGradleProject();
        } else {
            this.buildAndSignIntellijProject();
        }
    }

    private void buildAndSignIntellijProject() {
        CompilerManager.getInstance((Project)this.myProject).make(this.myCompileScope, (aborted, errors, warnings, compileContext) -> {
            if (aborted || errors != 0) {
                return;
            }
            String title = AndroidBundle.message("android.extract.package.task.title", new Object[0]);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title, true, null){

                public void run(@NotNull ProgressIndicator indicator) {
                    ExportSignedPackageWizard.this.createAndAlignApk(ExportSignedPackageWizard.this.myApkPath);
                }
            });
        });
    }

    private void buildAndSignGradleProject() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Generating Signed APKs", false, null){

            public void run(@NotNull ProgressIndicator indicator) {
                GradleFacet gradleFacet = GradleFacet.getInstance(ExportSignedPackageWizard.this.myFacet.getModule());
                if (gradleFacet == null) {
                    ExportSignedPackageWizard.getLog().error("Unable to get gradle project information for module: " + ExportSignedPackageWizard.this.myFacet.getModule().getName());
                    return;
                }
                String gradleProjectPath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)ExportSignedPackageWizard.this.myFacet.getModule());
                if (StringUtil.isEmpty((String)rootProjectPath)) {
                    ExportSignedPackageWizard.getLog().error("Unable to get gradle root project path for module: " + ExportSignedPackageWizard.this.myFacet.getModule().getName());
                    return;
                }
                AndroidModuleModel androidModel = AndroidModuleModel.get(ExportSignedPackageWizard.this.myFacet);
                if (androidModel == null) {
                    ExportSignedPackageWizard.getLog().error("Unable to obtain Android project model. Did the last Gradle sync complete successfully?");
                    return;
                }
                if (ExportSignedPackageWizard.this.myBuildVariants == null) {
                    ExportSignedPackageWizard.getLog().error("Unable to find required information. Please check the previous steps are completed.");
                    return;
                }
                List<String> gradleTasks = ExportSignedPackageWizard.getGradleTasks(gradleProjectPath, androidModel, ExportSignedPackageWizard.this.myBuildVariants, ExportSignedPackageWizard.this.myTargetType);
                ArrayList projectProperties = Lists.newArrayList();
                projectProperties.add(this.createProperty("android.injected.signing.store.file", ((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyStoreFilePath));
                projectProperties.add(this.createProperty("android.injected.signing.store.password", new String(((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyStorePassword)));
                projectProperties.add(this.createProperty("android.injected.signing.key.alias", ((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyAlias));
                projectProperties.add(this.createProperty("android.injected.signing.key.password", new String(((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyPassword)));
                projectProperties.add(this.createProperty("android.injected.apk.location", ExportSignedPackageWizard.this.myApkPath));
                projectProperties.add(this.createProperty("android.injected.signing.v1-enabled", Boolean.toString(ExportSignedPackageWizard.this.myV1Signature)));
                projectProperties.add(this.createProperty("android.injected.signing.v2-enabled", Boolean.toString(ExportSignedPackageWizard.this.myV2Signature)));
                assert (this.myProject != null);
                GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(this.myProject);
                ImmutableList modules = ImmutableList.of((Object)ExportSignedPackageWizard.this.myFacet.getModule());
                if (ExportSignedPackageWizard.this.myTargetType.equals(ExportSignedPackageWizard.BUNDLE)) {
                    File exportedKeyFile = null;
                    if (ExportSignedPackageWizard.this.myExportPrivateKey) {
                        exportedKeyFile = ExportSignedPackageWizard.this.generatePrivateKeyPath();
                        try {
                            ExportSignedPackageWizard.this.myEncryptionTool.run(((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyStoreFilePath, ((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyAlias, ExportSignedPackageWizard.GOOGLE_PUBLIC_KEY, exportedKeyFile.getPath(), ((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyStorePassword, ((ExportSignedPackageWizard)ExportSignedPackageWizard.this).myGradleSigningInfo.keyPassword);
                            GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(this.myProject);
                            settings.EXPORT_PRIVATE_KEY = false;
                        }
                        catch (Exception e) {
                            ExportSignedPackageWizard.getLog().error("Something went wrong with the encryption tool", (Throwable)e);
                            return;
                        }
                    }
                    gradleBuildInvoker.add(new GoToBundleLocationTask(this.myProject, (Collection<Module>)modules, "Generate Signed Bundle", ExportSignedPackageWizard.this.myBuildVariants, exportedKeyFile, ExportSignedPackageWizard.this.myApkPath));
                } else {
                    gradleBuildInvoker.add(new GoToApkLocationTask(this.myProject, (Collection<Module>)modules, "Generate Signed APK", ExportSignedPackageWizard.this.myBuildVariants, ExportSignedPackageWizard.this.myApkPath));
                }
                gradleBuildInvoker.executeTasks(new File(rootProjectPath), gradleTasks, (List<String>)projectProperties, (BuildAction)new OutputBuildAction(ExportSignedPackageWizard.getModuleGradlePaths(ExportSignedPackageWizard.this.myFacet.getModule())));
                ExportSignedPackageWizard.getLog().info("Export " + ExportSignedPackageWizard.this.myTargetType.toUpperCase() + " command: " + Joiner.on((char)',').join(gradleTasks) + ", destination: " + this.createProperty("android.injected.apk.location", ExportSignedPackageWizard.this.myApkPath));
            }

            private String createProperty(@NotNull String name, @NotNull String value2) {
                return AndroidGradleSettings.createProjectProperty((String)name, (String)value2);
            }
        });
    }

    @NotNull
    private static List<String> getModuleGradlePaths(@NotNull Module module) {
        ArrayList<String> gradlePaths = new ArrayList<String>();
        String gradlePath = GradleUtil.getGradlePath(module);
        if (gradlePath != null) {
            gradlePaths.add(gradlePath);
        }
        return gradlePaths;
    }

    @NotNull
    public static File getApkLocation(@NotNull String apkFolderPath, @NotNull String buildType) {
        return new File(apkFolderPath, buildType);
    }

    @NotNull
    public static List<String> getGradleTasks(@NotNull String gradleProjectPath, @NotNull AndroidModuleModel androidModuleModel, @NotNull List<String> buildVariants, @NotNull String targetType) {
        ArrayList gradleTasks = Lists.newArrayListWithExpectedSize((int)buildVariants.size());
        IdeVariant selectedVariant = androidModuleModel.getSelectedVariant();
        String selectedTaskName = ExportSignedPackageWizard.getTaskName((Variant)selectedVariant, targetType);
        String selectedVariantName = selectedVariant.getName();
        if (selectedTaskName == null) {
            ExportSignedPackageWizard.getLog().warn("Could not get tasks for target " + targetType + " on variant " + selectedVariantName);
            return Collections.emptyList();
        }
        for (String variantName : buildVariants) {
            String taskName = ExportSignedPackageWizard.replaceVariantFromTask(selectedTaskName, selectedVariantName, variantName);
            if (taskName != null) {
                gradleTasks.add(GradleTaskFinder.getInstance().createBuildTask(gradleProjectPath, taskName));
                continue;
            }
            ExportSignedPackageWizard.getLog().warn("Could not replace variant " + selectedVariantName + " with " + variantName + " for task " + selectedTaskName + ".");
        }
        return gradleTasks;
    }

    @Nullable
    public static String replaceVariantFromTask(@NotNull String task, @NotNull String oldVariant, @NotNull String newVariant) {
        if (task.indexOf(oldVariant = StringUtil.decapitalize((String)oldVariant)) == 1) {
            newVariant = StringUtil.decapitalize((String)newVariant);
            return task.replaceFirst(oldVariant, newVariant);
        }
        if (task.contains(oldVariant = StringUtil.capitalize((String)oldVariant))) {
            newVariant = StringUtil.capitalize((String)newVariant);
            return task.replaceFirst(oldVariant, newVariant);
        }
        return null;
    }

    private static String getTaskName(Variant v, String targetType) {
        if (targetType.equals(BUNDLE)) {
            return v.getMainArtifact().getBundleTaskName();
        }
        return v.getMainArtifact().getAssembleTaskName();
    }

    protected void doNextAction() {
        if (!this.commitCurrentStep()) {
            return;
        }
        super.doNextAction();
    }

    private boolean commitCurrentStep() {
        try {
            ((ExportSignedPackageWizardStep)((Object)this.mySteps.get(this.myCurrentStep))).commitForNext();
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage());
            return false;
        }
        return true;
    }

    protected int getNextStep(int stepIndex) {
        int result2 = super.getNextStep(stepIndex);
        if (result2 != this.myCurrentStep) {
            ((ExportSignedPackageWizardStep)((Object)this.mySteps.get(result2))).setPreviousStepIndex(this.myCurrentStep);
        }
        return result2;
    }

    protected int getPreviousStep(int stepIndex) {
        ExportSignedPackageWizardStep step = (ExportSignedPackageWizardStep)((Object)this.mySteps.get(stepIndex));
        int prevStepIndex = step.getPreviousStepIndex();
        assert (prevStepIndex >= 0);
        return prevStepIndex;
    }

    protected void updateStep() {
        int step = this.getCurrentStep();
        ExportSignedPackageWizardStep currentStep = (ExportSignedPackageWizardStep)((Object)this.mySteps.get(step));
        this.getFinishButton().setEnabled(currentStep.canFinish());
        super.updateStep();
        UIUtil.invokeLaterIfNeeded(() -> {
            this.getRootPane().setDefaultButton(this.getNextButton());
            JComponent component = currentStep.getPreferredFocusedComponent();
            if (component != null) {
                component.requestFocus();
            }
        });
    }

    protected String getHelpID() {
        ExportSignedPackageWizardStep step = (ExportSignedPackageWizardStep)this.getCurrentStepObject();
        if (step != null) {
            return step.getHelpId();
        }
        return null;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public void setFacet(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    public void setPrivateKey(@NotNull PrivateKey privateKey) {
        this.myPrivateKey = privateKey;
    }

    public void setCertificate(@NotNull X509Certificate certificate) {
        this.myCertificate = certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.myPrivateKey;
    }

    public X509Certificate getCertificate() {
        return this.myCertificate;
    }

    public void setCompileScope(@NotNull CompileScope compileScope) {
        this.myCompileScope = compileScope;
    }

    public void setApkPath(@NotNull String apkPath) {
        this.myApkPath = apkPath;
    }

    public void setV1Signature(boolean v1Signature) {
        this.myV1Signature = v1Signature;
    }

    public void setV2Signature(boolean v2Signature) {
        this.myV2Signature = v2Signature;
    }

    public void setGradleOptions(@NotNull List<String> buildVariants) {
        this.myBuildVariants = buildVariants;
    }

    public void setTargetType(@NotNull String targetType) {
        this.myTargetType = targetType;
    }

    @NotNull
    public String getTargetType() {
        return this.myTargetType;
    }

    private void createAndAlignApk(String apkPath) {
        File realDestFile;
        String message2;
        BuildToolInfo buildTool;
        AndroidPlatform platform = ((AndroidFacetConfiguration)this.getFacet().getConfiguration()).getAndroidPlatform();
        assert (platform != null);
        String sdkPath = platform.getSdkData().getLocation().getPath();
        String zipAlignPath = AndroidCommonUtils.getZipAlign((String)sdkPath, (IAndroidTarget)platform.getTarget());
        File zipalign = new File(zipAlignPath);
        if (!zipalign.isFile() && (buildTool = platform.getTarget().getBuildToolInfo()) != null) {
            zipAlignPath = buildTool.getPath(BuildToolInfo.PathId.ZIP_ALIGN);
            zipalign = new File(zipAlignPath);
        }
        boolean runZipAlign = zipalign.isFile();
        File destFile = null;
        try {
            destFile = runZipAlign ? FileUtil.createTempFile((String)"android", (String)".apk") : new File(apkPath);
            this.createApk(destFile);
        }
        catch (Exception e) {
            this.showErrorInDispatchThread(e.getMessage());
        }
        if (destFile == null) {
            return;
        }
        if (runZipAlign && (message2 = AndroidCommonUtils.executeZipAlign((String)zipAlignPath, (File)destFile, (File)(realDestFile = new File(apkPath)))) != null) {
            this.showErrorInDispatchThread(message2);
            return;
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            String title = AndroidBundle.message("android.export.package.wizard.title", new Object[0]);
            Project project = this.getProject();
            File apkFile = new File(apkPath);
            VirtualFile vApkFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(apkFile);
            if (vApkFile != null) {
                vApkFile.refresh(true, false);
            }
            if (!runZipAlign) {
                Messages.showWarningDialog((Project)project, (String)AndroidCommonBundle.message((String)"android.artifact.building.cannot.find.zip.align.error", (Object[])new Object[0]), (String)title);
            }
            if (ShowFilePathAction.isSupported()) {
                if (Messages.showOkCancelDialog((Project)project, (String)AndroidBundle.message("android.export.package.success.message", apkFile.getName()), (String)title, (String)RevealFileAction.getActionName(), (String)IdeBundle.message((String)"action.close", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()) == 0) {
                    ShowFilePathAction.openFile((File)apkFile);
                }
            } else {
                Messages.showInfoMessage((Project)project, (String)AndroidBundle.message("android.export.package.success.message", apkFile), (String)title);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private void createApk(@NotNull File destFile) throws IOException, GeneralSecurityException {
        String srcApkPath = AndroidCompileUtil.getUnsignedApkPath(this.getFacet());
        assert (srcApkPath != null);
        File srcApk = new File(FileUtil.toSystemDependentName((String)srcApkPath));
        if (this.isSigned()) {
            AndroidCommonUtils.signApk((File)srcApk, (File)destFile, (PrivateKey)this.getPrivateKey(), (X509Certificate)this.getCertificate());
        } else {
            FileUtil.copy((File)srcApk, (File)destFile);
        }
    }

    @NotNull
    private File generatePrivateKeyPath() {
        return new File(this.myExportKeyPath, ENCRYPTED_PRIVATE_KEY_FILE);
    }

    private void showErrorInDispatchThread(@NotNull String message2) {
        UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.getProject(), (String)("Error: " + message2), (String)CommonBundle.getErrorTitle()));
    }

    public void setGradleSigningInfo(GradleSigningInfo gradleSigningInfo) {
        this.myGradleSigningInfo = gradleSigningInfo;
    }

    public void setExportPrivateKey(boolean exportPrivateKey) {
        this.myExportPrivateKey = exportPrivateKey;
    }

    public void setExportKeyPath(@NotNull String exportKeyPath) {
        this.myExportKeyPath = exportKeyPath;
    }
}

