/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import java.util.List;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.facet.LegacySourceProvider;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidFacet
extends Facet<AndroidFacetConfiguration> {
    public static final FacetTypeId<AndroidFacet> ID = new FacetTypeId("android");
    public static final String NAME = "Android";
    private SourceProvider myMainSourceSet;
    private IdeaSourceProvider myMainIdeaSourceSet;

    @Nullable
    public static AndroidFacet getInstance(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        return (AndroidFacet)modelsProvider.getModifiableFacetModel(module).getFacetByType(ID);
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull VirtualFile file, @NotNull Project project) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return null;
        }
        return AndroidFacet.getInstance(module);
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull ConvertContext context) {
        return AndroidFacet.findAndroidFacet(context.getModule());
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull PsiElement element) {
        return AndroidFacet.findAndroidFacet(AndroidPsiUtils.getModuleSafely(element));
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull DomElement element) {
        return AndroidFacet.findAndroidFacet(element.getModule());
    }

    @Nullable
    private static AndroidFacet findAndroidFacet(@Nullable Module module) {
        return module != null ? AndroidFacet.getInstance(module) : null;
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull Module module) {
        return !module.isDisposed() ? (AndroidFacet)FacetManager.getInstance((Module)module).getFacetByType(ID) : null;
    }

    public AndroidFacet(@NotNull Module module, @NotNull String name, @NotNull AndroidFacetConfiguration configuration) {
        super((FacetType)AndroidFacet.getFacetType(), module, name, (FacetConfiguration)configuration, null);
        configuration.setFacet(this);
    }

    public boolean requiresAndroidModel() {
        return !this.getProperties().ALLOW_USER_CONFIGURATION && ApkFacet.getInstance(this.getModule()) == null;
    }

    @NotNull
    public SourceProvider getMainSourceProvider() {
        AndroidModel model2 = ((AndroidFacetConfiguration)this.getConfiguration()).getModel();
        if (model2 != null) {
            return model2.getDefaultSourceProvider();
        }
        if (this.myMainSourceSet == null) {
            this.myMainSourceSet = new LegacySourceProvider(this);
        }
        return this.myMainSourceSet;
    }

    @NotNull
    public IdeaSourceProvider getMainIdeaSourceProvider() {
        if (!this.requiresAndroidModel()) {
            if (this.myMainIdeaSourceSet == null) {
                this.myMainIdeaSourceSet = IdeaSourceProvider.createForLegacyProject(this);
            }
        } else {
            SourceProvider mainSourceSet = this.getMainSourceProvider();
            if (this.myMainIdeaSourceSet == null || mainSourceSet != this.myMainSourceSet) {
                this.myMainIdeaSourceSet = IdeaSourceProvider.create(mainSourceSet);
            }
        }
        return this.myMainIdeaSourceSet;
    }

    @Deprecated
    @NotNull
    public List<VirtualFile> getAllResourceDirectories() {
        return ResourceFolderManager.getInstance(this).getFolders();
    }

    public void disposeFacet() {
        ((AndroidFacetConfiguration)this.getConfiguration()).disposeFacet();
    }

    @Nullable
    public VirtualFile getManifestFile() {
        if (this.isDisposed()) {
            return null;
        }
        return this.getMainIdeaSourceProvider().getManifestFile();
    }

    @Nullable
    public Manifest getManifest() {
        VirtualFile manifestFile = this.getManifestFile();
        return manifestFile != null ? AndroidUtils.loadDomElement(this.getModule(), manifestFile, Manifest.class) : null;
    }

    @NotNull
    public static AndroidFacetType getFacetType() {
        return (AndroidFacetType)FacetTypeRegistry.getInstance().findFacetType(ID);
    }

    @NotNull
    public JpsAndroidModuleProperties getProperties() {
        JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)this.getConfiguration()).getState();
        assert (state != null);
        return state;
    }
}

