/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetEditorTab;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidNativeLibData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.AndroidImportableProperty;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidFacetConfiguration
implements FacetConfiguration,
PersistentStateComponent<JpsAndroidModuleProperties> {
    private static final FacetEditorTab[] NO_EDITOR_TABS = new FacetEditorTab[0];
    private AndroidFacet myFacet = null;
    private JpsAndroidModuleProperties myProperties = new JpsAndroidModuleProperties();
    @Nullable
    private AndroidModel myAndroidModel;

    public void init(@NotNull Module module, @NotNull VirtualFile contentRoot) {
        this.init(module, contentRoot.getPath());
    }

    public void init(@NotNull Module module, @NotNull String baseDirectoryPath) {
        String s = AndroidRootUtil.getPathRelativeToModuleDir(module, baseDirectoryPath);
        if (s == null || s.isEmpty()) {
            return;
        }
        this.myProperties.GEN_FOLDER_RELATIVE_PATH_APT = '/' + s + this.myProperties.GEN_FOLDER_RELATIVE_PATH_APT;
        this.myProperties.GEN_FOLDER_RELATIVE_PATH_AIDL = '/' + s + this.myProperties.GEN_FOLDER_RELATIVE_PATH_AIDL;
        this.myProperties.MANIFEST_FILE_RELATIVE_PATH = '/' + s + this.myProperties.MANIFEST_FILE_RELATIVE_PATH;
        this.myProperties.RES_FOLDER_RELATIVE_PATH = '/' + s + this.myProperties.RES_FOLDER_RELATIVE_PATH;
        this.myProperties.ASSETS_FOLDER_RELATIVE_PATH = '/' + s + this.myProperties.ASSETS_FOLDER_RELATIVE_PATH;
        this.myProperties.LIBS_FOLDER_RELATIVE_PATH = '/' + s + this.myProperties.LIBS_FOLDER_RELATIVE_PATH;
        this.myProperties.PROGUARD_LOGS_FOLDER_RELATIVE_PATH = '/' + s + this.myProperties.PROGUARD_LOGS_FOLDER_RELATIVE_PATH;
        for (int i2 = 0; i2 < this.myProperties.RES_OVERLAY_FOLDERS.size(); ++i2) {
            this.myProperties.RES_OVERLAY_FOLDERS.set(i2, '/' + s + (String)this.myProperties.RES_OVERLAY_FOLDERS.get(i2));
        }
    }

    @Nullable
    public AndroidPlatform getAndroidPlatform() {
        return AndroidPlatform.getInstance(this.myFacet.getModule());
    }

    @Nullable
    public AndroidSdkData getAndroidSdk() {
        AndroidPlatform platform = this.getAndroidPlatform();
        return platform != null ? platform.getSdkData() : null;
    }

    @Nullable
    public IAndroidTarget getAndroidTarget() {
        AndroidPlatform platform = this.getAndroidPlatform();
        return platform != null ? platform.getTarget() : null;
    }

    public void setFacet(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
        ((FacetManagerListener)facet.getModule().getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged((Facet)facet);
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        JpsAndroidModuleProperties state = this.getState();
        assert (state != null);
        if (state.ALLOW_USER_CONFIGURATION) {
            return new FacetEditorTab[]{new AndroidFacetEditorTab(editorContext, this)};
        }
        return NO_EDITOR_TABS;
    }

    public void readExternal(Element element) throws InvalidDataException {
    }

    public void writeExternal(Element element) throws WriteExternalException {
    }

    public void setAdditionalNativeLibraries(@NotNull List<AndroidNativeLibData> additionalNativeLibraries) {
        this.myProperties.myNativeLibs = new ArrayList(additionalNativeLibraries.size());
        for (AndroidNativeLibData lib : additionalNativeLibraries) {
            JpsAndroidModuleProperties.AndroidNativeLibDataEntry data = new JpsAndroidModuleProperties.AndroidNativeLibDataEntry();
            data.myArchitecture = lib.getArchitecture();
            data.myUrl = VfsUtilCore.pathToUrl((String)lib.getPath());
            data.myTargetFileName = lib.getTargetFileName();
            this.myProperties.myNativeLibs.add(data);
        }
    }

    public boolean isImportedProperty(@NotNull AndroidImportableProperty property2) {
        return !this.myProperties.myNotImportedProperties.contains(property2);
    }

    public boolean isIncludeAssetsFromLibraries() {
        return this.myProperties.myIncludeAssetsFromLibraries;
    }

    public void setIncludeAssetsFromLibraries(boolean includeAssetsFromLibraries) {
        this.myProperties.myIncludeAssetsFromLibraries = includeAssetsFromLibraries;
    }

    public boolean isAppProject() {
        int projectType = this.getState().PROJECT_TYPE;
        return projectType == 0 || projectType == 4;
    }

    public boolean isAppOrFeature() {
        int projectType = this.getState().PROJECT_TYPE;
        return projectType == 0 || projectType == 4 || projectType == 5 || projectType == 6;
    }

    @Nullable
    public JpsAndroidModuleProperties getState() {
        return this.myProperties;
    }

    public void loadState(@NotNull JpsAndroidModuleProperties properties) {
        this.myProperties = properties;
    }

    public boolean canBeDependency() {
        int projectType = this.getState().PROJECT_TYPE;
        return projectType == 1 || projectType == 5;
    }

    public void setModel(@Nullable AndroidModel model2) {
        this.myAndroidModel = model2;
        if (this.myFacet != null) {
            ((FacetManagerListener)this.myFacet.getModule().getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged((Facet)this.myFacet);
        }
    }

    @Nullable
    public AndroidModel getModel() {
        return this.myAndroidModel;
    }

    public void disposeFacet() {
        this.myAndroidModel = null;
    }

    public boolean isLibraryProject() {
        return this.getState().PROJECT_TYPE == 1;
    }

    public int getProjectType() {
        return this.getState().PROJECT_TYPE;
    }

    public void setProjectType(int type) {
        this.getState().PROJECT_TYPE = type;
    }
}

