/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AndroidSourceType {
    MANIFEST("manifest", IdeaSourceProvider.MANIFEST_PROVIDER, AllIcons.Modules.SourceRoot),
    JAVA("java", IdeaSourceProvider.JAVA_PROVIDER, AllIcons.Modules.SourceRoot),
    GENERATED_JAVA(JAVA.getName(), null, AllIcons.Modules.GeneratedSourceRoot, true),
    CPP("cpp", IdeaSourceProvider.JNI_PROVIDER, AllIcons.Modules.SourceRoot),
    AIDL("aidl", IdeaSourceProvider.AIDL_PROVIDER, AllIcons.Modules.SourceRoot),
    RENDERSCRIPT("renderscript", IdeaSourceProvider.RENDERSCRIPT_PROVIDER, AllIcons.Modules.SourceRoot),
    SHADERS("shaders", IdeaSourceProvider.SHADERS_PROVIDER, AllIcons.Modules.SourceRoot),
    ASSETS("assets", IdeaSourceProvider.ASSETS_PROVIDER, AllIcons.Modules.ResourcesRoot),
    JNILIBS("jniLibs", IdeaSourceProvider.JNI_LIBS_PROVIDER, AllIcons.Modules.ResourcesRoot),
    RES("res", IdeaSourceProvider.RES_PROVIDER, AllIcons.Modules.ResourcesRoot),
    GENERATED_RES(RES.getName(), IdeaSourceProvider.RES_PROVIDER, AllIcons.Modules.ResourcesRoot, true),
    RESOURCES("resources", IdeaSourceProvider.RESOURCES_PROVIDER, AllIcons.Modules.ResourcesRoot);

    private final String myName;
    private final Function<IdeaSourceProvider, List<VirtualFile>> mySourceExtractor;
    private final Icon myIcon;
    private final boolean myGenerated;

    private AndroidSourceType(@NotNull String name, Function<IdeaSourceProvider, List<VirtualFile>> sourceExtractor, Icon icon2) {
        this(name, sourceExtractor, icon2, false);
    }

    private AndroidSourceType(@NotNull String name, Function<IdeaSourceProvider, List<VirtualFile>> sourceExtractor, Icon icon2, boolean generated) {
        this.myName = name;
        this.mySourceExtractor = sourceExtractor;
        this.myIcon = icon2;
        this.myGenerated = generated;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<VirtualFile> getSources(IdeaSourceProvider provider) {
        if (this.mySourceExtractor == null) {
            return Collections.emptyList();
        }
        List<VirtualFile> files2 = this.mySourceExtractor.apply(provider);
        return files2 == null ? Collections.emptyList() : files2;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public boolean isGenerated() {
        return this.myGenerated;
    }
}

