/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.tools.idea.lint.LintIdeUtils;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageFeatureProvider;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;

public class AndroidLanguageFeatureProvider
implements LanguageFeatureProvider {
    @NotNull
    public ThreeState isFeatureSupported(@NotNull JavaFeature feature, @NotNull PsiFile file) {
        if (JavaFeature.MULTI_CATCH == feature) {
            return ThreeState.fromBoolean((boolean)LintIdeUtils.isApiLevelAtLeast(file, 19, true));
        }
        if (JavaFeature.STREAMS == feature || JavaFeature.ADVANCED_COLLECTIONS_API == feature) {
            return ThreeState.fromBoolean((boolean)LintIdeUtils.isApiLevelAtLeast(file, 24, true));
        }
        if (JavaFeature.THREAD_LOCAL_WITH_INITIAL == feature) {
            return ThreeState.fromBoolean((boolean)LintIdeUtils.isApiLevelAtLeast(file, 26, true));
        }
        return ThreeState.UNSURE;
    }
}

