/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.AndroidGotoRelatedProvider;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.menu.MenuDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.intentions.AndroidCreateOnClickHandlerAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidMissingOnClickHandlerInspection
extends LocalInspectionTool {
    @NotNull
    private static Collection<PsiClass> findRelatedActivities(@NotNull XmlFile file, @NotNull AndroidFacet facet, @NotNull DomFileDescription<?> description) {
        if (description instanceof LayoutDomFileDescription) {
            Computable<List<GotoRelatedItem>> computable = AndroidGotoRelatedProvider.getLazyItemsForXmlFile(file, facet);
            if (computable == null) {
                return Collections.emptyList();
            }
            List items2 = (List)computable.compute();
            if (items2.isEmpty()) {
                return Collections.emptyList();
            }
            PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(facet.getModule());
            if (activityClass == null) {
                return Collections.emptyList();
            }
            ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
            for (GotoRelatedItem item : items2) {
                PsiClass aClass;
                PsiElement element = item.getElement();
                if (!(element instanceof PsiClass) || !(aClass = (PsiClass)element).isInheritor(activityClass, true)) continue;
                result2.add(aClass);
            }
            return result2;
        }
        return AndroidMissingOnClickHandlerInspection.findRelatedActivitiesForMenu(file, facet);
    }

    @NotNull
    private static Set<PsiClass> findRelatedActivitiesForMenu(@NotNull XmlFile file, @NotNull AndroidFacet facet) {
        String resourceName;
        String resType = ResourceType.MENU.getName();
        PsiField[] fields = AndroidResourceUtil.findResourceFields(facet, resType, resourceName = AndroidCommonUtils.getResourceName((String)resType, (String)file.getName()), true);
        if (fields.length == 0) {
            return Collections.emptySet();
        }
        Module module = facet.getModule();
        GlobalSearchScope scope = module.getModuleScope(false);
        PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(module);
        if (activityClass == null) {
            return Collections.emptySet();
        }
        HashSet result2 = new HashSet();
        ReferencesSearch.search((PsiElement)fields[0], (SearchScope)scope).forEach((Processor)new Processor<PsiReference>((Set)result2, activityClass){
            final /* synthetic */ Set val$result;
            final /* synthetic */ PsiClass val$activityClass;
            {
                this.val$result = set;
                this.val$activityClass = psiClass;
            }

            public boolean process(PsiReference reference2) {
                PsiElement element = reference2.getElement();
                if (element == null) {
                    return true;
                }
                PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                if (aClass != null && !this.val$result.contains(aClass) && aClass.isInheritor(this.val$activityClass, true)) {
                    this.val$result.add(aClass);
                }
                return true;
            }
        });
        return result2;
    }

    @Nullable
    public static PsiClass findActivityClass(@NotNull Module module) {
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("android.app.Activity", module.getModuleWithDependenciesAndLibrariesScope(false));
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!(file instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DomFileDescription description = DomManager.getDomManager((Project)file.getProject()).getDomFileDescription((XmlFile)file);
        if (!(description instanceof LayoutDomFileDescription) && !(description instanceof MenuDomFileDescription)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Collection<PsiClass> activities = AndroidMissingOnClickHandlerInspection.findRelatedActivities((XmlFile)file, facet, description);
        MyVisitor visitor = new MyVisitor(manager, isOnTheFly, activities);
        file.accept((PsiElementVisitor)visitor);
        return visitor.myResult.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    public static class MyQuickFix
    extends AbstractIntentionAction
    implements LocalQuickFix {
        private final String myMethodName;
        private final OnClickConverter myConverter;
        private final PsiClass myClass;

        private MyQuickFix(@NotNull String methodName, @NotNull OnClickConverter converter, @NotNull PsiClass aClass) {
            this.myMethodName = methodName;
            this.myConverter = converter;
            this.myClass = aClass;
        }

        @NotNull
        public String getFamilyName() {
            return "Create '" + this.myMethodName + "(" + this.myConverter.getShortParameterName() + ")' in '" + this.myClass.getName() + "'";
        }

        @NotNull
        public String getText() {
            return this.getName();
        }

        public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
            String paramType = this.myConverter.getDefaultMethodParameterType(this.myClass);
            AndroidCreateOnClickHandlerAction.addHandlerMethodAndNavigate(project, this.myClass, this.myMethodName, paramType);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            this.doApplyFix(project);
        }

        public void doApplyFix(@NotNull Project project) {
            String paramType = this.myConverter.getDefaultMethodParameterType(this.myClass);
            AndroidCreateOnClickHandlerAction.addHandlerMethod(project, this.myClass, this.myMethodName, paramType);
        }
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        private final Collection<PsiClass> myRelatedActivities;
        final List<ProblemDescriptor> myResult = new ArrayList<ProblemDescriptor>();

        private MyVisitor(@NotNull InspectionManager inspectionManager, boolean onTheFly, @NotNull Collection<PsiClass> relatedActivities) {
            this.myInspectionManager = inspectionManager;
            this.myOnTheFly = onTheFly;
            this.myRelatedActivities = relatedActivities;
        }

        public void visitXmlAttributeValue(XmlAttributeValue value2) {
            for (PsiReference reference2 : value2.getReferences()) {
                OnClickConverter.MyReference ref;
                String methodName;
                if (!(reference2 instanceof OnClickConverter.MyReference) || (methodName = (ref = (OnClickConverter.MyReference)reference2).getValue()).isEmpty()) continue;
                ResolveResult[] results = ref.multiResolve(false);
                HashSet resolvedClasses = new HashSet();
                HashSet resolvedClassesWithMistake = new HashSet();
                for (ResolveResult result2 : results) {
                    PsiClass aClass;
                    PsiElement element;
                    if (!(result2 instanceof OnClickConverter.MyResolveResult) || (element = result2.getElement()) == null || (aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) == null) continue;
                    resolvedClasses.add(aClass);
                    if (((OnClickConverter.MyResolveResult)result2).hasCorrectSignature()) continue;
                    resolvedClassesWithMistake.add(aClass);
                }
                PsiClass activity = null;
                for (PsiClass relatedActivity : this.myRelatedActivities) {
                    if (!MyVisitor.containsOrExtends((Set<PsiClass>)resolvedClasses, relatedActivity)) {
                        activity = relatedActivity;
                        break;
                    }
                    if (activity != null || !MyVisitor.containsOrExtends((Set<PsiClass>)resolvedClassesWithMistake, relatedActivity)) continue;
                    activity = relatedActivity;
                }
                if (activity != null) {
                    this.reportMissingOnClickProblem(ref, activity, methodName, resolvedClassesWithMistake.contains(activity));
                    continue;
                }
                if (results.length == 0) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor((PsiElement)value2, reference2.getRangeInElement(), ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference2), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]));
                    continue;
                }
                if (resolvedClassesWithMistake.isEmpty()) continue;
                this.reportMissingOnClickProblem(ref, (PsiClass)resolvedClassesWithMistake.iterator().next(), methodName, true);
            }
        }

        private static boolean containsOrExtends(@NotNull Set<PsiClass> resolvedClasses, @NotNull PsiClass relatedActivity) {
            if (resolvedClasses.contains(relatedActivity)) {
                return true;
            }
            for (PsiClass resolvedClass : resolvedClasses) {
                if (!relatedActivity.isInheritor(resolvedClass, false)) continue;
                return true;
            }
            return false;
        }

        private void reportMissingOnClickProblem(OnClickConverter.MyReference reference2, PsiClass activity, String methodName, boolean incorrectSignature) {
            LocalQuickFix[] localQuickFixArray;
            String message2;
            String activityName = activity.getName();
            if (activityName == null) {
                activityName = "";
            }
            String string = message2 = incorrectSignature ? AndroidBundle.message("android.inspections.on.click.missing.incorrect.signature", methodName, activityName) : AndroidBundle.message("android.inspections.on.click.missing.problem", methodName, activityName);
            if (StringUtil.isJavaIdentifier((String)methodName)) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new MyQuickFix(methodName, reference2.getConverter(), activity);
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.myResult.add(this.myInspectionManager.createProblemDescriptor(reference2.getElement(), reference2.getRangeInElement(), message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, fixes));
        }
    }
}

