/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.SdkConstants;
import com.android.resources.ResourceType;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInspection.magicConstant.MagicCompletionContributor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceTypeCompletionContributor
extends CompletionContributor {
    private static final int PRIORITY = 100;

    public void fillCompletionVariants(final @NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        PsiElement pos = parameters2.getPosition();
        if (JavaKeywordCompletion.AFTER_DOT.accepts((Object)pos)) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(pos);
        if (facet == null) {
            return;
        }
        Constraints allowedValues = ResourceTypeCompletionContributor.getAllowedValues(pos);
        if (allowedValues == null) {
            return;
        }
        THashSet allowed = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<PsiElement>(){

            public int computeHashCode(PsiElement object) {
                return 0;
            }

            public boolean equals(PsiElement o1, PsiElement o2) {
                return parameters2.getOriginalFile().getManager().areElementsEquivalent(o1, o2);
            }
        });
        if (allowedValues instanceof ResourceTypeAllowedValues) {
            for (ResourceType resourceType : ((ResourceTypeAllowedValues)allowedValues).types) {
                if (resourceType == ResourceEvaluator.COLOR_INT_MARKER_TYPE || resourceType == ResourceEvaluator.DIMENSION_MARKER_TYPE) continue;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)pos.getProject());
                String code = "R." + resourceType.getName();
                String fqcn = MergedManifestManager.getSnapshot(facet).getPackage();
                String qualifiedCode = fqcn + "." + code;
                Project project = facet.getModule().getProject();
                PsiClass cls = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedCode, GlobalSearchScope.allScope((Project)project));
                if (cls != null) {
                    result2.addElement((LookupElement)new JavaPsiClassReferenceElement(cls));
                    continue;
                }
                PsiExpression type = factory.createExpressionFromText(code, pos);
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)type, (String)code), (double)99.0));
                allowed.add(type);
            }
        } else if (allowedValues instanceof AllowedValues) {
            AllowedValues a = (AllowedValues)allowedValues;
            if (a.canBeOred) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)pos.getProject());
                PsiExpression zero = factory.createExpressionFromText("0", pos);
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)zero, (String)"0"), (double)99.0));
                PsiExpression minusOne = factory.createExpressionFromText("-1", pos);
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)minusOne, (String)"-1"), (double)99.0));
                allowed.add(zero);
                allowed.add(minusOne);
            }
            List<ExpectedTypeInfo> types = Arrays.asList(JavaSmartCompletionContributor.getExpectedTypes((CompletionParameters)parameters2));
            for (PsiAnnotationMemberValue value2 : a.values) {
                PsiElement resolved;
                if (value2 instanceof PsiReference && (resolved = ((PsiReference)value2).resolve()) instanceof PsiNamedElement) {
                    LookupElement lookupElement = LookupItemUtil.objectToLookupItem((Object)resolved);
                    if (lookupElement instanceof VariableLookupItem) {
                        ((VariableLookupItem)lookupElement).setSubstitutor(PsiSubstitutor.EMPTY);
                    }
                    LookupElement element = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)100.0);
                    element = ResourceTypeCompletionContributor.decorate(parameters2, types, element);
                    result2.addElement(element);
                    allowed.add(resolved);
                    continue;
                }
                LookupElementBuilder element = LookupElementBuilder.create((Object)value2, (String)value2.getText());
                element = ResourceTypeCompletionContributor.decorate(parameters2, types, (LookupElement)element);
                result2.addElement((LookupElement)element);
                allowed.add(value2);
            }
        }
        result2.runRemainingContributors(parameters2, (Consumer)new Consumer<CompletionResult>((Set)allowed, result2){
            final /* synthetic */ Set val$allowed;
            final /* synthetic */ CompletionResultSet val$result;
            {
                this.val$allowed = set;
                this.val$result = completionResultSet;
            }

            public void consume(CompletionResult completionResult) {
                LookupElement element = completionResult.getLookupElement();
                Object object = element.getObject();
                if (object instanceof PsiElement && this.val$allowed.contains(object)) {
                    return;
                }
                this.val$result.passResult(completionResult);
            }
        });
    }

    @Nullable
    private static Constraints getAllowedValues(@NotNull PsiElement pos) {
        Constraints allowedValues = null;
        for (Pair pair : MagicCompletionContributor.getMembersWithAllowedValues((PsiElement)pos)) {
            Constraints values = ResourceTypeCompletionContributor.getAllowedValues((PsiModifierListOwner)pair.first, (PsiType)pair.second, null);
            if (values == null) continue;
            if (allowedValues == null) {
                allowedValues = values;
                continue;
            }
            if (allowedValues.equals(values)) continue;
            return null;
        }
        return allowedValues;
    }

    private static LookupElement decorate(CompletionParameters parameters2, List<ExpectedTypeInfo> types, LookupElement element) {
        if (!types.isEmpty() && parameters2.getCompletionType() == CompletionType.SMART) {
            element = JavaSmartCompletionContributor.decorate((LookupElement)element, types);
        }
        return element;
    }

    @Nullable
    public static Constraints getAllowedValues(@NotNull PsiModifierListOwner element, @Nullable PsiType type, @Nullable Set<PsiClass> visited) {
        PsiAnnotation[] annotations = ResourceTypeCompletionContributor.getAllAnnotations(element);
        PsiManager manager = element.getManager();
        ArrayList resourceTypes = null;
        Constraints constraint = null;
        for (PsiAnnotation annotation : annotations) {
            PsiElement resolved;
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            if (SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(qualifiedName) || qualifiedName.startsWith("test.pkg.")) {
                ResourceType resourceType;
                if (SdkConstants.INT_DEF_ANNOTATION.isEquals(qualifiedName) || SdkConstants.STRING_DEF_ANNOTATION.isEquals(qualifiedName)) {
                    if (type != null && !(annotation instanceof PsiCompiledElement)) {
                        constraint = ResourceTypeCompletionContributor.merge(ResourceTypeCompletionContributor.getAllowedValuesFromTypedef(type, annotation, manager), constraint);
                    }
                } else if (ResourceEvaluator.COLOR_INT_ANNOTATION.isEquals(qualifiedName)) {
                    constraint = ResourceTypeCompletionContributor.merge(new ResourceTypeAllowedValues(Collections.singletonList(ResourceEvaluator.COLOR_INT_MARKER_TYPE)), constraint);
                } else if (ResourceEvaluator.PX_ANNOTATION.isEquals(qualifiedName) || ResourceEvaluator.DIMENSION_ANNOTATION.isEquals(qualifiedName)) {
                    constraint = ResourceTypeCompletionContributor.merge(new ResourceTypeAllowedValues(Collections.singletonList(ResourceEvaluator.DIMENSION_MARKER_TYPE)), constraint);
                } else if (qualifiedName.endsWith("Res") && (resourceType = ResourceTypeCompletionContributor.getResourceTypeFromAnnotation(qualifiedName)) != null) {
                    if (resourceTypes == null) {
                        resourceTypes = Lists.newArrayList();
                    }
                    resourceTypes.add(resourceType);
                }
            }
            if (constraint != null) continue;
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
            if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass aClass = (PsiClass)resolved;
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiClass)aClass)) continue;
            constraint = ResourceTypeCompletionContributor.getAllowedValues((PsiModifierListOwner)aClass, type, (Set<PsiClass>)visited);
        }
        if (resourceTypes != null) {
            constraint = ResourceTypeCompletionContributor.merge(new ResourceTypeAllowedValues(resourceTypes), constraint);
        }
        return constraint;
    }

    @Nullable
    private static Constraints merge(@Nullable Constraints head, @Nullable Constraints tail) {
        if (head != null) {
            if (tail != null) {
                head.next = tail;
                if (tail instanceof AllowedValues) {
                    head.next = tail.next;
                    tail.next = head;
                    head = tail;
                }
            }
            return head;
        }
        return tail;
    }

    @NotNull
    public static PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner element) {
        return (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)AnnotationUtil.getAllAnnotations((PsiModifierListOwner)element, (boolean)true, null), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static Constraints getAllowedValuesFromTypedef(@NotNull PsiType type, @NotNull PsiAnnotation magic, @NotNull PsiManager manager) {
        boolean canBeOred;
        PsiAnnotationMemberValue[] allowedValues;
        boolean isString;
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).getComponentType();
        } else if (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        boolean isInt = TypeConversionUtil.getTypeRank((PsiType)type) <= 5;
        boolean bl = isString = !isInt && type.equals(PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)manager.getProject())));
        if (isInt || isString) {
            PsiAnnotationMemberValue orValue;
            PsiAnnotationMemberValue intValues = magic.findAttributeValue("value");
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = allowedValues = intValues instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)intValues).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
            canBeOred = isInt ? (orValue = magic.findAttributeValue("flag")) instanceof PsiLiteral && Boolean.TRUE.equals(((PsiLiteral)orValue).getValue()) : false;
        } else {
            return null;
        }
        if (allowedValues.length != 0) {
            return new AllowedValues(allowedValues, canBeOred);
        }
        return null;
    }

    private static boolean same(@Nullable PsiElement e1, @Nullable PsiElement e2, @NotNull PsiManager manager) {
        if (e1 instanceof PsiLiteralExpression && e2 instanceof PsiLiteralExpression) {
            return Comparing.equal((Object)((PsiLiteralExpression)e1).getValue(), (Object)((PsiLiteralExpression)e2).getValue());
        }
        if (e1 instanceof PsiPrefixExpression && e2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)e1).getOperationTokenType() == ((PsiPrefixExpression)e2).getOperationTokenType()) {
            return ResourceTypeCompletionContributor.same((PsiElement)((PsiPrefixExpression)e1).getOperand(), (PsiElement)((PsiPrefixExpression)e2).getOperand(), manager);
        }
        if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
            e1 = ((PsiReference)e1).resolve();
            e2 = ((PsiReference)e2).resolve();
        }
        return manager.areElementsEquivalent(e2, e1);
    }

    @Nullable
    public static ResourceType getResourceTypeFromAnnotation(@NotNull String qualifiedName) {
        String resourceTypeName = qualifiedName.startsWith(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName()) ? Character.toLowerCase(qualifiedName.charAt(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName().length())) + qualifiedName.substring(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName().length() + 1, qualifiedName.length() - "Res".length()) : Character.toLowerCase(qualifiedName.charAt(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName().length())) + qualifiedName.substring(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName().length() + 1, qualifiedName.length() - "Res".length());
        return ResourceType.fromClassName((String)resourceTypeName);
    }

    static class ResourceTypeAllowedValues
    extends Constraints {
        @NotNull
        final List<ResourceType> types;

        public ResourceTypeAllowedValues(@NotNull List<ResourceType> types) {
            this.types = types;
        }

        public boolean isTypeAllowed(@NotNull ResourceType type) {
            return this.isTypeAllowed(type.getName());
        }

        public boolean isTypeAllowed(@NotNull String typeName) {
            for (ResourceType type : this.types) {
                if (!type.getName().equals(typeName) && (type != ResourceType.DRAWABLE || !ResourceType.COLOR.getName().equals(typeName) && !ResourceType.MIPMAP.getName().equals(typeName))) continue;
                return true;
            }
            return false;
        }

        public boolean isCompatibleWith(@NotNull ResourceTypeAllowedValues other) {
            for (ResourceType type : other.types) {
                if (!this.isTypeAllowed(type)) continue;
                return true;
            }
            return false;
        }
    }

    static class AllowedValues
    extends Constraints {
        final PsiAnnotationMemberValue[] values;
        final boolean canBeOred;

        private AllowedValues(@NotNull PsiAnnotationMemberValue[] values, boolean canBeOred) {
            this.values = values;
            this.canBeOred = canBeOred;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllowedValues a2 = (AllowedValues)o;
            if (this.canBeOred != a2.canBeOred) {
                return false;
            }
            THashSet v1 = new THashSet(Arrays.asList(this.values));
            THashSet v2 = new THashSet(Arrays.asList(a2.values));
            if (v1.size() != v2.size()) {
                return false;
            }
            block0: for (PsiAnnotationMemberValue value2 : v1) {
                for (PsiAnnotationMemberValue value22 : v2) {
                    if (!ResourceTypeCompletionContributor.same((PsiElement)value2, (PsiElement)value22, value2.getManager())) continue;
                    v2.remove(value22);
                    continue block0;
                }
            }
            return v2.isEmpty();
        }

        public int hashCode() {
            int result2 = Arrays.hashCode(this.values);
            result2 = 31 * result2 + (this.canBeOred ? 1 : 0);
            return result2;
        }

        @Override
        public boolean isSubsetOf(@NotNull Constraints other, @NotNull PsiManager manager) {
            if (!(other instanceof AllowedValues)) {
                return false;
            }
            AllowedValues o = (AllowedValues)other;
            for (PsiAnnotationMemberValue value2 : this.values) {
                boolean found = false;
                for (PsiAnnotationMemberValue otherValue : o.values) {
                    if (!ResourceTypeCompletionContributor.same((PsiElement)value2, (PsiElement)otherValue, manager)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }

    static class Constraints {
        @Nullable
        public Constraints next;

        Constraints() {
        }

        public boolean isSubsetOf(@NotNull Constraints other, @NotNull PsiManager manager) {
            return false;
        }
    }
}

