/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.resources.ResourceType;
import com.google.common.base.CharMatcher;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import java.util.Locale;
import org.jetbrains.android.intentions.AndroidAddStringResourceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAddStringResourceQuickFix
extends AndroidAddStringResourceAction {
    private static final CharMatcher DISALLOWED_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).negate();
    private final PsiElement myStartElement;

    public AndroidAddStringResourceQuickFix(@NotNull PsiElement startElement) {
        this.myStartElement = startElement;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (!this.myStartElement.isValid()) {
            return false;
        }
        XmlAttributeValue value2 = AndroidAddStringResourceQuickFix.getAttributeValue(this.myStartElement);
        return value2 != null && AndroidAddStringResourceQuickFix.getStringLiteralValue(project, (PsiElement)value2, file, ResourceType.STRING) != null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        String value2;
        String defaultName = null;
        PsiElement parent = this.myStartElement.getParent();
        if (parent instanceof XmlAttribute && (value2 = ((XmlAttribute)parent).getValue()) != null) {
            defaultName = AndroidAddStringResourceQuickFix.buildResourceName(value2);
        }
        this.invokeIntention(project, editor2, file, defaultName);
    }

    @NotNull
    static String buildResourceName(@NotNull String value2) {
        String result2 = DISALLOWED_CHARS.trimAndCollapseFrom((CharSequence)value2, '_').toLowerCase(Locale.US);
        if (!result2.isEmpty() && CharMatcher.JAVA_DIGIT.matches(result2.charAt(0))) {
            return "_" + result2;
        }
        return result2;
    }

    public void invokeIntention(Project project, Editor editor2, PsiFile file, @Nullable String resName) {
        XmlAttributeValue attributeValue = AndroidAddStringResourceQuickFix.getAttributeValue(this.myStartElement);
        if (attributeValue != null) {
            AndroidAddStringResourceQuickFix.doInvoke(project, editor2, file, resName, (PsiElement)attributeValue, ResourceType.STRING);
        }
    }

    @Nullable
    private static XmlAttributeValue getAttributeValue(@NotNull PsiElement element) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
        return attribute != null ? attribute.getValueElement() : null;
    }
}

