/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.checks.UselessViewDetector;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class RemoveUselessViewQuickFix
implements AndroidLintQuickFix {
    private final Issue myIssue;

    public RemoveUselessViewQuickFix(@NotNull Issue issue2) {
        this.myIssue = issue2;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag == null) {
            return;
        }
        if (this.myIssue.getId().equals(UselessViewDetector.USELESS_LEAF.getId())) {
            WriteCommandAction.runWriteCommandAction((Project)tag.getProject(), () -> ((XmlTag)tag).delete());
        } else assert (false);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return false;
        }
        return tag.getParentTag() != null;
    }

    @Override
    @NotNull
    public String getName() {
        return AndroidBundle.message("android.lint.fix.remove.unnecessary.view", new Object[0]);
    }
}

