/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import javax.swing.Icon;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetAttributeQuickFix
implements AndroidLintQuickFix {
    private final String myName;
    private final String myFamilyName;
    private final String myAttributeName;
    private final String myValue;
    private final String myNamespace;
    private final int myDot;
    private final int myMark;

    public SetAttributeQuickFix(@NotNull String name, String familyName, @NotNull String attributeName, @Nullable String value2) {
        this(name, familyName, attributeName, "http://schemas.android.com/apk/res/android", value2);
    }

    public SetAttributeQuickFix(@NotNull String name, @Nullable String familyName, @NotNull String attributeName, @Nullable String namespace, @Nullable String value2) {
        this(name, familyName, attributeName, namespace, value2, value2 != null ? 0 : Integer.MIN_VALUE, value2 != null ? value2.length() : Integer.MIN_VALUE);
    }

    public SetAttributeQuickFix(@NotNull String name, @Nullable String familyName, @NotNull String attributeName, @Nullable String namespace, @Nullable String value2, int dot, int mark) {
        this.myName = name;
        this.myFamilyName = familyName;
        this.myAttributeName = attributeName;
        this.myValue = value2;
        this.myNamespace = namespace;
        this.myDot = dot;
        this.myMark = mark;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlAttribute attribute;
        XmlFile file;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return;
        }
        String value2 = this.myValue;
        if (value2 == null && context instanceof AndroidQuickfixContexts.DesignerContext && (value2 = this.askForAttributeValue((PsiElement)tag)) == null) {
            return;
        }
        if (this.myNamespace != null && (file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlFile.class)) != null) {
            AndroidResourceUtil.ensureNamespaceImported(file, this.myNamespace, null);
        }
        if ((attribute = (XmlAttribute)ApplicationManager.getApplication().runWriteAction(() -> this.myNamespace != null ? tag.setAttribute(this.myAttributeName, this.myNamespace, "") : tag.setAttribute(this.myAttributeName, ""))) != null) {
            if (value2 != null && !value2.isEmpty()) {
                String finalValue = value2;
                ApplicationManager.getApplication().runWriteAction(() -> attribute.setValue(finalValue));
            }
            if (context instanceof AndroidQuickfixContexts.EditorContext) {
                Editor editor2 = ((AndroidQuickfixContexts.EditorContext)context).getEditor();
                XmlAttributeValue valueElement = attribute.getValueElement();
                TextRange valueTextRange = attribute.getValueTextRange();
                if (valueElement != null) {
                    int valueElementStart = valueElement.getTextRange().getStartOffset();
                    if (this.myDot != Integer.MIN_VALUE) {
                        int end = valueElementStart + valueTextRange.getStartOffset() + this.myDot;
                        if (this.myMark != Integer.MIN_VALUE && this.myMark != this.myDot) {
                            int start = valueElementStart + valueTextRange.getStartOffset() + this.myMark;
                            editor2.getCaretModel().moveToOffset(end);
                            editor2.getSelectionModel().setSelection(start, end);
                        } else {
                            editor2.getCaretModel().moveToOffset(end);
                        }
                    }
                }
            }
        }
    }

    @Nullable
    private String askForAttributeValue(@NotNull PsiElement context) {
        String[] variants;
        AttributeDefinition def;
        AttributeDefinitions attrDefs;
        FrameworkResourceManager srm;
        AndroidFacet facet = AndroidFacet.getInstance(context);
        String message2 = "Specify value of attribute '" + this.myAttributeName + "'";
        String title = "Set Attribute Value";
        if (facet != null && (srm = ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager()) != null && (attrDefs = srm.getAttributeDefinitions()) != null && (def = attrDefs.getAttrDefByName(this.myAttributeName)) != null && (variants = def.getValues()).length > 0) {
            return Messages.showEditableChooseDialog((String)message2, (String)"Set Attribute Value", (Icon)Messages.getQuestionIcon(), (String[])variants, (String)variants[0], null);
        }
        return Messages.showInputDialog((Project)context.getProject(), (String)message2, (String)"Set Attribute Value", (Icon)Messages.getQuestionIcon());
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (this.myValue == null && contextType == AndroidQuickfixContexts.BatchContext.TYPE) {
            return false;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return false;
        }
        XmlAttribute attribute = this.myNamespace != null ? tag.getAttribute(this.myAttributeName, this.myNamespace) : tag.getAttribute(this.myAttributeName);
        return attribute == null || !StringUtil.notNullize((String)this.myValue).equals(StringUtil.notNullize((String)attribute.getValue()));
    }
}

