/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import javax.swing.JList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class AndroidAddLibraryDependencyAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        return AndroidBundle.message("add.dependency.intention.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Nullable
    private static GradleBuildModel getGradleBuildModel(@NotNull Project project, @NotNull PsiFile file) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = index.getModuleForFile(file.getVirtualFile());
        if (module == null) {
            return null;
        }
        return GradleBuildModel.get(module);
    }

    @NotNull
    private static ImmutableCollection<String> findAllDependencies(@NotNull GradleBuildModel buildModel) {
        HashSet existingDependencies = Sets.newHashSet();
        for (ArtifactDependencyModel dependency : buildModel.dependencies().artifacts()) {
            existingDependencies.add(dependency.group().toString() + ":" + dependency.name().toString());
        }
        ImmutableList.Builder dependenciesBuilder = ImmutableList.builder();
        RepositoryUrlManager repositoryUrlManager = RepositoryUrlManager.get();
        for (GoogleMavenArtifactId id : GoogleMavenArtifactId.values()) {
            GradleCoordinate resolvedCoordinate;
            GradleCoordinate coordinate = id.getCoordinate("+");
            if (existingDependencies.contains(coordinate.getId()) || (resolvedCoordinate = repositoryUrlManager.resolveDynamicCoordinate(coordinate, buildModel.getProject())) == null) continue;
            dependenciesBuilder.add((Object)resolvedCoordinate.toString());
        }
        return dependenciesBuilder.build();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (!(file instanceof GroovyFile) || !file.getName().equals("build.gradle")) {
            return false;
        }
        return AndroidFacet.getInstance((PsiElement)file) != null;
    }

    private static void addDependency(@NotNull Project project, final @NotNull GradleBuildModel buildModel, @NotNull String coordinateString) {
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)coordinateString);
        if (coordinate == null || coordinate.getArtifactId() == null) {
            return;
        }
        final ArtifactDependencySpec newDependency = ArtifactDependencySpec.create(coordinate.getArtifactId(), coordinate.getGroupId(), coordinate.getRevision());
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

            @Override
            public void run() {
                buildModel.dependencies().addArtifact("compile", newDependency);
                buildModel.applyChanges();
            }
        });
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        GradleBuildModel buildModel = AndroidAddLibraryDependencyAction.getGradleBuildModel(project, file);
        if (buildModel == null) {
            return;
        }
        ImmutableCollection<String> dependencies = AndroidAddLibraryDependencyAction.findAllDependencies(buildModel);
        if (dependencies.isEmpty()) {
            return;
        }
        JBList list = new JBList(dependencies);
        JBPopup popup2 = new PopupChooserBuilder((JList)list).setItemChoosenCallback(new Runnable((JList)list, project, buildModel){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Project val$project;
            final /* synthetic */ GradleBuildModel val$buildModel;
            {
                this.val$list = jList;
                this.val$project = project;
                this.val$buildModel = gradleBuildModel;
            }

            @Override
            public void run() {
                for (Object selectedValue : this.val$list.getSelectedValues()) {
                    if (selectedValue == null) {
                        return;
                    }
                    AndroidAddLibraryDependencyAction.addDependency(this.val$project, this.val$buildModel, (String)selectedValue);
                }
            }
        }).createPopup();
        popup2.showInBestPositionFor(editor2);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

