/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.android.util.ErrorReporter;
import org.jetbrains.android.util.HintBasedErrorReporter;
import org.jetbrains.android.util.ProjectBasedErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidInlineStyleHandler
extends InlineActionHandler {
    private static AndroidInlineTestConfig ourTestConfig;

    public static void setTestConfig(@Nullable AndroidInlineTestConfig testConfig) {
        ourTestConfig = testConfig;
    }

    public boolean isEnabledForLanguage(Language l) {
        return l == XMLLanguage.INSTANCE;
    }

    public boolean canInlineElement(PsiElement element) {
        return element != null && AndroidFacet.getInstance(element) != null && AndroidInlineUtil.getInlinableStyleDataFromContext(element) != null;
    }

    public void inlineElement(Project project, Editor editor2, PsiElement element) {
        AndroidInlineUtil.MyStyleData data = AndroidInlineUtil.getInlinableStyleDataFromContext(element);
        if (data != null) {
            PsiReference reference2;
            ErrorReporter reporter = editor2 != null ? new HintBasedErrorReporter(editor2) : new ProjectBasedErrorReporter(project);
            StyleUsageData usageData = null;
            if (editor2 != null && (reference2 = TargetElementUtil.findReference((Editor)editor2)) instanceof AndroidResourceReferenceBase) {
                usageData = AndroidInlineStyleHandler.getUsageDataFromEditor(reference2);
            }
            AndroidInlineUtil.doInlineStyleDeclaration(project, data, usageData, reporter, ourTestConfig);
        }
    }

    @Nullable
    private static StyleUsageData getUsageDataFromEditor(@NotNull PsiReference reference2) {
        PsiElement usageElement = reference2.getElement();
        if (usageElement == null) {
            return null;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)usageElement, XmlTag.class, (boolean)false);
        return tag != null ? AndroidInlineUtil.getStyleUsageData(tag) : null;
    }
}

