/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.tools.idea.actions.ExportProjectZip;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.PairFunction;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil$sam$java_lang_Runnable$0;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.util.ErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0007\u001a\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001f\u001a\u0016\u0010 \u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"ACTION_WARNING_TEXT", "", "RESULT_CANCEL", "", "RESULT_MIGRATE", "RESULT_MIGRATE_WITH_BACKUP", "computeAttributeMap", "", "Lorg/jetbrains/android/refactoring/AndroidAttributeInfo;", "style", "Lorg/jetbrains/android/dom/resources/Style;", "errorReporter", "Lorg/jetbrains/android/util/ErrorReporter;", "errorReportTitle", "findOrCreateClass", "Lcom/intellij/psi/PsiClass;", "project", "Lcom/intellij/openapi/project/Project;", "migration", "Lcom/intellij/psi/PsiMigration;", "qName", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findOrCreatePackage", "Lcom/intellij/psi/PsiPackage;", "getParentStyle", "Lorg/jetbrains/android/refactoring/StyleRefData;", "offerToCreateBackupAndRun", "", "title", "runRefactoring", "Lkotlin/Function0;", "syncBeforeFinishingRefactoring", "trigger", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$Trigger;", "intellij.android.core"})
@JvmName(name="AndroidRefactoringUtil")
public final class AndroidRefactoringUtil {
    private static final int RESULT_MIGRATE_WITH_BACKUP = 0;
    private static final int RESULT_MIGRATE = 1;
    private static final int RESULT_CANCEL = 2;
    private static final String ACTION_WARNING_TEXT = "\nBefore proceeding, we recommend that you make a backup of your project.\n\nDepending on your project dependencies, you might need to manually fix\nsome errors after the refactoring in order to successfully compile your project.\n\nDo you want to proceed with the migration?\n";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final StyleRefData getParentStyle(@NotNull Style style) {
        StyleRefData styleRefData;
        ResourceValue parentStyleRefValue = (ResourceValue)style.getParentStyle().getValue();
        if (parentStyleRefValue != null) {
            String string;
            String string2 = parentStyleRefValue.getResourceName();
            if (string2 == null) return null;
            String it = string = string2;
            boolean bl = false;
            styleRefData = new StyleRefData(it, parentStyleRefValue.getPackage());
            return styleRefData;
        } else {
            String string;
            String string3 = style.getName().getStringValue();
            String string4 = string3;
            if (string3 == null) return null;
            String it = string = string4;
            boolean bl = false;
            if (StringsKt.indexOf$default((CharSequence)it, (char)'.', (int)0, (boolean)false, (int)6, null) <= 0) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            String string5 = string;
            string4 = string5;
            if (string5 == null) return null;
            it = string = string4;
            boolean bl3 = false;
            styleRefData = new StyleRefData(StringsKt.substringBeforeLast$default((String)it, (char)'.', null, (int)2, null), null);
        }
        return styleRefData;
    }

    @Nullable
    public static final Map<AndroidAttributeInfo, String> computeAttributeMap(@NotNull Style style, @NotNull ErrorReporter errorReporter, @NotNull String errorReportTitle) {
        Map attributeValues = new LinkedHashMap();
        for (StyleItem item : style.getItems()) {
            CharSequence charSequence;
            String attributeName = item.getName().getStringValue();
            String attributeValue = item.getStringValue();
            if (attributeName == null || (charSequence = (CharSequence)attributeName).length() == 0 || attributeValue == null) continue;
            String localName = StringsKt.substringAfterLast$default((String)attributeName, (char)':', null, (int)2, null);
            String nsPrefix = StringsKt.substringBefore((String)attributeName, (char)':', (String)"");
            Object object = nsPrefix;
            if (object.length() > 0) {
                if (Intrinsics.areEqual((Object)"android", (Object)nsPrefix) ^ true) {
                    errorReporter.report(RefactoringBundle.getCannotRefactorMessage((String)("Unknown XML attribute prefix '" + nsPrefix + ":'")), errorReportTitle);
                    return null;
                }
            } else {
                errorReporter.report(RefactoringBundle.getCannotRefactorMessage((String)"The style contains attribute without 'android' prefix."), errorReportTitle);
                return null;
            }
            object = attributeValues;
            AndroidAttributeInfo androidAttributeInfo = new AndroidAttributeInfo(localName, nsPrefix);
            String string = attributeValue;
            object.put(androidAttributeInfo, string);
        }
        return attributeValues;
    }

    @JvmOverloads
    @NotNull
    public static final PsiClass findOrCreateClass(@NotNull Project project, @NotNull PsiMigration migration, @NotNull String qName, @NotNull GlobalSearchScope scope) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(qName, scope);
        if (psiClass == null) {
            boolean $i$f$runWriteAction = false;
            psiClass = (PsiClass)ApplicationManager.getApplication().runWriteAction(new Computable<T>(migration, qName){
                final /* synthetic */ PsiMigration $migration$inlined;
                final /* synthetic */ String $qName$inlined;
                {
                    this.$migration$inlined = psiMigration;
                    this.$qName$inlined = string;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.$migration$inlined.createClass(this.$qName$inlined);
                }
            });
        }
        return psiClass;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ PsiClass findOrCreateClass$default(Project project, PsiMigration psiMigration, String string, GlobalSearchScope globalSearchScope, int n, Object object) {
        if ((n & 8) != 0) {
            globalSearchScope = GlobalSearchScope.allScope((Project)project);
        }
        return AndroidRefactoringUtil.findOrCreateClass(project, psiMigration, string, globalSearchScope);
    }

    @JvmOverloads
    @NotNull
    public static final PsiClass findOrCreateClass(@NotNull Project project, @NotNull PsiMigration migration, @NotNull String qName) {
        return AndroidRefactoringUtil.findOrCreateClass$default(project, migration, qName, null, 8, null);
    }

    @NotNull
    public static final PsiPackage findOrCreatePackage(@NotNull Project project, @NotNull PsiMigration migration, @NotNull String qName) {
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(qName);
        if (psiPackage == null) {
            boolean $i$f$runWriteAction = false;
            psiPackage = (PsiPackage)ApplicationManager.getApplication().runWriteAction(new Computable<T>(migration, qName){
                final /* synthetic */ PsiMigration $migration$inlined;
                final /* synthetic */ String $qName$inlined;
                {
                    this.$migration$inlined = psiMigration;
                    this.$qName$inlined = string;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.$migration$inlined.createPackage(this.$qName$inlined);
                }
            });
        }
        return psiPackage;
    }

    public static final void offerToCreateBackupAndRun(@NotNull Project project, @NotNull String title, @NotNull Function0<Unit> runRefactoring) {
        String string = ACTION_WARNING_TEXT;
        int okCancelResult2 = Messages.showCheckboxMessageDialog((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)title, (String[])new String[]{"Migrate", "Cancel"}, (String)"Backup project as Zip file", (boolean)true, (int)0, (int)0, (Icon)Messages.getWarningIcon(), (PairFunction)offerToCreateBackupAndRun.okCancelResult.1.INSTANCE);
        switch (okCancelResult2) {
            case 2: {
                return;
            }
            case 0: {
                ExportProjectZip exportZip = new ExportProjectZip();
                AnAction anAction = exportZip;
                DataContext dataContext = SimpleDataContext.getProjectContext((Project)project);
                Object object = runRefactoring;
                if (object != null) {
                    Function0<Unit> function0 = object;
                    object = new AndroidRefactoringUtil$sam$java_lang_Runnable$0(function0);
                }
                ActionUtil.invokeAction((AnAction)anAction, (DataContext)dataContext, (String)title, null, (Runnable)((Runnable)object));
                break;
            }
            default: {
                runRefactoring.invoke();
            }
        }
    }

    public static final void syncBeforeFinishingRefactoring(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger) {
        boolean bl = ApplicationManager.getApplication().isDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        GradleSyncInvoker.getInstance().requestProjectSync(project, new GradleSyncInvoker.Request(trigger));
    }
}

