/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.refactoring.AndroidRefactoringErrorException;
import org.jetbrains.annotations.NotNull;

public class LayoutUsageData {
    private final Project myProject;
    private final XmlTag myIncludeTag;
    private final AndroidResourceReferenceBase myReference;

    public LayoutUsageData(@NotNull Project project, @NotNull XmlTag includeTag, @NotNull AndroidResourceReferenceBase reference2) {
        this.myProject = project;
        this.myIncludeTag = includeTag;
        this.myReference = reference2;
    }

    @NotNull
    public AndroidResourceReferenceBase getReference() {
        return this.myReference;
    }

    public void inline(@NotNull XmlTag layoutRootTag) throws AndroidRefactoringErrorException {
        XmlTag parent = this.myIncludeTag.getParentTag();
        if ("merge".equals(layoutRootTag.getName()) && parent != null) {
            LayoutUsageData.inlineMultiTags(this.myIncludeTag, parent, layoutRootTag, this.myProject);
        } else {
            LayoutUsageData.inlineSingleTag(this.myIncludeTag, parent, layoutRootTag);
        }
    }

    private static void inlineSingleTag(XmlTag includeTag, XmlTag includeParentTag, XmlTag layoutRootTag) {
        HashMap attributesToAdd = new HashMap();
        for (XmlAttribute xmlAttribute : includeTag.getAttributes()) {
            String namespace = xmlAttribute.getNamespace();
            if (!"http://schemas.android.com/apk/res/android".equals(namespace)) continue;
            attributesToAdd.put(xmlAttribute.getLocalName(), xmlAttribute.getValue());
        }
        XmlTag newTag = (XmlTag)includeTag.replace(layoutRootTag.copy());
        ArrayList<XmlAttribute> toDelete = new ArrayList<XmlAttribute>();
        for (XmlAttribute attribute : newTag.getAttributes()) {
            if (!attribute.isNamespaceDeclaration()) continue;
            String localName = attribute.getLocalName();
            String prefix = localName.equals(attribute.getName()) ? "" : localName;
            String namespace = attribute.getValue();
            if (includeParentTag == null || !namespace.equals(includeParentTag.getNamespaceByPrefix(prefix))) continue;
            toDelete.add(attribute);
        }
        for (XmlAttribute xmlAttribute : toDelete) {
            xmlAttribute.delete();
        }
        for (Map.Entry entry : attributesToAdd.entrySet()) {
            String localName = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            newTag.setAttribute(localName, "http://schemas.android.com/apk/res/android", value2);
        }
        CodeStyleManager.getInstance((PsiManager)newTag.getManager()).reformat((PsiElement)newTag);
    }

    private static void inlineMultiTags(XmlTag includeTag, XmlTag includeTagParent, XmlTag mergeTag, Project project) throws AndroidRefactoringErrorException {
        Map namespacesFromParent = includeTagParent.getLocalNamespaceDeclarations();
        HashMap namespacesToAddToParent = new HashMap();
        HashMap namespacesToAddToEachTag = new HashMap();
        for (Map.Entry entry : mergeTag.getLocalNamespaceDeclarations().entrySet()) {
            String prefix = (String)entry.getKey();
            String namespace = (String)entry.getValue();
            String declaredNamespace = (String)namespacesFromParent.get(prefix);
            if (declaredNamespace != null && !declaredNamespace.equals(namespace)) {
                namespacesToAddToEachTag.put(prefix, namespace);
                continue;
            }
            namespacesToAddToParent.put(prefix, namespace);
        }
        XmlTag mergeTagCopy = (XmlTag)mergeTag.copy();
        XmlElementFactory xmlElementFactory = XmlElementFactory.getInstance((Project)project);
        for (XmlTag subtag : mergeTagCopy.getSubTags()) {
            XmlAttribute[] attributes = subtag.getAttributes();
            XmlAttribute firstAttribute = attributes.length > 0 ? attributes[0] : null;
            for (Map.Entry entry : namespacesToAddToEachTag.entrySet()) {
                String prefix = (String)entry.getKey();
                String namespace = (String)entry.getValue();
                if (subtag.getLocalNamespaceDeclarations().containsKey(prefix)) continue;
                XmlAttribute xmlnsAttr = xmlElementFactory.createXmlAttribute("xmlns:" + prefix, namespace);
                if (firstAttribute != null) {
                    subtag.addBefore((PsiElement)xmlnsAttr, (PsiElement)firstAttribute);
                    continue;
                }
                subtag.add((PsiElement)xmlnsAttr);
            }
        }
        LayoutUsageData.replaceByTagContent(project, includeTag, mergeTagCopy);
        LayoutUsageData.addNamespaceAttributes(includeTagParent, (Map<String, String>)namespacesToAddToParent, project);
    }

    private static void addNamespaceAttributes(XmlTag tag, Map<String, String> namespaces, Project project) {
        XmlAttribute[] parentAttributes = tag.getAttributes();
        XmlAttribute firstParentAttribute = parentAttributes.length > 0 ? parentAttributes[0] : null;
        XmlElementFactory factory = XmlElementFactory.getInstance((Project)project);
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            String prefix = entry.getKey();
            String namespace = entry.getValue();
            if (namespace.equals(tag.getNamespaceByPrefix(prefix))) continue;
            XmlAttribute xmlnsAttr = factory.createXmlAttribute("xmlns:" + prefix, namespace);
            if (firstParentAttribute != null) {
                tag.addBefore((PsiElement)xmlnsAttr, (PsiElement)firstParentAttribute);
                continue;
            }
            tag.add((PsiElement)xmlnsAttr);
        }
    }

    private static void replaceByTagContent(Project project, XmlTag tagToReplace, XmlTag tagToInline) throws AndroidRefactoringErrorException {
        ASTNode node = tagToInline.getNode();
        if (node == null) {
            throw new AndroidRefactoringErrorException();
        }
        ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(node);
        ASTNode closingTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(node);
        if (startTagEnd == null || closingTagStart == null) {
            throw new AndroidRefactoringErrorException();
        }
        int contentStart = startTagEnd.getTextRange().getEndOffset();
        int contentEnd = closingTagStart.getTextRange().getStartOffset();
        if (contentStart < 0 || contentEnd < 0 || contentStart >= contentEnd) {
            throw new AndroidRefactoringErrorException();
        }
        PsiFile file = tagToInline.getContainingFile();
        if (file == null) {
            throw new AndroidRefactoringErrorException();
        }
        String textToInline = file.getText().substring(contentStart, contentEnd).trim();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(tagToReplace.getContainingFile());
        if (document == null) {
            throw new AndroidRefactoringErrorException();
        }
        TextRange range = tagToReplace.getTextRange();
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)textToInline);
        documentManager.commitDocument(document);
    }
}

